/*
 * Copyright (C) 2004-2006 Jimmy Do <crispyleaves@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
#ifndef ADD_PRESET_DIALOG_H
#define ADD_PRESET_DIALOG_H
#include <gtk/gtk.h>

G_BEGIN_DECLS

typedef void (*PresetAddedCallback) (GtkWidget *add_preset_dialog, gchar *preset_name, guint preset_duration, gpointer user_data);
typedef void (*PresetEditedCallback) (GtkWidget *add_preset_dialog, GtkTreeRowReference *row_ref, gchar *preset_name,
									guint preset_duration, gpointer user_data);
typedef gboolean (*NameValidator) (const gchar *preset_name, const gchar *ignore_name, gpointer user_data);

GtkWidget *
add_preset_dialog_new (NameValidator name_validator, gpointer user_data);

void
add_preset_dialog_open (GtkWidget *add_preset_dialog, gchar *dialog_title, gchar *preset_name, guint preset_duration, GtkTreeRowReference *editing_preset);

void
add_preset_dialog_set_handlers (GtkWidget *add_preset_dialog, PresetAddedCallback added_cb, gpointer user_data1, PresetEditedCallback edited_cb, gpointer user_data2);

G_END_DECLS

#endif /* ADD_PRESET_DIALOG_H */
