#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "term_cb.h"
#include "term_dbox.h"
#include "support.h"

#include "tilibs.h"
#include "struct.h"

#include "help_dbox.h"
#include "help_cb.h"
#include "manpage_dbox.h"
#include "manpage_cb.h"
#include "about_dbox.h"
#include "about_cb.h"
#include "error.h"

static GtkWidget   *term_window;
static GdkColormap *cmap;
static GdkColor    colour;
static GdkFont     *fixed_font;
static GtkWidget   *text;

gint display_term_dbox()
{
  gtk_widget_show_all(create_term_dbox());
  return 0;
}

void
on_term_dbox_show_text                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
  text = GTK_WIDGET(user_data);
  
  /* Get the system colour map and allocate the colour red */
  cmap = gdk_colormap_get_system();
  colour.red = 0xffff;
  colour.green = 0;
  colour.blue = 0;
  if(!gdk_color_alloc(cmap, &colour)) 
    {
      fprintf(stderr, "couldn't allocate colour");
    }

  /* Load a fixed font */
  //fixed_font = gdk_font_load ("-misc-fixed-medium-r-*-*-*-140-*-*-*-*-*-*");
  fixed_font = gdk_font_load("-rli-ti92-calc-r-expanded--10-100-75-75-m-80-iso8859-1");

  /* Init */
  gtk_text_freeze (GTK_TEXT (text));
  gtk_text_insert(GTK_TEXT(text), fixed_font, &colour, NULL,
		  "Some keys are mapped as is:\n", -1);
  if( (options.lp.calc_type == CALC_TI92P) || 
      (options.lp.calc_type == CALC_TI92) )
    {
      gtk_text_insert (GTK_TEXT (text), fixed_font, &colour, NULL,
		       "\n"
		       "^ = SHIFT      Diamond = CTRL      2nd = Alt  \n"
		       "Hand=CAPS      F9 = APPS           Theta = ;  \n"
		       "STO = Tab      MODE = '            LN = \\    \n"
		       "SIN = Ins      COS = Home          TAN = PgUp \n"
		       "CLEAR = Del    (-) = Enter (NumPad)           \n",
		       -1);
      gtk_text_thaw (GTK_TEXT (text));
    }
  else
    {
      gtk_text_insert (GTK_TEXT (text), fixed_font, &colour, NULL,
		       "\n"
		       "^ = SHIFT       Diamond = CTRL     2nd = Alt  \n"
		       "alpha = CAPS    CATALOG = F6       APPS = F9  \n"
		       "STO> = Tab      MODE = '           | = \\     \n"
		       "EE = Ins        CLEAR = Del                   \n",
		       -1);
      gtk_text_thaw (GTK_TEXT (text));
    }

  gtk_text_insert(GTK_TEXT(text), fixed_font, &colour, NULL,
		  "\nUse the numeric keypad for numbers too (but think to enable it !!!).", -1);
  gtk_text_insert(GTK_TEXT(text), fixed_font, &colour, NULL,
		  "\nThis mapping has been designed for a 'qwerty' keyboard.", 
		  -1);
  //gtk_window_set_focus(GTK_WINDOW(term_window), GTK_WIDGET(text));
}

void
on_term_dbox_show_dbox                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
  term_window = GTK_WIDGET(user_data);
}


void
on_term_quit1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_destroy(term_window);
}


void
on_term_help3_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_help_dbox();
}


void
on_term_manpage1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_widget_show_all(create_manpage_dbox());
}


void
on_term_about1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  display_about_dbox();
}

static void key_pressed89(guint nChar, guint wChar);
static void key_pressed92(guint nChar, guint wChar);

gboolean
on_text1_key_press_event               (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
  GdkEventKey *key_event;
  guint key = 0;

  key_event = (GdkEventKey *)event;
  key = key_event->keyval;
  printf("Key value: %8s %04X\n", gdk_keyval_name(key), key);

  if( (options.lp.calc_type == CALC_TI92P) || 
      (options.lp.calc_type == CALC_TI92) )
    key_pressed92(key, 0x00ff & key);
  else
    key_pressed89(key, 0x00ff & key);
  
  return FALSE;
}

/*****************/

#if defined(__WIN32__)
# include "keys89.h"
# include "keys92p.h"
#endif
extern const struct ti_key TI89_KEYS[];
extern const struct ti_key TI92P_KEYS[];

static void key_pressed89(guint nChar, guint wChar)
{
  word key = 0;
  word index = 0;
  static int flag = 0;
  int processed = 1;
  static int modifier = 0;
  
  // PC keyboard processing
  switch(nChar)
    {
      // Remap some keys (TI specific)
    case GDK_F1: index = KEY89_F1; break;
    case GDK_F2: index = KEY89_F2; break;
    case GDK_F3: index = KEY89_F3; break;
    case GDK_F4: index = KEY89_F4; break;
    case GDK_F5: index = KEY89_F5; break;
    case GDK_F6: index = 278/*KEY89_CATLG*/; break;
    case GDK_F9: index = KEY89_APPS; break;
    
    case GDK_Tab: index = KEY92_STO; break;
    case GDK_Insert: index = 149/*KEY89_EE*/; break;
    case GDK_Delete: index = KEY92_CLEAR; break;
    case GDK_KP_Decimal: index = KEY89_NEG; break; // NumPad dot
    
    case GDK_Up: index = KEY89_UP; break;
    case GDK_Down: index = KEY89_DOWN; break;
    case GDK_Left: index = KEY89_LEFT; break;
    case GDK_Right: index = KEY89_RIGHT; break;

    case GDK_KP_0: index = KEY89_0; break;
    case GDK_KP_1: index = KEY89_1; break;
    case GDK_KP_2: index = KEY89_2; break;
    case GDK_KP_3: index = KEY89_3; break;
    case GDK_KP_4: index = KEY89_4; break;
    case GDK_KP_5: index = KEY89_5; break;
    case GDK_KP_6: index = KEY89_6; break;
    case GDK_KP_7: index = KEY89_7; break;
    case GDK_KP_8: index = KEY89_8; break;
    case GDK_KP_9: index = KEY89_9; break;      

    case GDK_KP_Divide: index = KEY89_DIVIDE; break;
    case GDK_KP_Multiply: index = KEY89_MULT; break;
    case GDK_KP_Add: index = KEY89_PLUS; break;
    case GDK_KP_Subtract: index = KEY89_MINUS; break;

      // Get modifier keys
    case GDK_Control_L: flag = 1; modifier=1;
      break;
    case GDK_Shift_L:	flag = 2; modifier=1;
      break;
    case GDK_Alt_L:	flag = 3; modifier=1;
      break;
    case GDK_Caps_Lock: flag = 4; modifier=1;
    default: processed = 0; modifier = 0; break;
    }
  
  if(modifier && flag) return;
  
  // Unicode characters processing
  if(!processed)
    {
      switch(wChar)
	{
	case '\\': index = 124/*KEY89_TUBE*/; break;
	case '\'': index = KEY89_MODE; break;
	default: index = wChar; break;
	}
    }

  // Get the final TI scancode
  if(!flag)
    key = TI89_KEYS[index].nothing;
  else
    {
      if(flag == 1)
	key = TI89_KEYS[index].diamond;
      else if(flag == 2)
	key = TI89_KEYS[index].shift;
      else if(flag == 3)
	key = TI89_KEYS[index].second;
      else if(flag == 4)
	key = TI89_KEYS[index].alpha;
      else
	DISPLAY("Remote Control: internal key error");
      flag = 0;
    }
  
  tilp_error(ti_calc.send_key(key));

  return; 
}

static void key_pressed92(guint nChar, guint wChar)
{
  word key = 0;
  word index = 0;
  static int flag = 0;
  int processed = 1;
  static int modifier = 0;
  
  // PC keyboard processing
  switch(nChar)
    {
      // Remap some keys (TI specific)
    case GDK_F1: index = KEY92p_F1; break;
    case GDK_F2: index = KEY92p_F2; break;
    case GDK_F3: index = KEY92p_F3; break;
    case GDK_F4: index = KEY92p_F4; break;
    case GDK_F5: index = KEY92p_F5; break;
    case GDK_F6: index = KEY92p_F6; break;
    case GDK_F7: index = KEY92p_F7; break;
    case GDK_F8: index = KEY92p_F8; break;
    case GDK_F9: index = KEY92p_APPS; break;
      
    case GDK_Tab: index = KEY92_STO; break;
    case GDK_Insert: index = KEY92_SIN; break;
    case GDK_Home: index = KEY92_COS; break;
    case GDK_Prior: index = KEY92_TAN; break;

    case GDK_Delete: index = KEY92_CLEAR; break;
    case GDK_KP_Decimal: index = KEY92p_NEG; break; // NumPad dot
    
    case GDK_Up: index = KEY92p_UP; break;
    case GDK_Down: index = KEY92p_DOWN; break;
    case GDK_Left: index = KEY92p_LEFT; break;
    case GDK_Right: index = KEY92p_RIGHT; break;

    case GDK_KP_0: index = KEY92p_0; break;
    case GDK_KP_1: index = KEY92p_1; break;
    case GDK_KP_2: index = KEY92p_2; break;
    case GDK_KP_3: index = KEY92p_3; break;
    case GDK_KP_4: index = KEY92p_4; break;
    case GDK_KP_5: index = KEY92p_5; break;
    case GDK_KP_6: index = KEY92p_6; break;
    case GDK_KP_7: index = KEY92p_7; break;
    case GDK_KP_8: index = KEY92p_8; break;
    case GDK_KP_9: index = KEY92p_9; break;      

    case GDK_KP_Divide: index = KEY92p_DIVIDE; break;
    case GDK_KP_Multiply: index = KEY92p_MULT; break;
    case GDK_KP_Add: index = KEY92p_PLUS; break;
    case GDK_KP_Subtract: index = KEY92p_MINUS; break;

      // Get modifier keys
    case GDK_Control_L: flag = 1; modifier=1;
      break;
    case GDK_Shift_L:	flag = 2; modifier=1;
      break;
    case GDK_Alt_L:	flag = 3; modifier=1;
      break;
    case GDK_Caps_Lock: flag = 4; modifier=1;
      break;

      // Reject some keys -> TI frozen
    case GDK_twosuperior: return; break;

    default: processed = 0; modifier = 0; break;
    }
  
  if(modifier && flag) return;
  
  // Unicode characters processing
  if(!processed)
    {
      switch(wChar)
	{
	case '\\': index = KEY92p_LN; break;
	case ';': index = KEY92p_THETA; break;
	default: index = wChar; break;
	}
    }

  // Get the final TI scancode
  if(!flag)
    key = TI92P_KEYS[index].nothing;
  else
    {
      if(flag == 1)
	key = TI92P_KEYS[index].diamond;
      else if(flag == 2)
	key = TI92P_KEYS[index].shift;
      else if(flag == 3)
	key = TI92P_KEYS[index].second;
      else if(flag == 4)
	key = TI92P_KEYS[index].alpha;
      else
	DISPLAY("Remote Control: internal key error");
      flag = 0;
    }
  
  tilp_error(ti_calc.send_key(key));

  return; 
}

/* */

