
#ifdef __MINGW32__
#include <cmath> // included before Python.h to fix ::hypot not declared issue
#endif

/* This file was generated by PyBindGen 0.17.0 */
#define PY_SSIZE_T_CLEAN
#include <Python.h>
#include <stddef.h>


#if PY_VERSION_HEX < 0x020400F0

#define PyEval_ThreadsInitialized() 1

#define Py_CLEAR(op)				\
        do {                            	\
                if (op) {			\
                        PyObject *tmp = (PyObject *)(op);	\
                        (op) = NULL;		\
                        Py_DECREF(tmp);		\
                }				\
        } while (0)


#define Py_VISIT(op)							\
        do { 								\
                if (op) {						\
                        int vret = visit((PyObject *)(op), arg);	\
                        if (vret)					\
                                return vret;				\
                }							\
        } while (0)

#endif



#if PY_VERSION_HEX < 0x020500F0

typedef int Py_ssize_t;
# define PY_SSIZE_T_MAX INT_MAX
# define PY_SSIZE_T_MIN INT_MIN
typedef inquiry lenfunc;
typedef intargfunc ssizeargfunc;
typedef intobjargproc ssizeobjargproc;

#endif


#ifndef PyVarObject_HEAD_INIT
#define PyVarObject_HEAD_INIT(type, size) \
        PyObject_HEAD_INIT(type) size,
#endif


#if PY_VERSION_HEX >= 0x03000000
typedef void* cmpfunc;
#define PyCObject_FromVoidPtr(a, b) PyCapsule_New(a, NULL, b)
#define PyCObject_AsVoidPtr(a) PyCapsule_GetPointer(a, NULL)
#define PyString_FromString(a) PyBytes_FromString(a)
#define Py_TPFLAGS_CHECKTYPES 0 /* this flag doesn't exist in python 3 */
#endif


#if     __GNUC__ > 2
# define PYBINDGEN_UNUSED(param) param __attribute__((__unused__))
#elif     __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ > 4)
# define PYBINDGEN_UNUSED(param) __attribute__((__unused__)) param
#else
# define PYBINDGEN_UNUSED(param) param
#endif  /* !__GNUC__ */

#ifndef _PyBindGenWrapperFlags_defined_
#define _PyBindGenWrapperFlags_defined_
typedef enum _PyBindGenWrapperFlags {
   PYBINDGEN_WRAPPER_FLAG_NONE = 0,
   PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED = (1<<0),
} PyBindGenWrapperFlags;
#endif


#include "pythonplugin.h"
#include "map.h"
#include "layer.h"
#include "tile.h"
#include "mapobject.h"
#include "imagelayer.h"
#include "tilelayer.h"
#include "objectgroup.h"
#include "tileset.h"
#include <QImage>
#include <QFileDialog>
#include <QWidget>
#include <QFlags>
/* --- forward declarations --- */


typedef struct {
    PyObject_HEAD
    Python::PythonScript *obj;
    PyObject *inst_dict;
    PyBindGenWrapperFlags flags:8;
} PyPythonPythonScript;


extern PyTypeObject PyPythonPythonScript_Type;

/* --- forward declarations --- */


typedef struct {
    PyObject_HEAD
    QPointF *obj;
    PyBindGenWrapperFlags flags:8;
} PyQPointF;


extern PyTypeObject PyQPointF_Type;


typedef struct {
    PyObject_HEAD
    QSizeF *obj;
    PyBindGenWrapperFlags flags:8;
} PyQSizeF;


extern PyTypeObject PyQSizeF_Type;


typedef struct {
    PyObject_HEAD
    QRgb *obj;
    PyBindGenWrapperFlags flags:8;
} PyQRgb;


extern PyTypeObject PyQRgb_Type;


typedef struct {
    PyObject_HEAD
    QColor *obj;
    PyBindGenWrapperFlags flags:8;
} PyQColor;


extern PyTypeObject PyQColor_Type;


typedef struct {
    PyObject_HEAD
    QImage *obj;
    PyBindGenWrapperFlags flags:8;
} PyQImage;


extern PyTypeObject PyQImage_Type;


typedef struct {
    PyObject_HEAD
    QPixmap *obj;
    PyBindGenWrapperFlags flags:8;
} PyQPixmap;


extern PyTypeObject PyQPixmap_Type;


typedef struct {
    PyObject_HEAD
    QWidget *obj;
    PyBindGenWrapperFlags flags:8;
} PyQWidget;


extern PyTypeObject PyQWidget_Type;


typedef struct {
    PyObject_HEAD
    QFileDialog *obj;
    PyBindGenWrapperFlags flags:8;
} PyQFileDialog;


extern PyTypeObject PyQFileDialog_Type;


typedef struct {
    PyObject_HEAD
    QVector<QRgb> *obj;
} PyQVector__lt__QRgb__gt__;


typedef struct {
    PyObject_HEAD
    PyQVector__lt__QRgb__gt__ *container;
    QVector<QRgb>::iterator *iterator;
} PyQVector__lt__QRgb__gt__Iter;


extern PyTypeObject PyQVector__lt__QRgb__gt___Type;
extern PyTypeObject PyQVector__lt__QRgb__gt__Iter_Type;

int _wrap_convert_py2c__QVector__lt___QRgb___gt__(PyObject *arg, QVector<QRgb> *container);

typedef struct {
    PyObject_HEAD
    QList<QString> *obj;
} PyQList__lt__QString__gt__;


typedef struct {
    PyObject_HEAD
    PyQList__lt__QString__gt__ *container;
    QList<QString>::iterator *iterator;
} PyQList__lt__QString__gt__Iter;


extern PyTypeObject PyQList__lt__QString__gt___Type;
extern PyTypeObject PyQList__lt__QString__gt__Iter_Type;

int _wrap_convert_py2c__QList__lt___QString___gt__(PyObject *arg, QList<QString> *container);
/* --- forward declarations --- */


typedef struct {
    PyObject_HEAD
    Tiled::Properties *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledProperties;


extern PyTypeObject PyTiledProperties_Type;


typedef struct {
    PyObject_HEAD
    Tiled::Object *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledObject;


extern PyTypeObject PyTiledObject_Type;


typedef struct {
    PyObject_HEAD
    Tiled::Tile *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledTile;


extern PyTypeObject PyTiledTile_Type;


typedef struct {
    PyObject_HEAD
    Tiled::SharedTileset *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledSharedTileset;


extern PyTypeObject PyTiledSharedTileset_Type;


typedef struct {
    PyObject_HEAD
    Tiled::Tileset *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledTileset;


extern PyTypeObject PyTiledTileset_Type;


typedef struct {
    PyObject_HEAD
    Tiled::Layer *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledLayer;


extern PyTypeObject PyTiledLayer_Type;


typedef struct {
    PyObject_HEAD
    Tiled::Map *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledMap;


extern PyTypeObject PyTiledMap_Type;


typedef struct {
    PyObject_HEAD
    Tiled::Cell *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledCell;


extern PyTypeObject PyTiledCell_Type;


typedef struct {
    PyObject_HEAD
    Tiled::TileLayer *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledTileLayer;


extern PyTypeObject PyTiledTileLayer_Type;


typedef struct {
    PyObject_HEAD
    Tiled::ImageLayer *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledImageLayer;


extern PyTypeObject PyTiledImageLayer_Type;


typedef struct {
    PyObject_HEAD
    Tiled::MapObject *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledMapObject;


extern PyTypeObject PyTiledMapObject_Type;


typedef struct {
    PyObject_HEAD
    Tiled::ObjectGroup *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledObjectGroup;


extern PyTypeObject PyTiledObjectGroup_Type;


typedef struct {
    PyObject_HEAD
    Tiled::LoggingInterface *obj;
    PyBindGenWrapperFlags flags:8;
} PyTiledLoggingInterface;


extern PyTypeObject PyTiledLoggingInterface_Type;

#pragma GCC diagnostic ignored "-Wmissing-field-initializers"

int _wrap_convert_py2c__QRgb(PyObject *value, QRgb *address);


int _wrap_convert_py2c__QString(PyObject *value, QString *address);

static PyMethodDef tiled_qt_functions[] = {
    {NULL, NULL, 0, NULL}
};
/* --- classes --- */



static int
_wrap_PyQPointF__tp_init(PyQPointF *self, PyObject *args, PyObject *kwargs)
{
    float x;
    float y;
    const char *keywords[] = {"x", "y", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "ff", (char **) keywords, &x, &y)) {
        return -1;
    }
    self->obj = new QPointF(x, y);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}


PyObject *
_wrap_PyQPointF_y(PyQPointF *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->y();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyQPointF_x(PyQPointF *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->x();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyQPointF_setX(PyQPointF *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int x;
    const char *keywords[] = {"x", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &x)) {
        return NULL;
    }
    self->obj->setX(x);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyQPointF_setY(PyQPointF *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int y;
    const char *keywords[] = {"y", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &y)) {
        return NULL;
    }
    self->obj->setY(y);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}

static PyMethodDef PyQPointF_methods[] = {
    {(char *) "y", (PyCFunction) _wrap_PyQPointF_y, METH_NOARGS, NULL },
    {(char *) "x", (PyCFunction) _wrap_PyQPointF_x, METH_NOARGS, NULL },
    {(char *) "setX", (PyCFunction) _wrap_PyQPointF_setX, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setY", (PyCFunction) _wrap_PyQPointF_setY, METH_KEYWORDS|METH_VARARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyQPointF__tp_dealloc(PyQPointF *self)
{
        QPointF *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyQPointF__tp_richcompare (PyQPointF *PYBINDGEN_UNUSED(self), PyQPointF *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyQPointF_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyQPointF_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.qt.QPointF",            /* tp_name */
    sizeof(PyQPointF),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyQPointF__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyQPointF__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyQPointF_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyQPointF__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyQSizeF__tp_init(PyQSizeF *self, PyObject *args, PyObject *kwargs)
{
    float w;
    float h;
    const char *keywords[] = {"w", "h", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "ff", (char **) keywords, &w, &h)) {
        return -1;
    }
    self->obj = new QSizeF(w, h);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}


PyObject *
_wrap_PyQSizeF_setHeight(PyQSizeF *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int h;
    const char *keywords[] = {"h", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &h)) {
        return NULL;
    }
    self->obj->setHeight(h);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyQSizeF_width(PyQSizeF *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->width();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyQSizeF_setWidth(PyQSizeF *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int w;
    const char *keywords[] = {"w", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &w)) {
        return NULL;
    }
    self->obj->setWidth(w);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyQSizeF_height(PyQSizeF *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->height();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}

static PyMethodDef PyQSizeF_methods[] = {
    {(char *) "setHeight", (PyCFunction) _wrap_PyQSizeF_setHeight, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "width", (PyCFunction) _wrap_PyQSizeF_width, METH_NOARGS, NULL },
    {(char *) "setWidth", (PyCFunction) _wrap_PyQSizeF_setWidth, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "height", (PyCFunction) _wrap_PyQSizeF_height, METH_NOARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyQSizeF__tp_dealloc(PyQSizeF *self)
{
        QSizeF *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyQSizeF__tp_richcompare (PyQSizeF *PYBINDGEN_UNUSED(self), PyQSizeF *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyQSizeF_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyQSizeF_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.qt.QSizeF",            /* tp_name */
    sizeof(PyQSizeF),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyQSizeF__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyQSizeF__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyQSizeF_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyQSizeF__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyQRgb__tp_init(void)
{
    PyErr_SetString(PyExc_TypeError, "class 'QRgb' cannot be constructed ()");
    return -1;
}

static PyMethodDef PyQRgb_methods[] = {
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyQRgb__tp_dealloc(PyQRgb *self)
{
        QRgb *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyQRgb__tp_richcompare (PyQRgb *PYBINDGEN_UNUSED(self), PyQRgb *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyQRgb_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyQRgb_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.qt.QRgb",            /* tp_name */
    sizeof(PyQRgb),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyQRgb__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyQRgb__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyQRgb_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyQRgb__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};





static int
_wrap_PyQColor__tp_init__0(PyQColor *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    PyQRgb *col;
    const char *keywords[] = {"col", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyQRgb_Type, &col)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return -1;
    }
    self->obj = new QColor(*((PyQRgb *) col)->obj);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}

static int
_wrap_PyQColor__tp_init__1(PyQColor *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    int r;
    int g;
    int b;
    const char *keywords[] = {"r", "g", "b", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "iii", (char **) keywords, &r, &g, &b)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return -1;
    }
    self->obj = new QColor(r, g, b);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}

static int
_wrap_PyQColor__tp_init__2(PyQColor *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    int r;
    int g;
    int b;
    int a;
    const char *keywords[] = {"r", "g", "b", "a", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "iiii", (char **) keywords, &r, &g, &b, &a)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return -1;
    }
    self->obj = new QColor(r, g, b, a);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}

int _wrap_PyQColor__tp_init(PyQColor *self, PyObject *args, PyObject *kwargs)
{
    int retval;
    PyObject *error_list;
    PyObject *exceptions[3] = {0,};
    retval = _wrap_PyQColor__tp_init__0(self, args, kwargs, &exceptions[0]);
    if (!exceptions[0]) {
        return retval;
    }
    retval = _wrap_PyQColor__tp_init__1(self, args, kwargs, &exceptions[1]);
    if (!exceptions[1]) {
        Py_DECREF(exceptions[0]);
        return retval;
    }
    retval = _wrap_PyQColor__tp_init__2(self, args, kwargs, &exceptions[2]);
    if (!exceptions[2]) {
        Py_DECREF(exceptions[0]);
        Py_DECREF(exceptions[1]);
        return retval;
    }
    error_list = PyList_New(3);
    PyList_SET_ITEM(error_list, 0, PyObject_Str(exceptions[0]));
    Py_DECREF(exceptions[0]);
    PyList_SET_ITEM(error_list, 1, PyObject_Str(exceptions[1]));
    Py_DECREF(exceptions[1]);
    PyList_SET_ITEM(error_list, 2, PyObject_Str(exceptions[2]));
    Py_DECREF(exceptions[2]);
    PyErr_SetObject(PyExc_TypeError, error_list);
    Py_DECREF(error_list);
    return -1;
}


PyObject *
_wrap_PyQColor_rgb(PyQColor *self)
{
    PyObject *py_retval;
    PyQRgb *py_QRgb;

    QRgb retval = self->obj->rgb();
    py_QRgb = PyObject_New(PyQRgb, &PyQRgb_Type);
    py_QRgb->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_QRgb->obj = new QRgb(retval);
    py_retval = Py_BuildValue((char *) "N", py_QRgb);
    return py_retval;
}


PyObject *
_wrap_PyQColor_rgba(PyQColor *self)
{
    PyObject *py_retval;
    PyQRgb *py_QRgb;

    QRgb retval = self->obj->rgba();
    py_QRgb = PyObject_New(PyQRgb, &PyQRgb_Type);
    py_QRgb->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_QRgb->obj = new QRgb(retval);
    py_retval = Py_BuildValue((char *) "N", py_QRgb);
    return py_retval;
}

static PyMethodDef PyQColor_methods[] = {
    {(char *) "rgb", (PyCFunction) _wrap_PyQColor_rgb, METH_NOARGS, NULL },
    {(char *) "rgba", (PyCFunction) _wrap_PyQColor_rgba, METH_NOARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyQColor__tp_dealloc(PyQColor *self)
{
        QColor *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyQColor__tp_richcompare (PyQColor *PYBINDGEN_UNUSED(self), PyQColor *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyQColor_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyQColor_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.qt.QColor",            /* tp_name */
    sizeof(PyQColor),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyQColor__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyQColor__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyQColor_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyQColor__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};





static int
_wrap_PyQImage__tp_init__0(PyQImage *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    const char *keywords[] = {NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "", (char **) keywords)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return -1;
    }
    self->obj = new QImage();
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}

static int
_wrap_PyQImage__tp_init__1(PyQImage *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    int w;
    int h;
    QImage::Format f;
    const char *keywords[] = {"w", "h", "f", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "iii", (char **) keywords, &w, &h, &f)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return -1;
    }
    self->obj = new QImage(w, h, f);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}

int _wrap_PyQImage__tp_init(PyQImage *self, PyObject *args, PyObject *kwargs)
{
    int retval;
    PyObject *error_list;
    PyObject *exceptions[2] = {0,};
    retval = _wrap_PyQImage__tp_init__0(self, args, kwargs, &exceptions[0]);
    if (!exceptions[0]) {
        return retval;
    }
    retval = _wrap_PyQImage__tp_init__1(self, args, kwargs, &exceptions[1]);
    if (!exceptions[1]) {
        Py_DECREF(exceptions[0]);
        return retval;
    }
    error_list = PyList_New(2);
    PyList_SET_ITEM(error_list, 0, PyObject_Str(exceptions[0]));
    Py_DECREF(exceptions[0]);
    PyList_SET_ITEM(error_list, 1, PyObject_Str(exceptions[1]));
    Py_DECREF(exceptions[1]);
    PyErr_SetObject(PyExc_TypeError, error_list);
    Py_DECREF(error_list);
    return -1;
}


PyObject *
_wrap_PyQImage_load(PyQImage *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    bool retval;
    const char *fileName;
    Py_ssize_t fileName_len;
    char *fmt;
    const char *keywords[] = {"fileName", "fmt", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#s", (char **) keywords, &fileName, &fileName_len, &fmt)) {
        return NULL;
    }
    retval = self->obj->load(QString::fromUtf8(fileName), fmt);
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}


PyObject *
_wrap_PyQImage_setColor(PyQImage *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int i;
    PyQRgb *c;
    const char *keywords[] = {"i", "c", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "iO!", (char **) keywords, &i, &PyQRgb_Type, &c)) {
        return NULL;
    }
    self->obj->setColor(i, *((PyQRgb *) c)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyQImage_color(PyQImage *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int i;
    const char *keywords[] = {"i", NULL};
    PyQRgb *py_QRgb;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &i)) {
        return NULL;
    }
    QRgb retval = self->obj->color(i);
    py_QRgb = PyObject_New(PyQRgb, &PyQRgb_Type);
    py_QRgb->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_QRgb->obj = new QRgb(retval);
    py_retval = Py_BuildValue((char *) "N", py_QRgb);
    return py_retval;
}


PyObject *
_wrap_PyQImage_mirrored(PyQImage *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    bool horiz;
    PyObject *py_horiz;
    bool vert;
    PyObject *py_vert;
    const char *keywords[] = {"horiz", "vert", NULL};
    PyQImage *py_QImage;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "OO", (char **) keywords, &py_horiz, &py_vert)) {
        return NULL;
    }
    horiz = (bool) PyObject_IsTrue(py_horiz);
    vert = (bool) PyObject_IsTrue(py_vert);
    QImage const & retval = self->obj->mirrored(horiz, vert);
    py_QImage = PyObject_New(PyQImage, &PyQImage_Type);
    py_QImage->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_QImage->obj = new QImage(retval);
    py_retval = Py_BuildValue((char *) "N", py_QImage);
    return py_retval;
}


PyObject *
_wrap_PyQImage_height(PyQImage *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->height();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}



PyObject *
_wrap_PyQImage_setPixel__0(PyQImage *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    PyObject *py_retval;
    int x;
    int y;
    unsigned int color;
    const char *keywords[] = {"x", "y", "color", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "iiI", (char **) keywords, &x, &y, &color)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return NULL;
    }
    self->obj->setPixel(x, y, color);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}

PyObject *
_wrap_PyQImage_setPixel__1(PyQImage *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    PyObject *py_retval;
    int x;
    int y;
    PyQRgb *color;
    const char *keywords[] = {"x", "y", "color", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "iiO!", (char **) keywords, &x, &y, &PyQRgb_Type, &color)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return NULL;
    }
    self->obj->setPixel(x, y, *((PyQRgb *) color)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}

PyObject * _wrap_PyQImage_setPixel(PyQImage *self, PyObject *args, PyObject *kwargs)
{
    PyObject * retval;
    PyObject *error_list;
    PyObject *exceptions[2] = {0,};
    retval = _wrap_PyQImage_setPixel__0(self, args, kwargs, &exceptions[0]);
    if (!exceptions[0]) {
        return retval;
    }
    retval = _wrap_PyQImage_setPixel__1(self, args, kwargs, &exceptions[1]);
    if (!exceptions[1]) {
        Py_DECREF(exceptions[0]);
        return retval;
    }
    error_list = PyList_New(2);
    PyList_SET_ITEM(error_list, 0, PyObject_Str(exceptions[0]));
    Py_DECREF(exceptions[0]);
    PyList_SET_ITEM(error_list, 1, PyObject_Str(exceptions[1]));
    Py_DECREF(exceptions[1]);
    PyErr_SetObject(PyExc_TypeError, error_list);
    Py_DECREF(error_list);
    return NULL;
}


PyObject *
_wrap_PyQImage_width(PyQImage *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->width();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyQImage_colorTable(PyQImage *self)
{
    PyObject *py_retval;
    QVector< QRgb > retval;
    PyQVector__lt__QRgb__gt__ *py_QVector__lt__QRgb__gt__;

    retval = self->obj->colorTable();
    py_QVector__lt__QRgb__gt__ = PyObject_New(PyQVector__lt__QRgb__gt__, &PyQVector__lt__QRgb__gt___Type);
    py_QVector__lt__QRgb__gt__->obj = new QVector<QRgb>(retval);
    py_retval = Py_BuildValue((char *) "N", py_QVector__lt__QRgb__gt__);
    return py_retval;
}


PyObject *
_wrap_PyQImage_setColorTable(PyQImage *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    QVector<QRgb> colors_value;
    const char *keywords[] = {"colors", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O&", (char **) keywords, _wrap_convert_py2c__QVector__lt___QRgb___gt__, &colors_value)) {
        return NULL;
    }
    self->obj->setColorTable(colors_value);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyQImage_fill(PyQImage *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int color;
    const char *keywords[] = {"color", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &color)) {
        return NULL;
    }
    self->obj->fill(color);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}

static PyMethodDef PyQImage_methods[] = {
    {(char *) "load", (PyCFunction) _wrap_PyQImage_load, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setColor", (PyCFunction) _wrap_PyQImage_setColor, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "color", (PyCFunction) _wrap_PyQImage_color, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "mirrored", (PyCFunction) _wrap_PyQImage_mirrored, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "height", (PyCFunction) _wrap_PyQImage_height, METH_NOARGS, NULL },
    {(char *) "setPixel", (PyCFunction) _wrap_PyQImage_setPixel, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "width", (PyCFunction) _wrap_PyQImage_width, METH_NOARGS, NULL },
    {(char *) "colorTable", (PyCFunction) _wrap_PyQImage_colorTable, METH_NOARGS, NULL },
    {(char *) "setColorTable", (PyCFunction) _wrap_PyQImage_setColorTable, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "fill", (PyCFunction) _wrap_PyQImage_fill, METH_KEYWORDS|METH_VARARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyQImage__tp_dealloc(PyQImage *self)
{
        QImage *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyQImage__tp_richcompare (PyQImage *PYBINDGEN_UNUSED(self), PyQImage *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyQImage_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyQImage_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.qt.QImage",            /* tp_name */
    sizeof(PyQImage),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyQImage__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyQImage__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyQImage_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyQImage__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyQPixmap__tp_init(void)
{
    PyErr_SetString(PyExc_TypeError, "class 'QPixmap' cannot be constructed ()");
    return -1;
}


PyObject *
_wrap_PyQPixmap_convertFromImage(PyQPixmap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    PyQImage *image;
    const char *keywords[] = {"image", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyQImage_Type, &image)) {
        return NULL;
    }
    self->obj->convertFromImage(*((PyQImage *) image)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyQPixmap_width(PyQPixmap *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->width();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyQPixmap_toImage(PyQPixmap *self)
{
    PyObject *py_retval;
    PyQImage *py_QImage;

    QImage const & retval = self->obj->toImage();
    py_QImage = PyObject_New(PyQImage, &PyQImage_Type);
    py_QImage->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_QImage->obj = new QImage(retval);
    py_retval = Py_BuildValue((char *) "N", py_QImage);
    return py_retval;
}


PyObject *
_wrap_PyQPixmap_fromImage(PyQPixmap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    PyQImage *image;
    const char *keywords[] = {"image", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyQImage_Type, &image)) {
        return NULL;
    }
    self->obj->fromImage(*((PyQImage *) image)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyQPixmap_height(PyQPixmap *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->height();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}

static PyMethodDef PyQPixmap_methods[] = {
    {(char *) "convertFromImage", (PyCFunction) _wrap_PyQPixmap_convertFromImage, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "width", (PyCFunction) _wrap_PyQPixmap_width, METH_NOARGS, NULL },
    {(char *) "toImage", (PyCFunction) _wrap_PyQPixmap_toImage, METH_NOARGS, NULL },
    {(char *) "fromImage", (PyCFunction) _wrap_PyQPixmap_fromImage, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "height", (PyCFunction) _wrap_PyQPixmap_height, METH_NOARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyQPixmap__tp_dealloc(PyQPixmap *self)
{
        QPixmap *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyQPixmap__tp_richcompare (PyQPixmap *PYBINDGEN_UNUSED(self), PyQPixmap *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyQPixmap_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyQPixmap_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.qt.QPixmap",            /* tp_name */
    sizeof(PyQPixmap),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyQPixmap__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyQPixmap__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyQPixmap_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyQPixmap__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyQWidget__tp_init(void)
{
    PyErr_SetString(PyExc_TypeError, "class 'QWidget' cannot be constructed ()");
    return -1;
}

static PyMethodDef PyQWidget_methods[] = {
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyQWidget__tp_dealloc(PyQWidget *self)
{
        QWidget *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyQWidget__tp_richcompare (PyQWidget *PYBINDGEN_UNUSED(self), PyQWidget *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyQWidget_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyQWidget_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.qt.QWidget",            /* tp_name */
    sizeof(PyQWidget),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyQWidget__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyQWidget__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyQWidget_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyQWidget__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyQFileDialog__tp_init(void)
{
    PyErr_SetString(PyExc_TypeError, "class 'QFileDialog' cannot be constructed ()");
    return -1;
}


PyObject *
_wrap_PyQFileDialog_getOpenFileName(PyQFileDialog *PYBINDGEN_UNUSED(dummy), PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    QString retval;
    PyQWidget *parent;
    QWidget *parent_ptr;
    const char *caption;
    Py_ssize_t caption_len;
    const char *dir;
    Py_ssize_t dir_len;
    const char *filter;
    Py_ssize_t filter_len;
    const char *selectedFilter;
    QFileDialog::Option options;
    const char *keywords[] = {"parent", "caption", "dir", "filter", "selectedFilter", "options", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "Os#s#s#|si", (char **) keywords, &parent, &caption, &caption_len, &dir, &dir_len, &filter, &filter_len, &selectedFilter, &options)) {
        return NULL;
    }
    if (parent && ((PyObject *) parent != Py_None) && !PyObject_IsInstance((PyObject *) parent, (PyObject *) &PyQWidget_Type)) {
        PyErr_SetString(PyExc_TypeError, "Parameter 1 must be of type QWidget");
        return NULL;
    }
    if (parent) {
        if ((PyObject *) parent == Py_None)
            parent_ptr = NULL;
        else
            parent_ptr = parent->obj;
    } else {
        parent_ptr = NULL;
    }
    retval = QFileDialog::getOpenFileName(parent_ptr, QString::fromUtf8(caption), QString::fromUtf8(dir), QString::fromUtf8(filter), new QString(""), 0);
    py_retval = Py_BuildValue((char *) "s", retval.toUtf8().data());
    return py_retval;
}

static PyMethodDef PyQFileDialog_methods[] = {
    {(char *) "getOpenFileName", (PyCFunction) _wrap_PyQFileDialog_getOpenFileName, METH_KEYWORDS|METH_VARARGS|METH_STATIC, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyQFileDialog__tp_dealloc(PyQFileDialog *self)
{
        QFileDialog *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyQFileDialog__tp_richcompare (PyQFileDialog *PYBINDGEN_UNUSED(self), PyQFileDialog *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyQFileDialog_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyQFileDialog_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.qt.QFileDialog",            /* tp_name */
    sizeof(PyQFileDialog),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyQFileDialog__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyQFileDialog__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyQFileDialog_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyQFileDialog__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};


/* --- containers --- */



static void
PyQVector__lt__QRgb__gt__Iter__tp_clear(PyQVector__lt__QRgb__gt__Iter *self)
{
    Py_CLEAR(self->container);
    delete self->iterator;
    self->iterator = NULL;

}


static int
PyQVector__lt__QRgb__gt__Iter__tp_traverse(PyQVector__lt__QRgb__gt__Iter *self, visitproc visit, void *arg)
{
    Py_VISIT((PyObject *) self->container);
    return 0;
}


static void
_wrap_PyQVector__lt__QRgb__gt____tp_dealloc(PyQVector__lt__QRgb__gt__ *self)
{
    delete self->obj;
    self->obj = NULL;

    Py_TYPE(self)->tp_free((PyObject*)self);
}


static void
_wrap_PyQVector__lt__QRgb__gt__Iter__tp_dealloc(PyQVector__lt__QRgb__gt__Iter *self)
{
    Py_CLEAR(self->container);
    delete self->iterator;
    self->iterator = NULL;

    Py_TYPE(self)->tp_free((PyObject*)self);
}


static PyObject*
_wrap_PyQVector__lt__QRgb__gt____tp_iter(PyQVector__lt__QRgb__gt__ *self)
{
    PyQVector__lt__QRgb__gt__Iter *iter = PyObject_GC_New(PyQVector__lt__QRgb__gt__Iter, &PyQVector__lt__QRgb__gt__Iter_Type);
    Py_INCREF(self);
    iter->container = self;
    iter->iterator = new QVector<QRgb>::iterator(self->obj->begin());
    return (PyObject*) iter;
}


static PyObject*
_wrap_PyQVector__lt__QRgb__gt__Iter__tp_iter(PyQVector__lt__QRgb__gt__Iter *self)
{
    Py_INCREF(self);
    return (PyObject*) self;
}

static PyObject* _wrap_PyQVector__lt__QRgb__gt__Iter__tp_iternext(PyQVector__lt__QRgb__gt__Iter *self)
{
    PyObject *py_retval;
    QVector<QRgb>::iterator iter;
    PyQRgb *py_QRgb;

    iter = *self->iterator;
    if (iter == self->container->obj->end()) {
        PyErr_SetNone(PyExc_StopIteration);
        return NULL;
    }
    ++(*self->iterator);
    py_QRgb = PyObject_New(PyQRgb, &PyQRgb_Type);
    py_QRgb->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_QRgb->obj = new QRgb((*iter));
    py_retval = Py_BuildValue((char *) "N", py_QRgb);
    return py_retval;
}

int _wrap_convert_py2c__QRgb(PyObject *value, QRgb *address)
{
    PyObject *py_retval;
    PyQRgb *tmp_QRgb;

    py_retval = Py_BuildValue((char *) "(O)", value);
    if (!PyArg_ParseTuple(py_retval, (char *) "O!", &PyQRgb_Type, &tmp_QRgb)) {
        Py_DECREF(py_retval);
        return 0;
    }
    *address = *tmp_QRgb->obj;
    Py_DECREF(py_retval);
    return 1;
}


int _wrap_convert_py2c__QVector__lt___QRgb___gt__(PyObject *arg, QVector<QRgb> *container)
{
    if (PyObject_IsInstance(arg, (PyObject*) &PyQVector__lt__QRgb__gt___Type)) {
        *container = *((PyQVector__lt__QRgb__gt__*)arg)->obj;
    } else if (PyList_Check(arg)) {
        container->clear();
        Py_ssize_t size = PyList_Size(arg);
        for (Py_ssize_t i = 0; i < size; i++) {
            QRgb item;
            if (!_wrap_convert_py2c__QRgb(PyList_GET_ITEM(arg, i), &item)) {
                return 0;
            }
            container->push_back(item);
        }
    } else {
        PyErr_SetString(PyExc_TypeError, "parameter must be None, a QVector__lt__QRgb__gt__ instance, or a list of QRgb");
        return 0;
    }
    return 1;
}


static int
_wrap_PyQVector__lt__QRgb__gt____tp_init(PyQVector__lt__QRgb__gt__ *self, PyObject *args, PyObject *kwargs)
{
    const char *keywords[] = {"arg", NULL};
    PyObject *arg = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "|O", (char **) keywords, &arg)) {
        return -1;
    }

    self->obj = new QVector<QRgb>;

    if (arg == NULL)
        return 0;

    if (!_wrap_convert_py2c__QVector__lt___QRgb___gt__(arg, self->obj)) {
        delete self->obj;
        self->obj = NULL;
        return -1;
    }
    return 0;
}

PyTypeObject PyQVector__lt__QRgb__gt___Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.qt.QVector__lt__QRgb__gt__",            /* tp_name */
    sizeof(PyQVector__lt__QRgb__gt__),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyQVector__lt__QRgb__gt____tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)NULL,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)_wrap_PyQVector__lt__QRgb__gt____tp_iter,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)NULL, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    NULL,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyQVector__lt__QRgb__gt____tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};

PyTypeObject PyQVector__lt__QRgb__gt__Iter_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.qt.QVector__lt__QRgb__gt__Iter",            /* tp_name */
    sizeof(PyQVector__lt__QRgb__gt__Iter),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyQVector__lt__QRgb__gt__Iter__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)PyQVector__lt__QRgb__gt__Iter__tp_traverse,     /* tp_traverse */
    (inquiry)PyQVector__lt__QRgb__gt__Iter__tp_clear,             /* tp_clear */
    (richcmpfunc)NULL,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)_wrap_PyQVector__lt__QRgb__gt__Iter__tp_iter,          /* tp_iter */
    (iternextfunc)_wrap_PyQVector__lt__QRgb__gt__Iter__tp_iternext,     /* tp_iternext */
    (struct PyMethodDef*)NULL, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    NULL,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)NULL,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static void
PyQList__lt__QString__gt__Iter__tp_clear(PyQList__lt__QString__gt__Iter *self)
{
    Py_CLEAR(self->container);
    delete self->iterator;
    self->iterator = NULL;

}


static int
PyQList__lt__QString__gt__Iter__tp_traverse(PyQList__lt__QString__gt__Iter *self, visitproc visit, void *arg)
{
    Py_VISIT((PyObject *) self->container);
    return 0;
}


static void
_wrap_PyQList__lt__QString__gt____tp_dealloc(PyQList__lt__QString__gt__ *self)
{
    delete self->obj;
    self->obj = NULL;

    Py_TYPE(self)->tp_free((PyObject*)self);
}


static void
_wrap_PyQList__lt__QString__gt__Iter__tp_dealloc(PyQList__lt__QString__gt__Iter *self)
{
    Py_CLEAR(self->container);
    delete self->iterator;
    self->iterator = NULL;

    Py_TYPE(self)->tp_free((PyObject*)self);
}


static PyObject*
_wrap_PyQList__lt__QString__gt____tp_iter(PyQList__lt__QString__gt__ *self)
{
    PyQList__lt__QString__gt__Iter *iter = PyObject_GC_New(PyQList__lt__QString__gt__Iter, &PyQList__lt__QString__gt__Iter_Type);
    Py_INCREF(self);
    iter->container = self;
    iter->iterator = new QList<QString>::iterator(self->obj->begin());
    return (PyObject*) iter;
}


static PyObject*
_wrap_PyQList__lt__QString__gt__Iter__tp_iter(PyQList__lt__QString__gt__Iter *self)
{
    Py_INCREF(self);
    return (PyObject*) self;
}

static PyObject* _wrap_PyQList__lt__QString__gt__Iter__tp_iternext(PyQList__lt__QString__gt__Iter *self)
{
    PyObject *py_retval;
    QList<QString>::iterator iter;

    iter = *self->iterator;
    if (iter == self->container->obj->end()) {
        PyErr_SetNone(PyExc_StopIteration);
        return NULL;
    }
    ++(*self->iterator);
    py_retval = Py_BuildValue((char *) "s", (*iter).toUtf8().data());
    return py_retval;
}

int _wrap_convert_py2c__QString(PyObject *value, QString *address)
{
    PyObject *py_retval;
    const char *retval_ptr;
    Py_ssize_t retval_len;

    py_retval = Py_BuildValue((char *) "(O)", value);
    if (!PyArg_ParseTuple(py_retval, (char *) "s#", &retval_ptr, &retval_len)) {
        Py_DECREF(py_retval);
        return 0;
    }
    *address = QString(retval_ptr);
    Py_DECREF(py_retval);
    return 1;
}


int _wrap_convert_py2c__QList__lt___QString___gt__(PyObject *arg, QList<QString> *container)
{
    if (PyObject_IsInstance(arg, (PyObject*) &PyQList__lt__QString__gt___Type)) {
        *container = *((PyQList__lt__QString__gt__*)arg)->obj;
    } else if (PyList_Check(arg)) {
        container->clear();
        Py_ssize_t size = PyList_Size(arg);
        for (Py_ssize_t i = 0; i < size; i++) {
            QString item;
            if (!_wrap_convert_py2c__QString(PyList_GET_ITEM(arg, i), &item)) {
                return 0;
            }
            container->push_back(item);
        }
    } else {
        PyErr_SetString(PyExc_TypeError, "parameter must be None, a QList__lt__QString__gt__ instance, or a list of QString");
        return 0;
    }
    return 1;
}


static int
_wrap_PyQList__lt__QString__gt____tp_init(PyQList__lt__QString__gt__ *self, PyObject *args, PyObject *kwargs)
{
    const char *keywords[] = {"arg", NULL};
    PyObject *arg = NULL;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "|O", (char **) keywords, &arg)) {
        return -1;
    }

    self->obj = new QList<QString>;

    if (arg == NULL)
        return 0;

    if (!_wrap_convert_py2c__QList__lt___QString___gt__(arg, self->obj)) {
        delete self->obj;
        self->obj = NULL;
        return -1;
    }
    return 0;
}

PyTypeObject PyQList__lt__QString__gt___Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.qt.QList__lt__QString__gt__",            /* tp_name */
    sizeof(PyQList__lt__QString__gt__),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyQList__lt__QString__gt____tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)NULL,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)_wrap_PyQList__lt__QString__gt____tp_iter,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)NULL, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    NULL,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyQList__lt__QString__gt____tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};

PyTypeObject PyQList__lt__QString__gt__Iter_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.qt.QList__lt__QString__gt__Iter",            /* tp_name */
    sizeof(PyQList__lt__QString__gt__Iter),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyQList__lt__QString__gt__Iter__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)PyQList__lt__QString__gt__Iter__tp_traverse,     /* tp_traverse */
    (inquiry)PyQList__lt__QString__gt__Iter__tp_clear,             /* tp_clear */
    (richcmpfunc)NULL,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)_wrap_PyQList__lt__QString__gt__Iter__tp_iter,          /* tp_iter */
    (iternextfunc)_wrap_PyQList__lt__QString__gt__Iter__tp_iternext,     /* tp_iternext */
    (struct PyMethodDef*)NULL, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    NULL,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)NULL,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};


/* --- enumerations --- */






bool isImageLayerAt(Tiled::Map *map, int idx) {
    return (dynamic_cast<const Tiled::ImageLayer*>(map->layerAt(idx)) != 0);
}
bool isTileLayerAt(Tiled::Map *map, int idx) {
    return (dynamic_cast<const Tiled::TileLayer*>(map->layerAt(idx)) != 0);
}
bool isObjectGroupAt(Tiled::Map *map, int idx) {
    return (dynamic_cast<const Tiled::ObjectGroup*>(map->layerAt(idx)) != 0);
}
Tiled::ImageLayer* imageLayerAt(Tiled::Map *map, int idx) {
    return static_cast<Tiled::ImageLayer*>(map->layerAt(idx));
}
Tiled::TileLayer* tileLayerAt(Tiled::Map *map, int idx) {
    return static_cast<Tiled::TileLayer*>(map->layerAt(idx));
}
Tiled::ObjectGroup* objectGroupAt(Tiled::Map *map, int idx) {
    return static_cast<Tiled::ObjectGroup*>(map->layerAt(idx));
}


bool loadTilesetFromFile(Tiled::Tileset *ts, QString file)
{
    QImage img(file);
    return ts->loadFromImage(img, file);
}

#if PY_VERSION_HEX >= 0x03000000
static struct PyModuleDef qt_moduledef = {
    PyModuleDef_HEAD_INIT,
    "tiled.qt",
    NULL,
    -1,
    tiled_qt_functions,
};
#endif

static PyObject *
inittiled_qt(void)
{
    PyObject *m;
    #if PY_VERSION_HEX >= 0x03000000
    m = PyModule_Create(&qt_moduledef);
    #else
    m = Py_InitModule3((char *) "tiled.qt", tiled_qt_functions, NULL);
    #endif
    if (m == NULL) {
        return NULL;
    }
    /* Register the 'QPointF' class */
    if (PyType_Ready(&PyQPointF_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "QPointF", (PyObject *) &PyQPointF_Type);
    /* Register the 'QSizeF' class */
    if (PyType_Ready(&PyQSizeF_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "QSizeF", (PyObject *) &PyQSizeF_Type);
    /* Register the 'QRgb' class */
    if (PyType_Ready(&PyQRgb_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "QRgb", (PyObject *) &PyQRgb_Type);
    /* Register the 'QColor' class */
    if (PyType_Ready(&PyQColor_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "QColor", (PyObject *) &PyQColor_Type);
    /* Register the 'QImage' class */
    if (PyType_Ready(&PyQImage_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "QImage", (PyObject *) &PyQImage_Type);
    /* Register the 'QPixmap' class */
    if (PyType_Ready(&PyQPixmap_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "QPixmap", (PyObject *) &PyQPixmap_Type);
    /* Register the 'QWidget' class */
    if (PyType_Ready(&PyQWidget_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "QWidget", (PyObject *) &PyQWidget_Type);
    /* Register the 'QFileDialog' class */
    if (PyType_Ready(&PyQFileDialog_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "QFileDialog", (PyObject *) &PyQFileDialog_Type);
    /* Register the 'QVector<QRgb>' class */
    if (PyType_Ready(&PyQVector__lt__QRgb__gt___Type)) {
        return NULL;
    }
    if (PyType_Ready(&PyQVector__lt__QRgb__gt__Iter_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "QVector__lt__QRgb__gt__", (PyObject *) &PyQVector__lt__QRgb__gt___Type);
    PyModule_AddObject(m, (char *) "QVector__lt__QRgb__gt__Iter", (PyObject *) &PyQVector__lt__QRgb__gt__Iter_Type);
    /* Register the 'QList<QString>' class */
    if (PyType_Ready(&PyQList__lt__QString__gt___Type)) {
        return NULL;
    }
    if (PyType_Ready(&PyQList__lt__QString__gt__Iter_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "QList__lt__QString__gt__", (PyObject *) &PyQList__lt__QString__gt___Type);
    PyModule_AddObject(m, (char *) "QList__lt__QString__gt__Iter", (PyObject *) &PyQList__lt__QString__gt__Iter_Type);
    {
        PyObject *tmp_value;
         // QImage::Format_Invalid
        tmp_value = PyLong_FromLong(QImage::Format_Invalid);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_Invalid", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_Mono
        tmp_value = PyLong_FromLong(QImage::Format_Mono);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_Mono", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_MonoLSB
        tmp_value = PyLong_FromLong(QImage::Format_MonoLSB);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_MonoLSB", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_Indexed8
        tmp_value = PyLong_FromLong(QImage::Format_Indexed8);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_Indexed8", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_RGB32
        tmp_value = PyLong_FromLong(QImage::Format_RGB32);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_RGB32", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_ARGB32
        tmp_value = PyLong_FromLong(QImage::Format_ARGB32);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_ARGB32", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_ARGB32_Premultiplied
        tmp_value = PyLong_FromLong(QImage::Format_ARGB32_Premultiplied);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_ARGB32_Premultiplied", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_RGB16
        tmp_value = PyLong_FromLong(QImage::Format_RGB16);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_RGB16", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_ARGB8565_Premultiplied
        tmp_value = PyLong_FromLong(QImage::Format_ARGB8565_Premultiplied);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_ARGB8565_Premultiplied", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_RGB666
        tmp_value = PyLong_FromLong(QImage::Format_RGB666);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_RGB666", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_ARGB6666_Premultiplied
        tmp_value = PyLong_FromLong(QImage::Format_ARGB6666_Premultiplied);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_ARGB6666_Premultiplied", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_RGB555
        tmp_value = PyLong_FromLong(QImage::Format_RGB555);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_RGB555", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_ARGB8555_Premultiplied
        tmp_value = PyLong_FromLong(QImage::Format_ARGB8555_Premultiplied);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_ARGB8555_Premultiplied", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_RGB888
        tmp_value = PyLong_FromLong(QImage::Format_RGB888);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_RGB888", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_RGB444
        tmp_value = PyLong_FromLong(QImage::Format_RGB444);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_RGB444", tmp_value);
        Py_DECREF(tmp_value);
         // QImage::Format_ARGB4444_Premultiplied
        tmp_value = PyLong_FromLong(QImage::Format_ARGB4444_Premultiplied);
        PyDict_SetItemString((PyObject*) PyQImage_Type.tp_dict, "Format_ARGB4444_Premultiplied", tmp_value);
        Py_DECREF(tmp_value);
    }
    {
        PyObject *tmp_value;
         // QFileDialog::ShowDirsOnly
        tmp_value = PyLong_FromLong(QFileDialog::ShowDirsOnly);
        PyDict_SetItemString((PyObject*) PyQFileDialog_Type.tp_dict, "ShowDirsOnly", tmp_value);
        Py_DECREF(tmp_value);
         // QFileDialog::DontResolveSymlinks
        tmp_value = PyLong_FromLong(QFileDialog::DontResolveSymlinks);
        PyDict_SetItemString((PyObject*) PyQFileDialog_Type.tp_dict, "DontResolveSymlinks", tmp_value);
        Py_DECREF(tmp_value);
         // QFileDialog::DontConfirmOverwrite
        tmp_value = PyLong_FromLong(QFileDialog::DontConfirmOverwrite);
        PyDict_SetItemString((PyObject*) PyQFileDialog_Type.tp_dict, "DontConfirmOverwrite", tmp_value);
        Py_DECREF(tmp_value);
         // QFileDialog::DontUseNativeDialog
        tmp_value = PyLong_FromLong(QFileDialog::DontUseNativeDialog);
        PyDict_SetItemString((PyObject*) PyQFileDialog_Type.tp_dict, "DontUseNativeDialog", tmp_value);
        Py_DECREF(tmp_value);
         // QFileDialog::ReadOnly
        tmp_value = PyLong_FromLong(QFileDialog::ReadOnly);
        PyDict_SetItemString((PyObject*) PyQFileDialog_Type.tp_dict, "ReadOnly", tmp_value);
        Py_DECREF(tmp_value);
         // QFileDialog::HideNameFilterDetails
        tmp_value = PyLong_FromLong(QFileDialog::HideNameFilterDetails);
        PyDict_SetItemString((PyObject*) PyQFileDialog_Type.tp_dict, "HideNameFilterDetails", tmp_value);
        Py_DECREF(tmp_value);
         // QFileDialog::DontUseSheet
        tmp_value = PyLong_FromLong(QFileDialog::DontUseSheet);
        PyDict_SetItemString((PyObject*) PyQFileDialog_Type.tp_dict, "DontUseSheet", tmp_value);
        Py_DECREF(tmp_value);
    }
    return m;
}
static PyMethodDef tiled_Tiled_functions[] = {
    {NULL, NULL, 0, NULL}
};
/* --- classes --- */



static int
_wrap_PyTiledProperties__tp_init(void)
{
    PyErr_SetString(PyExc_TypeError, "class 'Properties' cannot be constructed ()");
    return -1;
}


PyObject *
_wrap_PyTiledProperties_keys(PyTiledProperties *self)
{
    PyObject *py_retval;
    QList< QString > retval;
    PyQList__lt__QString__gt__ *py_QList__lt__QString__gt__;

    retval = self->obj->keys();
    py_QList__lt__QString__gt__ = PyObject_New(PyQList__lt__QString__gt__, &PyQList__lt__QString__gt___Type);
    py_QList__lt__QString__gt__->obj = new QList<QString>(retval);
    py_retval = Py_BuildValue((char *) "N", py_QList__lt__QString__gt__);
    return py_retval;
}

static PyMethodDef PyTiledProperties_methods[] = {
    {(char *) "keys", (PyCFunction) _wrap_PyTiledProperties_keys, METH_NOARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledProperties__tp_dealloc(PyTiledProperties *self)
{
        Tiled::Properties *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledProperties__tp_richcompare (PyTiledProperties *PYBINDGEN_UNUSED(self), PyTiledProperties *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledProperties_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledProperties_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.Properties",            /* tp_name */
    sizeof(PyTiledProperties),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledProperties__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledProperties__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledProperties_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledProperties__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyTiledObject__tp_init(void)
{
    PyErr_SetString(PyExc_TypeError, "class 'Object' cannot be constructed ()");
    return -1;
}


PyObject *
_wrap_PyTiledObject_setProperty(PyTiledObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    const char *prop;
    Py_ssize_t prop_len;
    const char *val;
    Py_ssize_t val_len;
    const char *keywords[] = {"prop", "val", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#s#", (char **) keywords, &prop, &prop_len, &val, &val_len)) {
        return NULL;
    }
    self->obj->setProperty(QString::fromUtf8(prop), QString::fromUtf8(val));
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledObject_propertyAsString(PyTiledObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    QString retval;
    const char *prop;
    Py_ssize_t prop_len;
    const char *keywords[] = {"prop", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#", (char **) keywords, &prop, &prop_len)) {
        return NULL;
    }
    retval = self->obj->propertyAsString(QString::fromUtf8(prop));
    py_retval = Py_BuildValue((char *) "s", retval.toUtf8().data());
    return py_retval;
}


PyObject *
_wrap_PyTiledObject_properties(PyTiledObject *self)
{
    PyObject *py_retval;
    PyTiledProperties *py_Properties;

    Tiled::Properties const retval = self->obj->properties();
    py_Properties = PyObject_New(PyTiledProperties, &PyTiledProperties_Type);
    py_Properties->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_Properties->obj = new Tiled::Properties(retval);
    py_retval = Py_BuildValue((char *) "N", py_Properties);
    return py_retval;
}

static PyMethodDef PyTiledObject_methods[] = {
    {(char *) "setProperty", (PyCFunction) _wrap_PyTiledObject_setProperty, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "propertyAsString", (PyCFunction) _wrap_PyTiledObject_propertyAsString, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "properties", (PyCFunction) _wrap_PyTiledObject_properties, METH_NOARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledObject__tp_dealloc(PyTiledObject *self)
{
        Tiled::Object *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledObject__tp_richcompare (PyTiledObject *PYBINDGEN_UNUSED(self), PyTiledObject *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledObject_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledObject_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.Object",            /* tp_name */
    sizeof(PyTiledObject),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledObject__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledObject__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledObject_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledObject__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyTiledTile__tp_init(PyTiledTile *self, PyObject *args, PyObject *kwargs)
{
    PyQPixmap *image;
    int id;
    PyTiledTileset *tileset;
    Tiled::Tileset *tileset_ptr;
    const char *keywords[] = {"image", "id", "tileset", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!iO!", (char **) keywords, &PyQPixmap_Type, &image, &id, &PyTiledTileset_Type, &tileset)) {
        return -1;
    }
    tileset_ptr = (tileset ? tileset->obj : NULL);
    self->obj = new Tiled::Tile(*((PyQPixmap *) image)->obj, id, tileset_ptr);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}


PyObject *
_wrap_PyTiledTile_tileset(PyTiledTile *self)
{
    PyObject *py_retval;
    Tiled::Tileset *retval;
    PyTiledTileset *py_Tileset;

    retval = self->obj->tileset();
    if (!(retval)) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    py_Tileset = PyObject_New(PyTiledTileset, &PyTiledTileset_Type);
    py_Tileset->obj = retval;
    py_Tileset->flags = PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED;
    py_retval = Py_BuildValue((char *) "N", py_Tileset);
    return py_retval;
}


PyObject *
_wrap_PyTiledTile_setImage(PyTiledTile *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    PyQPixmap *image;
    const char *keywords[] = {"image", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyQPixmap_Type, &image)) {
        return NULL;
    }
    self->obj->setImage(*((PyQPixmap *) image)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledTile_image(PyTiledTile *self)
{
    PyObject *py_retval;
    PyQPixmap *py_QPixmap;

    QPixmap const & retval = self->obj->image();
    py_QPixmap = PyObject_New(PyQPixmap, &PyQPixmap_Type);
    py_QPixmap->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_QPixmap->obj = new QPixmap(retval);
    py_retval = Py_BuildValue((char *) "N", py_QPixmap);
    return py_retval;
}


PyObject *
_wrap_PyTiledTile_height(PyTiledTile *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->height();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledTile_width(PyTiledTile *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->width();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledTile_id(PyTiledTile *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->id();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}

static PyMethodDef PyTiledTile_methods[] = {
    {(char *) "tileset", (PyCFunction) _wrap_PyTiledTile_tileset, METH_NOARGS, NULL },
    {(char *) "setImage", (PyCFunction) _wrap_PyTiledTile_setImage, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "image", (PyCFunction) _wrap_PyTiledTile_image, METH_NOARGS, NULL },
    {(char *) "height", (PyCFunction) _wrap_PyTiledTile_height, METH_NOARGS, NULL },
    {(char *) "width", (PyCFunction) _wrap_PyTiledTile_width, METH_NOARGS, NULL },
    {(char *) "id", (PyCFunction) _wrap_PyTiledTile_id, METH_NOARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledTile__tp_dealloc(PyTiledTile *self)
{
        Tiled::Tile *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledTile__tp_richcompare (PyTiledTile *PYBINDGEN_UNUSED(self), PyTiledTile *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledTile_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledTile_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.Tile",            /* tp_name */
    sizeof(PyTiledTile),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledTile__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledTile__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledTile_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledTile__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyTiledSharedTileset__tp_init(void)
{
    PyErr_SetString(PyExc_TypeError, "class 'SharedTileset' cannot be constructed ()");
    return -1;
}

static PyMethodDef PyTiledSharedTileset_methods[] = {
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledSharedTileset__tp_dealloc(PyTiledSharedTileset *self)
{
        Tiled::SharedTileset *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledSharedTileset__tp_richcompare (PyTiledSharedTileset *PYBINDGEN_UNUSED(self), PyTiledSharedTileset *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledSharedTileset_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledSharedTileset_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.SharedTileset",            /* tp_name */
    sizeof(PyTiledSharedTileset),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledSharedTileset__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledSharedTileset__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledSharedTileset_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledSharedTileset__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyTiledTileset__tp_init(void)
{
    PyErr_SetString(PyExc_TypeError, "class 'Tileset' cannot be constructed ()");
    return -1;
}


PyObject *
_wrap_PyTiledTileset_columnCount(PyTiledTileset *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->columnCount();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_loadFromImage(PyTiledTileset *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    bool retval;
    PyQImage *img;
    const char *file;
    Py_ssize_t file_len;
    const char *keywords[] = {"img", "file", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!s#", (char **) keywords, &PyQImage_Type, &img, &file, &file_len)) {
        return NULL;
    }
    retval = self->obj->loadFromImage(*((PyQImage *) img)->obj, QString::fromUtf8(file));
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_tileSpacing(PyTiledTileset *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->tileSpacing();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_name(PyTiledTileset *self)
{
    PyObject *py_retval;
    QString retval;

    retval = self->obj->name();
    py_retval = Py_BuildValue((char *) "s", retval.toUtf8().data());
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_setName(PyTiledTileset *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    const char *name;
    Py_ssize_t name_len;
    const char *keywords[] = {"name", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#", (char **) keywords, &name, &name_len)) {
        return NULL;
    }
    self->obj->setName(QString::fromUtf8(name));
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_tileHeight(PyTiledTileset *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->tileHeight();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_tileWidth(PyTiledTileset *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->tileWidth();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_create(PyTiledTileset *PYBINDGEN_UNUSED(dummy), PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    const char *name;
    Py_ssize_t name_len;
    int tileWidth;
    int tileHeight;
    int tileSpacing;
    int margin;
    const char *keywords[] = {"name", "tileWidth", "tileHeight", "tileSpacing", "margin", NULL};
    PyTiledSharedTileset *py_SharedTileset;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#iiii", (char **) keywords, &name, &name_len, &tileWidth, &tileHeight, &tileSpacing, &margin)) {
        return NULL;
    }
    Tiled::SharedTileset retval = Tiled::Tileset::create(QString::fromUtf8(name), tileWidth, tileHeight, tileSpacing, margin);
    py_SharedTileset = PyObject_New(PyTiledSharedTileset, &PyTiledSharedTileset_Type);
    py_SharedTileset->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_SharedTileset->obj = new Tiled::SharedTileset(retval);
    py_retval = Py_BuildValue((char *) "N", py_SharedTileset);
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_transparentColor(PyTiledTileset *self)
{
    PyObject *py_retval;
    PyQColor *py_QColor;

    QColor retval = self->obj->transparentColor();
    py_QColor = PyObject_New(PyQColor, &PyQColor_Type);
    py_QColor->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_QColor->obj = new QColor(retval);
    py_retval = Py_BuildValue((char *) "N", py_QColor);
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_setFileName(PyTiledTileset *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    const char *name;
    Py_ssize_t name_len;
    const char *keywords[] = {"name", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#", (char **) keywords, &name, &name_len)) {
        return NULL;
    }
    self->obj->setFileName(QString::fromUtf8(name));
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_tileAt(PyTiledTileset *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    Tiled::Tile *retval;
    int id;
    const char *keywords[] = {"id", NULL};
    PyTiledTile *py_Tile;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &id)) {
        return NULL;
    }
    retval = self->obj->tileAt(id);
    if (!(retval)) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    py_Tile = PyObject_New(PyTiledTile, &PyTiledTile_Type);
    py_Tile->obj = retval;
    py_Tile->flags = PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED;
    py_retval = Py_BuildValue((char *) "N", py_Tile);
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_fileName(PyTiledTileset *self)
{
    PyObject *py_retval;
    QString retval;

    retval = self->obj->fileName();
    py_retval = Py_BuildValue((char *) "s", retval.toUtf8().data());
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_tileCount(PyTiledTileset *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->tileCount();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_imageHeight(PyTiledTileset *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->imageHeight();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_imageWidth(PyTiledTileset *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->imageWidth();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_setTransparentColor(PyTiledTileset *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    PyQColor *col;
    const char *keywords[] = {"col", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyQColor_Type, &col)) {
        return NULL;
    }
    self->obj->setTransparentColor(*((PyQColor *) col)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_margin(PyTiledTileset *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->margin();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledTileset_isExternal(PyTiledTileset *self)
{
    PyObject *py_retval;
    bool retval;

    retval = self->obj->isExternal();
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}

static PyMethodDef PyTiledTileset_methods[] = {
    {(char *) "columnCount", (PyCFunction) _wrap_PyTiledTileset_columnCount, METH_NOARGS, NULL },
    {(char *) "loadFromImage", (PyCFunction) _wrap_PyTiledTileset_loadFromImage, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "tileSpacing", (PyCFunction) _wrap_PyTiledTileset_tileSpacing, METH_NOARGS, NULL },
    {(char *) "name", (PyCFunction) _wrap_PyTiledTileset_name, METH_NOARGS, NULL },
    {(char *) "setName", (PyCFunction) _wrap_PyTiledTileset_setName, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "tileHeight", (PyCFunction) _wrap_PyTiledTileset_tileHeight, METH_NOARGS, NULL },
    {(char *) "tileWidth", (PyCFunction) _wrap_PyTiledTileset_tileWidth, METH_NOARGS, NULL },
    {(char *) "create", (PyCFunction) _wrap_PyTiledTileset_create, METH_KEYWORDS|METH_VARARGS|METH_STATIC, NULL },
    {(char *) "transparentColor", (PyCFunction) _wrap_PyTiledTileset_transparentColor, METH_NOARGS, NULL },
    {(char *) "setFileName", (PyCFunction) _wrap_PyTiledTileset_setFileName, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "tileAt", (PyCFunction) _wrap_PyTiledTileset_tileAt, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "fileName", (PyCFunction) _wrap_PyTiledTileset_fileName, METH_NOARGS, NULL },
    {(char *) "tileCount", (PyCFunction) _wrap_PyTiledTileset_tileCount, METH_NOARGS, NULL },
    {(char *) "imageHeight", (PyCFunction) _wrap_PyTiledTileset_imageHeight, METH_NOARGS, NULL },
    {(char *) "imageWidth", (PyCFunction) _wrap_PyTiledTileset_imageWidth, METH_NOARGS, NULL },
    {(char *) "setTransparentColor", (PyCFunction) _wrap_PyTiledTileset_setTransparentColor, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "margin", (PyCFunction) _wrap_PyTiledTileset_margin, METH_NOARGS, NULL },
    {(char *) "isExternal", (PyCFunction) _wrap_PyTiledTileset_isExternal, METH_NOARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledTileset__tp_dealloc(PyTiledTileset *self)
{
        Tiled::Tileset *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledTileset__tp_richcompare (PyTiledTileset *PYBINDGEN_UNUSED(self), PyTiledTileset *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledTileset_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledTileset_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.Tileset",            /* tp_name */
    sizeof(PyTiledTileset),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledTileset__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledTileset__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledTileset_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledTileset__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyTiledLayer__tp_init(void)
{
    PyErr_SetString(PyExc_TypeError, "class 'Layer' cannot be constructed ()");
    return -1;
}


PyObject *
_wrap_PyTiledLayer_opacity(PyTiledLayer *self)
{
    PyObject *py_retval;
    float retval;

    retval = self->obj->opacity();
    py_retval = Py_BuildValue((char *) "f", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_map(PyTiledLayer *self)
{
    PyObject *py_retval;
    Tiled::Map *retval;
    PyTiledMap *py_Map;

    retval = self->obj->map();
    if (!(retval)) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    py_Map = PyObject_New(PyTiledMap, &PyTiledMap_Type);
    py_Map->obj = retval;
    py_Map->flags = PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED;
    py_retval = Py_BuildValue((char *) "N", py_Map);
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_asTileLayer(PyTiledLayer *self)
{
    PyObject *py_retval;
    Tiled::TileLayer *retval;
    PyTiledTileLayer *py_TileLayer;

    retval = self->obj->asTileLayer();
    if (!(retval)) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    py_TileLayer = PyObject_New(PyTiledTileLayer, &PyTiledTileLayer_Type);
    py_TileLayer->obj = retval;
    py_TileLayer->flags = PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED;
    py_retval = Py_BuildValue((char *) "N", py_TileLayer);
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_setMap(PyTiledLayer *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    PyTiledMap *map;
    Tiled::Map *map_ptr;
    const char *keywords[] = {"map", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledMap_Type, &map)) {
        return NULL;
    }
    map_ptr = (map ? map->obj : NULL);
    self->obj->setMap(map_ptr);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_name(PyTiledLayer *self)
{
    PyObject *py_retval;
    QString retval;

    retval = self->obj->name();
    py_retval = Py_BuildValue((char *) "s", retval.toUtf8().data());
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_setName(PyTiledLayer *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    const char *name;
    Py_ssize_t name_len;
    const char *keywords[] = {"name", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#", (char **) keywords, &name, &name_len)) {
        return NULL;
    }
    self->obj->setName(QString::fromUtf8(name));
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_setX(PyTiledLayer *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int x;
    const char *keywords[] = {"x", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &x)) {
        return NULL;
    }
    self->obj->setX(x);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_asObjectGroup(PyTiledLayer *self)
{
    PyObject *py_retval;
    Tiled::ObjectGroup *retval;
    PyTiledObjectGroup *py_ObjectGroup;

    retval = self->obj->asObjectGroup();
    if (!(retval)) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    py_ObjectGroup = PyObject_New(PyTiledObjectGroup, &PyTiledObjectGroup_Type);
    py_ObjectGroup->obj = retval;
    py_ObjectGroup->flags = PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED;
    py_retval = Py_BuildValue((char *) "N", py_ObjectGroup);
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_setOpacity(PyTiledLayer *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    float opacity;
    const char *keywords[] = {"opacity", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "f", (char **) keywords, &opacity)) {
        return NULL;
    }
    self->obj->setOpacity(opacity);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_height(PyTiledLayer *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->height();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_width(PyTiledLayer *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->width();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_isVisible(PyTiledLayer *self)
{
    PyObject *py_retval;
    bool retval;

    retval = self->obj->isVisible();
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_y(PyTiledLayer *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->y();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_x(PyTiledLayer *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->x();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_setPosition(PyTiledLayer *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int x;
    int y;
    const char *keywords[] = {"x", "y", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "ii", (char **) keywords, &x, &y)) {
        return NULL;
    }
    self->obj->setPosition(x, y);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_setVisible(PyTiledLayer *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    bool visible;
    PyObject *py_visible;
    const char *keywords[] = {"visible", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O", (char **) keywords, &py_visible)) {
        return NULL;
    }
    visible = (bool) PyObject_IsTrue(py_visible);
    self->obj->setVisible(visible);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledLayer_setY(PyTiledLayer *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int y;
    const char *keywords[] = {"y", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &y)) {
        return NULL;
    }
    self->obj->setY(y);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}

static PyMethodDef PyTiledLayer_methods[] = {
    {(char *) "opacity", (PyCFunction) _wrap_PyTiledLayer_opacity, METH_NOARGS, NULL },
    {(char *) "map", (PyCFunction) _wrap_PyTiledLayer_map, METH_NOARGS, NULL },
    {(char *) "asTileLayer", (PyCFunction) _wrap_PyTiledLayer_asTileLayer, METH_NOARGS, NULL },
    {(char *) "setMap", (PyCFunction) _wrap_PyTiledLayer_setMap, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "name", (PyCFunction) _wrap_PyTiledLayer_name, METH_NOARGS, NULL },
    {(char *) "setName", (PyCFunction) _wrap_PyTiledLayer_setName, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setX", (PyCFunction) _wrap_PyTiledLayer_setX, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "asObjectGroup", (PyCFunction) _wrap_PyTiledLayer_asObjectGroup, METH_NOARGS, NULL },
    {(char *) "setOpacity", (PyCFunction) _wrap_PyTiledLayer_setOpacity, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "height", (PyCFunction) _wrap_PyTiledLayer_height, METH_NOARGS, NULL },
    {(char *) "width", (PyCFunction) _wrap_PyTiledLayer_width, METH_NOARGS, NULL },
    {(char *) "isVisible", (PyCFunction) _wrap_PyTiledLayer_isVisible, METH_NOARGS, NULL },
    {(char *) "y", (PyCFunction) _wrap_PyTiledLayer_y, METH_NOARGS, NULL },
    {(char *) "x", (PyCFunction) _wrap_PyTiledLayer_x, METH_NOARGS, NULL },
    {(char *) "setPosition", (PyCFunction) _wrap_PyTiledLayer_setPosition, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setVisible", (PyCFunction) _wrap_PyTiledLayer_setVisible, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setY", (PyCFunction) _wrap_PyTiledLayer_setY, METH_KEYWORDS|METH_VARARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledLayer__tp_dealloc(PyTiledLayer *self)
{
        Tiled::Layer *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledLayer__tp_richcompare (PyTiledLayer *PYBINDGEN_UNUSED(self), PyTiledLayer *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledLayer_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledLayer_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.Layer",            /* tp_name */
    sizeof(PyTiledLayer),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledLayer__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledLayer__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledLayer_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledLayer__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};





static int
_wrap_PyTiledMap__tp_init__0(PyTiledMap *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    PyTiledMap *ctor_arg;
    const char *keywords[] = {"ctor_arg", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledMap_Type, &ctor_arg)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return -1;
    }
    self->obj = new Tiled::Map(*((PyTiledMap *) ctor_arg)->obj);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}

static int
_wrap_PyTiledMap__tp_init__1(PyTiledMap *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    Tiled::Map::Orientation orient;
    int w;
    int h;
    int tileW;
    int tileH;
    const char *keywords[] = {"orient", "w", "h", "tileW", "tileH", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "iiiii", (char **) keywords, &orient, &w, &h, &tileW, &tileH)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return -1;
    }
    self->obj = new Tiled::Map(orient, w, h, tileW, tileH);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}

int _wrap_PyTiledMap__tp_init(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    int retval;
    PyObject *error_list;
    PyObject *exceptions[2] = {0,};
    retval = _wrap_PyTiledMap__tp_init__0(self, args, kwargs, &exceptions[0]);
    if (!exceptions[0]) {
        return retval;
    }
    retval = _wrap_PyTiledMap__tp_init__1(self, args, kwargs, &exceptions[1]);
    if (!exceptions[1]) {
        Py_DECREF(exceptions[0]);
        return retval;
    }
    error_list = PyList_New(2);
    PyList_SET_ITEM(error_list, 0, PyObject_Str(exceptions[0]));
    Py_DECREF(exceptions[0]);
    PyList_SET_ITEM(error_list, 1, PyObject_Str(exceptions[1]));
    Py_DECREF(exceptions[1]);
    PyErr_SetObject(PyExc_TypeError, error_list);
    Py_DECREF(error_list);
    return -1;
}


PyObject *
_wrap_PyTiledMap_setOrientation(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    Tiled::Map::Orientation o;
    const char *keywords[] = {"o", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &o)) {
        return NULL;
    }
    self->obj->setOrientation(o);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_setHeight(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int h;
    const char *keywords[] = {"h", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &h)) {
        return NULL;
    }
    self->obj->setHeight(h);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_isTilesetUsed(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    bool retval;
    PyTiledTileset *tileset;
    Tiled::Tileset *tileset_ptr;
    const char *keywords[] = {"tileset", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledTileset_Type, &tileset)) {
        return NULL;
    }
    tileset_ptr = (tileset ? tileset->obj : NULL);
    retval = self->obj->isTilesetUsed(tileset_ptr);
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_layerAt(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    Tiled::Layer *retval;
    int idx;
    const char *keywords[] = {"idx", NULL};
    PyTiledLayer *py_Layer;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &idx)) {
        return NULL;
    }
    retval = self->obj->layerAt(idx);
    if (!(retval)) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    py_Layer = PyObject_New(PyTiledLayer, &PyTiledLayer_Type);
    py_Layer->obj = retval;
    py_Layer->flags = PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED;
    py_retval = Py_BuildValue((char *) "N", py_Layer);
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_removeTilesetAt(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int pos;
    const char *keywords[] = {"pos", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &pos)) {
        return NULL;
    }
    self->obj->removeTilesetAt(pos);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_orientation(PyTiledMap *self)
{
    PyObject *py_retval;
    Tiled::Map::Orientation retval;

    retval = self->obj->orientation();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_tileLayerCount(PyTiledMap *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->tileLayerCount();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_tileHeight(PyTiledMap *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->tileHeight();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_insertTileset(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int pos;
    PyTiledSharedTileset *tileset;
    const char *keywords[] = {"pos", "tileset", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "iO!", (char **) keywords, &pos, &PyTiledSharedTileset_Type, &tileset)) {
        return NULL;
    }
    self->obj->insertTileset(pos, *((PyTiledSharedTileset *) tileset)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_tileWidth(PyTiledMap *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->tileWidth();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_height(PyTiledMap *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->height();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_width(PyTiledMap *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->width();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_replaceTileset(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    PyTiledSharedTileset *oldTileset;
    PyTiledSharedTileset *newTileset;
    const char *keywords[] = {"oldTileset", "newTileset", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!O!", (char **) keywords, &PyTiledSharedTileset_Type, &oldTileset, &PyTiledSharedTileset_Type, &newTileset)) {
        return NULL;
    }
    self->obj->replaceTileset(*((PyTiledSharedTileset *) oldTileset)->obj, *((PyTiledSharedTileset *) newTileset)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_indexOfTileset(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int retval;
    PyTiledSharedTileset *tileset;
    const char *keywords[] = {"tileset", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledSharedTileset_Type, &tileset)) {
        return NULL;
    }
    retval = self->obj->indexOfTileset(*((PyTiledSharedTileset *) tileset)->obj);
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_addTileset(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    PyTiledSharedTileset *tileset;
    const char *keywords[] = {"tileset", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledSharedTileset_Type, &tileset)) {
        return NULL;
    }
    self->obj->addTileset(*((PyTiledSharedTileset *) tileset)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_layerCount(PyTiledMap *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->layerCount();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}



PyObject *
_wrap_PyTiledMap_addLayer__0(PyTiledMap *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    PyObject *py_retval;
    PyTiledImageLayer *l;
    Tiled::ImageLayer *l_ptr;
    const char *keywords[] = {"l", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledImageLayer_Type, &l)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return NULL;
    }
    l_ptr = (l ? l->obj : NULL);
    self->obj->addLayer(l_ptr);
    if (l) {
        l->obj = NULL;
    }
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}

PyObject *
_wrap_PyTiledMap_addLayer__1(PyTiledMap *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    PyObject *py_retval;
    PyTiledTileLayer *l;
    Tiled::TileLayer *l_ptr;
    const char *keywords[] = {"l", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledTileLayer_Type, &l)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return NULL;
    }
    l_ptr = (l ? l->obj : NULL);
    self->obj->addLayer(l_ptr);
    if (l) {
        l->obj = NULL;
    }
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}

PyObject *
_wrap_PyTiledMap_addLayer__2(PyTiledMap *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    PyObject *py_retval;
    PyTiledObjectGroup *l;
    Tiled::ObjectGroup *l_ptr;
    const char *keywords[] = {"l", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledObjectGroup_Type, &l)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return NULL;
    }
    l_ptr = (l ? l->obj : NULL);
    self->obj->addLayer(l_ptr);
    if (l) {
        l->obj = NULL;
    }
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}

PyObject * _wrap_PyTiledMap_addLayer(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    PyObject * retval;
    PyObject *error_list;
    PyObject *exceptions[3] = {0,};
    retval = _wrap_PyTiledMap_addLayer__0(self, args, kwargs, &exceptions[0]);
    if (!exceptions[0]) {
        return retval;
    }
    retval = _wrap_PyTiledMap_addLayer__1(self, args, kwargs, &exceptions[1]);
    if (!exceptions[1]) {
        Py_DECREF(exceptions[0]);
        return retval;
    }
    retval = _wrap_PyTiledMap_addLayer__2(self, args, kwargs, &exceptions[2]);
    if (!exceptions[2]) {
        Py_DECREF(exceptions[0]);
        Py_DECREF(exceptions[1]);
        return retval;
    }
    error_list = PyList_New(3);
    PyList_SET_ITEM(error_list, 0, PyObject_Str(exceptions[0]));
    Py_DECREF(exceptions[0]);
    PyList_SET_ITEM(error_list, 1, PyObject_Str(exceptions[1]));
    Py_DECREF(exceptions[1]);
    PyList_SET_ITEM(error_list, 2, PyObject_Str(exceptions[2]));
    Py_DECREF(exceptions[2]);
    PyErr_SetObject(PyExc_TypeError, error_list);
    Py_DECREF(error_list);
    return NULL;
}


PyObject *
_wrap_PyTiledMap_tilesetAt(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int idx;
    const char *keywords[] = {"idx", NULL};
    PyTiledSharedTileset *py_SharedTileset;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &idx)) {
        return NULL;
    }
    Tiled::SharedTileset retval = self->obj->tilesetAt(idx);
    py_SharedTileset = PyObject_New(PyTiledSharedTileset, &PyTiledSharedTileset_Type);
    py_SharedTileset->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_SharedTileset->obj = new Tiled::SharedTileset(retval);
    py_retval = Py_BuildValue((char *) "N", py_SharedTileset);
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_objectGroupCount(PyTiledMap *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->objectGroupCount();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_setWidth(PyTiledMap *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int w;
    const char *keywords[] = {"w", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &w)) {
        return NULL;
    }
    self->obj->setWidth(w);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMap_tilesetCount(PyTiledMap *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->tilesetCount();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


static PyObject*
_wrap_PyTiledMap__copy__(PyTiledMap *self)
{

    PyTiledMap *py_copy;
    py_copy = PyObject_New(PyTiledMap, &PyTiledMap_Type);
    py_copy->obj = new Tiled::Map(*self->obj);
    py_copy->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return (PyObject*) py_copy;
}

static PyMethodDef PyTiledMap_methods[] = {
    {(char *) "setOrientation", (PyCFunction) _wrap_PyTiledMap_setOrientation, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setHeight", (PyCFunction) _wrap_PyTiledMap_setHeight, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "isTilesetUsed", (PyCFunction) _wrap_PyTiledMap_isTilesetUsed, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "layerAt", (PyCFunction) _wrap_PyTiledMap_layerAt, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "removeTilesetAt", (PyCFunction) _wrap_PyTiledMap_removeTilesetAt, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "orientation", (PyCFunction) _wrap_PyTiledMap_orientation, METH_NOARGS, NULL },
    {(char *) "tileLayerCount", (PyCFunction) _wrap_PyTiledMap_tileLayerCount, METH_NOARGS, NULL },
    {(char *) "tileHeight", (PyCFunction) _wrap_PyTiledMap_tileHeight, METH_NOARGS, NULL },
    {(char *) "insertTileset", (PyCFunction) _wrap_PyTiledMap_insertTileset, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "tileWidth", (PyCFunction) _wrap_PyTiledMap_tileWidth, METH_NOARGS, NULL },
    {(char *) "height", (PyCFunction) _wrap_PyTiledMap_height, METH_NOARGS, NULL },
    {(char *) "width", (PyCFunction) _wrap_PyTiledMap_width, METH_NOARGS, NULL },
    {(char *) "replaceTileset", (PyCFunction) _wrap_PyTiledMap_replaceTileset, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "indexOfTileset", (PyCFunction) _wrap_PyTiledMap_indexOfTileset, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "addTileset", (PyCFunction) _wrap_PyTiledMap_addTileset, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "layerCount", (PyCFunction) _wrap_PyTiledMap_layerCount, METH_NOARGS, NULL },
    {(char *) "addLayer", (PyCFunction) _wrap_PyTiledMap_addLayer, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "tilesetAt", (PyCFunction) _wrap_PyTiledMap_tilesetAt, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "objectGroupCount", (PyCFunction) _wrap_PyTiledMap_objectGroupCount, METH_NOARGS, NULL },
    {(char *) "setWidth", (PyCFunction) _wrap_PyTiledMap_setWidth, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "tilesetCount", (PyCFunction) _wrap_PyTiledMap_tilesetCount, METH_NOARGS, NULL },
    {(char *) "__copy__", (PyCFunction) _wrap_PyTiledMap__copy__, METH_NOARGS, NULL},
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledMap__tp_dealloc(PyTiledMap *self)
{
        Tiled::Map *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledMap__tp_richcompare (PyTiledMap *PYBINDGEN_UNUSED(self), PyTiledMap *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledMap_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledMap_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.Map",            /* tp_name */
    sizeof(PyTiledMap),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledMap__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledMap__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledMap_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledMap__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};



static PyObject* _wrap_PyTiledCell__get_tile(PyTiledCell *self, void * PYBINDGEN_UNUSED(closure))
{
    PyObject *py_retval;
    PyTiledTile *py_Tile;

    if (!(self->obj->tile)) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    py_Tile = PyObject_New(PyTiledTile, &PyTiledTile_Type);
    py_Tile->obj = new Tiled::Tile((*self->obj->tile));
    py_Tile->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_retval = Py_BuildValue((char *) "N", py_Tile);
    return py_retval;
}
static PyGetSetDef PyTiledCell__getsets[] = {
    {
        (char*) "tile", /* attribute name */
        (getter) _wrap_PyTiledCell__get_tile, /* C function to get the attribute */
        (setter) NULL, /* C function to set the attribute */
        NULL, /* optional doc string */
        NULL /* optional additional data for getter and setter */
    },
    { NULL, NULL, NULL, NULL, NULL }
};

static int
_wrap_PyTiledCell__tp_init(PyTiledCell *self, PyObject *args, PyObject *kwargs)
{
    PyTiledTile *tile;
    Tiled::Tile *tile_ptr;
    const char *keywords[] = {"tile", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledTile_Type, &tile)) {
        return -1;
    }
    tile_ptr = (tile ? tile->obj : NULL);
    self->obj = new Tiled::Cell(tile_ptr);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}


PyObject *
_wrap_PyTiledCell_isEmpty(PyTiledCell *self)
{
    PyObject *py_retval;
    bool retval;

    retval = self->obj->isEmpty();
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}

static PyMethodDef PyTiledCell_methods[] = {
    {(char *) "isEmpty", (PyCFunction) _wrap_PyTiledCell_isEmpty, METH_NOARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledCell__tp_dealloc(PyTiledCell *self)
{
        Tiled::Cell *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledCell__tp_richcompare (PyTiledCell *PYBINDGEN_UNUSED(self), PyTiledCell *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledCell_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledCell_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.Cell",            /* tp_name */
    sizeof(PyTiledCell),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledCell__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledCell__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledCell_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    PyTiledCell__getsets,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledCell__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyTiledTileLayer__tp_init(PyTiledTileLayer *self, PyObject *args, PyObject *kwargs)
{
    const char *name;
    Py_ssize_t name_len;
    int x;
    int y;
    int w;
    int h;
    const char *keywords[] = {"name", "x", "y", "w", "h", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#iiii", (char **) keywords, &name, &name_len, &x, &y, &w, &h)) {
        return -1;
    }
    self->obj = new Tiled::TileLayer(QString::fromUtf8(name), x, y, w, h);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}


PyObject *
_wrap_PyTiledTileLayer_referencesTileset(PyTiledTileLayer *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    bool retval;
    PyTiledTileset *ts;
    Tiled::Tileset *ts_ptr;
    const char *keywords[] = {"ts", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledTileset_Type, &ts)) {
        return NULL;
    }
    ts_ptr = (ts ? ts->obj : NULL);
    retval = self->obj->referencesTileset(ts_ptr);
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}


PyObject *
_wrap_PyTiledTileLayer_setCell(PyTiledTileLayer *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int x;
    int y;
    PyTiledCell *c;
    const char *keywords[] = {"x", "y", "c", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "iiO!", (char **) keywords, &x, &y, &PyTiledCell_Type, &c)) {
        return NULL;
    }
    self->obj->setCell(x, y, *((PyTiledCell *) c)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledTileLayer_isEmpty(PyTiledTileLayer *self)
{
    PyObject *py_retval;
    bool retval;

    retval = self->obj->isEmpty();
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}


PyObject *
_wrap_PyTiledTileLayer_cellAt(PyTiledTileLayer *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int x;
    int y;
    const char *keywords[] = {"x", "y", NULL};
    PyTiledCell *py_Cell;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "ii", (char **) keywords, &x, &y)) {
        return NULL;
    }
    Tiled::Cell retval = self->obj->cellAt(x, y);
    py_Cell = PyObject_New(PyTiledCell, &PyTiledCell_Type);
    py_Cell->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_Cell->obj = new Tiled::Cell(retval);
    py_retval = Py_BuildValue((char *) "N", py_Cell);
    return py_retval;
}

static PyMethodDef PyTiledTileLayer_methods[] = {
    {(char *) "referencesTileset", (PyCFunction) _wrap_PyTiledTileLayer_referencesTileset, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setCell", (PyCFunction) _wrap_PyTiledTileLayer_setCell, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "isEmpty", (PyCFunction) _wrap_PyTiledTileLayer_isEmpty, METH_NOARGS, NULL },
    {(char *) "cellAt", (PyCFunction) _wrap_PyTiledTileLayer_cellAt, METH_KEYWORDS|METH_VARARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledTileLayer__tp_dealloc(PyTiledTileLayer *self)
{
        Tiled::TileLayer *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledTileLayer__tp_richcompare (PyTiledTileLayer *PYBINDGEN_UNUSED(self), PyTiledTileLayer *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledTileLayer_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledTileLayer_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.TileLayer",            /* tp_name */
    sizeof(PyTiledTileLayer),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledTileLayer__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledTileLayer__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledTileLayer_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledTileLayer__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyTiledImageLayer__tp_init(PyTiledImageLayer *self, PyObject *args, PyObject *kwargs)
{
    const char *name;
    Py_ssize_t name_len;
    int x;
    int y;
    int w;
    int h;
    const char *keywords[] = {"name", "x", "y", "w", "h", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#iiii", (char **) keywords, &name, &name_len, &x, &y, &w, &h)) {
        return -1;
    }
    self->obj = new Tiled::ImageLayer(QString::fromUtf8(name), x, y, w, h);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}


PyObject *
_wrap_PyTiledImageLayer_image(PyTiledImageLayer *self)
{
    PyObject *py_retval;
    PyQPixmap *py_QPixmap;

    QPixmap const & retval = self->obj->image();
    py_QPixmap = PyObject_New(PyQPixmap, &PyQPixmap_Type);
    py_QPixmap->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_QPixmap->obj = new QPixmap(retval);
    py_retval = Py_BuildValue((char *) "N", py_QPixmap);
    return py_retval;
}


PyObject *
_wrap_PyTiledImageLayer_loadFromImage(PyTiledImageLayer *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    bool retval;
    PyQImage *img;
    const char *file;
    Py_ssize_t file_len;
    const char *keywords[] = {"img", "file", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!s#", (char **) keywords, &PyQImage_Type, &img, &file, &file_len)) {
        return NULL;
    }
    retval = self->obj->loadFromImage(*((PyQImage *) img)->obj, QString::fromUtf8(file));
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}


PyObject *
_wrap_PyTiledImageLayer_setImage(PyTiledImageLayer *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    PyQPixmap *image;
    const char *keywords[] = {"image", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyQPixmap_Type, &image)) {
        return NULL;
    }
    self->obj->setImage(*((PyQPixmap *) image)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}

static PyMethodDef PyTiledImageLayer_methods[] = {
    {(char *) "image", (PyCFunction) _wrap_PyTiledImageLayer_image, METH_NOARGS, NULL },
    {(char *) "loadFromImage", (PyCFunction) _wrap_PyTiledImageLayer_loadFromImage, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setImage", (PyCFunction) _wrap_PyTiledImageLayer_setImage, METH_KEYWORDS|METH_VARARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledImageLayer__tp_dealloc(PyTiledImageLayer *self)
{
        Tiled::ImageLayer *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledImageLayer__tp_richcompare (PyTiledImageLayer *PYBINDGEN_UNUSED(self), PyTiledImageLayer *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledImageLayer_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledImageLayer_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.ImageLayer",            /* tp_name */
    sizeof(PyTiledImageLayer),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledImageLayer__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledImageLayer__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledImageLayer_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledImageLayer__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};





static int
_wrap_PyTiledMapObject__tp_init__0(PyTiledMapObject *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    const char *keywords[] = {NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "", (char **) keywords)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return -1;
    }
    self->obj = new Tiled::MapObject();
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}

static int
_wrap_PyTiledMapObject__tp_init__1(PyTiledMapObject *self, PyObject *args, PyObject *kwargs, PyObject **return_exception)
{
    const char *name;
    Py_ssize_t name_len;
    const char *type;
    Py_ssize_t type_len;
    PyQPointF *pos;
    PyQSizeF *size;
    const char *keywords[] = {"name", "type", "pos", "size", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#s#O!O!", (char **) keywords, &name, &name_len, &type, &type_len, &PyQPointF_Type, &pos, &PyQSizeF_Type, &size)) {
        {
            PyObject *exc_type, *traceback;
            PyErr_Fetch(&exc_type, return_exception, &traceback);
            Py_XDECREF(exc_type);
            Py_XDECREF(traceback);
        }
        return -1;
    }
    self->obj = new Tiled::MapObject(QString::fromUtf8(name), QString::fromUtf8(type), *((PyQPointF *) pos)->obj, *((PyQSizeF *) size)->obj);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}

int _wrap_PyTiledMapObject__tp_init(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    int retval;
    PyObject *error_list;
    PyObject *exceptions[2] = {0,};
    retval = _wrap_PyTiledMapObject__tp_init__0(self, args, kwargs, &exceptions[0]);
    if (!exceptions[0]) {
        return retval;
    }
    retval = _wrap_PyTiledMapObject__tp_init__1(self, args, kwargs, &exceptions[1]);
    if (!exceptions[1]) {
        Py_DECREF(exceptions[0]);
        return retval;
    }
    error_list = PyList_New(2);
    PyList_SET_ITEM(error_list, 0, PyObject_Str(exceptions[0]));
    Py_DECREF(exceptions[0]);
    PyList_SET_ITEM(error_list, 1, PyObject_Str(exceptions[1]));
    Py_DECREF(exceptions[1]);
    PyErr_SetObject(PyExc_TypeError, error_list);
    Py_DECREF(error_list);
    return -1;
}


PyObject *
_wrap_PyTiledMapObject_height(PyTiledMapObject *self)
{
    PyObject *py_retval;
    float retval;

    retval = self->obj->height();
    py_retval = Py_BuildValue((char *) "f", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_shape(PyTiledMapObject *self)
{
    PyObject *py_retval;
    Tiled::MapObject::Shape retval;

    retval = self->obj->shape();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_setCell(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    PyTiledCell *c;
    const char *keywords[] = {"c", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledCell_Type, &c)) {
        return NULL;
    }
    self->obj->setCell(*((PyTiledCell *) c)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_setWidth(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    float w;
    const char *keywords[] = {"w", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "f", (char **) keywords, &w)) {
        return NULL;
    }
    self->obj->setWidth(w);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_setPosition(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    PyQPointF *pos;
    const char *keywords[] = {"pos", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyQPointF_Type, &pos)) {
        return NULL;
    }
    self->obj->setPosition(*((PyQPointF *) pos)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_setType(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    const char *n;
    Py_ssize_t n_len;
    const char *keywords[] = {"n", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#", (char **) keywords, &n, &n_len)) {
        return NULL;
    }
    self->obj->setType(QString::fromUtf8(n));
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_cell(PyTiledMapObject *self)
{
    PyObject *py_retval;
    PyTiledCell *py_Cell;

    Tiled::Cell const retval = self->obj->cell();
    py_Cell = PyObject_New(PyTiledCell, &PyTiledCell_Type);
    py_Cell->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_Cell->obj = new Tiled::Cell(retval);
    py_retval = Py_BuildValue((char *) "N", py_Cell);
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_width(PyTiledMapObject *self)
{
    PyObject *py_retval;
    float retval;

    retval = self->obj->width();
    py_retval = Py_BuildValue((char *) "f", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_setRotation(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    float r;
    const char *keywords[] = {"r", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "f", (char **) keywords, &r)) {
        return NULL;
    }
    self->obj->setRotation(r);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_type(PyTiledMapObject *self)
{
    PyObject *py_retval;
    QString retval;

    retval = self->obj->type();
    py_retval = Py_BuildValue((char *) "s", retval.toUtf8().data());
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_setName(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    const char *n;
    Py_ssize_t n_len;
    const char *keywords[] = {"n", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#", (char **) keywords, &n, &n_len)) {
        return NULL;
    }
    self->obj->setName(QString::fromUtf8(n));
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_rotation(PyTiledMapObject *self)
{
    PyObject *py_retval;
    float retval;

    retval = self->obj->rotation();
    py_retval = Py_BuildValue((char *) "f", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_setX(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    float x;
    const char *keywords[] = {"x", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "f", (char **) keywords, &x)) {
        return NULL;
    }
    self->obj->setX(x);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_setY(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    float y;
    const char *keywords[] = {"y", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "f", (char **) keywords, &y)) {
        return NULL;
    }
    self->obj->setY(y);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_setHeight(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    float h;
    const char *keywords[] = {"h", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "f", (char **) keywords, &h)) {
        return NULL;
    }
    self->obj->setHeight(h);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_name(PyTiledMapObject *self)
{
    PyObject *py_retval;
    QString retval;

    retval = self->obj->name();
    py_retval = Py_BuildValue((char *) "s", retval.toUtf8().data());
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_setSize(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    PyQSizeF *size;
    const char *keywords[] = {"size", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyQSizeF_Type, &size)) {
        return NULL;
    }
    self->obj->setSize(*((PyQSizeF *) size)->obj);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_isVisible(PyTiledMapObject *self)
{
    PyObject *py_retval;
    bool retval;

    retval = self->obj->isVisible();
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_y(PyTiledMapObject *self)
{
    PyObject *py_retval;
    float retval;

    retval = self->obj->y();
    py_retval = Py_BuildValue((char *) "f", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_x(PyTiledMapObject *self)
{
    PyObject *py_retval;
    float retval;

    retval = self->obj->x();
    py_retval = Py_BuildValue((char *) "f", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_setVisible(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    bool v;
    PyObject *py_v;
    const char *keywords[] = {"v", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O", (char **) keywords, &py_v)) {
        return NULL;
    }
    v = (bool) PyObject_IsTrue(py_v);
    self->obj->setVisible(v);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledMapObject_setShape(PyTiledMapObject *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    Tiled::MapObject::Shape s;
    const char *keywords[] = {"s", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &s)) {
        return NULL;
    }
    self->obj->setShape(s);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}

static PyMethodDef PyTiledMapObject_methods[] = {
    {(char *) "height", (PyCFunction) _wrap_PyTiledMapObject_height, METH_NOARGS, NULL },
    {(char *) "shape", (PyCFunction) _wrap_PyTiledMapObject_shape, METH_NOARGS, NULL },
    {(char *) "setCell", (PyCFunction) _wrap_PyTiledMapObject_setCell, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setWidth", (PyCFunction) _wrap_PyTiledMapObject_setWidth, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setPosition", (PyCFunction) _wrap_PyTiledMapObject_setPosition, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setType", (PyCFunction) _wrap_PyTiledMapObject_setType, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "cell", (PyCFunction) _wrap_PyTiledMapObject_cell, METH_NOARGS, NULL },
    {(char *) "width", (PyCFunction) _wrap_PyTiledMapObject_width, METH_NOARGS, NULL },
    {(char *) "setRotation", (PyCFunction) _wrap_PyTiledMapObject_setRotation, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "type", (PyCFunction) _wrap_PyTiledMapObject_type, METH_NOARGS, NULL },
    {(char *) "setName", (PyCFunction) _wrap_PyTiledMapObject_setName, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "rotation", (PyCFunction) _wrap_PyTiledMapObject_rotation, METH_NOARGS, NULL },
    {(char *) "setX", (PyCFunction) _wrap_PyTiledMapObject_setX, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setY", (PyCFunction) _wrap_PyTiledMapObject_setY, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setHeight", (PyCFunction) _wrap_PyTiledMapObject_setHeight, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "name", (PyCFunction) _wrap_PyTiledMapObject_name, METH_NOARGS, NULL },
    {(char *) "setSize", (PyCFunction) _wrap_PyTiledMapObject_setSize, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "isVisible", (PyCFunction) _wrap_PyTiledMapObject_isVisible, METH_NOARGS, NULL },
    {(char *) "y", (PyCFunction) _wrap_PyTiledMapObject_y, METH_NOARGS, NULL },
    {(char *) "x", (PyCFunction) _wrap_PyTiledMapObject_x, METH_NOARGS, NULL },
    {(char *) "setVisible", (PyCFunction) _wrap_PyTiledMapObject_setVisible, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "setShape", (PyCFunction) _wrap_PyTiledMapObject_setShape, METH_KEYWORDS|METH_VARARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledMapObject__tp_dealloc(PyTiledMapObject *self)
{
        Tiled::MapObject *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledMapObject__tp_richcompare (PyTiledMapObject *PYBINDGEN_UNUSED(self), PyTiledMapObject *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledMapObject_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledMapObject_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.MapObject",            /* tp_name */
    sizeof(PyTiledMapObject),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledMapObject__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledMapObject__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledMapObject_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledMapObject__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyTiledObjectGroup__tp_init(PyTiledObjectGroup *self, PyObject *args, PyObject *kwargs)
{
    const char *name;
    Py_ssize_t name_len;
    int x;
    int y;
    int w;
    int h;
    const char *keywords[] = {"name", "x", "y", "w", "h", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "s#iiii", (char **) keywords, &name, &name_len, &x, &y, &w, &h)) {
        return -1;
    }
    self->obj = new Tiled::ObjectGroup(QString::fromUtf8(name), x, y, w, h);
    self->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    return 0;
}


PyObject *
_wrap_PyTiledObjectGroup_addObject(PyTiledObjectGroup *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    PyTiledMapObject *object;
    Tiled::MapObject *object_ptr;
    const char *keywords[] = {"object", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledMapObject_Type, &object)) {
        return NULL;
    }
    object_ptr = (object ? object->obj : NULL);
    self->obj->addObject(object_ptr);
    if (object) {
        object->obj = NULL;
    }
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledObjectGroup_referencesTileset(PyTiledObjectGroup *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    bool retval;
    PyTiledTileset *ts;
    Tiled::Tileset *ts_ptr;
    const char *keywords[] = {"ts", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledTileset_Type, &ts)) {
        return NULL;
    }
    ts_ptr = (ts ? ts->obj : NULL);
    retval = self->obj->referencesTileset(ts_ptr);
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}


PyObject *
_wrap_PyTiledObjectGroup_objectAt(PyTiledObjectGroup *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    Tiled::MapObject *retval;
    int index;
    const char *keywords[] = {"index", NULL};
    PyTiledMapObject *py_MapObject;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "i", (char **) keywords, &index)) {
        return NULL;
    }
    retval = self->obj->objectAt(index);
    if (!(retval)) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    py_MapObject = PyObject_New(PyTiledMapObject, &PyTiledMapObject_Type);
    py_MapObject->obj = retval;
    py_MapObject->flags = PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED;
    py_retval = Py_BuildValue((char *) "N", py_MapObject);
    return py_retval;
}


PyObject *
_wrap_PyTiledObjectGroup_objectCount(PyTiledObjectGroup *self)
{
    PyObject *py_retval;
    int retval;

    retval = self->obj->objectCount();
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}


PyObject *
_wrap_PyTiledObjectGroup_insertObject(PyTiledObjectGroup *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int idx;
    PyTiledMapObject *object;
    Tiled::MapObject *object_ptr;
    const char *keywords[] = {"idx", "object", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "iO!", (char **) keywords, &idx, &PyTiledMapObject_Type, &object)) {
        return NULL;
    }
    object_ptr = (object ? object->obj : NULL);
    self->obj->insertObject(idx, object_ptr);
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}


PyObject *
_wrap_PyTiledObjectGroup_removeObject(PyTiledObjectGroup *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    int retval;
    PyTiledMapObject *object;
    Tiled::MapObject *object_ptr;
    const char *keywords[] = {"object", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!", (char **) keywords, &PyTiledMapObject_Type, &object)) {
        return NULL;
    }
    object_ptr = (object ? object->obj : NULL);
    retval = self->obj->removeObject(object_ptr);
    py_retval = Py_BuildValue((char *) "i", retval);
    return py_retval;
}

static PyMethodDef PyTiledObjectGroup_methods[] = {
    {(char *) "addObject", (PyCFunction) _wrap_PyTiledObjectGroup_addObject, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "referencesTileset", (PyCFunction) _wrap_PyTiledObjectGroup_referencesTileset, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "objectAt", (PyCFunction) _wrap_PyTiledObjectGroup_objectAt, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "objectCount", (PyCFunction) _wrap_PyTiledObjectGroup_objectCount, METH_NOARGS, NULL },
    {(char *) "insertObject", (PyCFunction) _wrap_PyTiledObjectGroup_insertObject, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "removeObject", (PyCFunction) _wrap_PyTiledObjectGroup_removeObject, METH_KEYWORDS|METH_VARARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledObjectGroup__tp_dealloc(PyTiledObjectGroup *self)
{
        Tiled::ObjectGroup *tmp = self->obj;
        self->obj = NULL;
        if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
            delete tmp;
        }
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledObjectGroup__tp_richcompare (PyTiledObjectGroup *PYBINDGEN_UNUSED(self), PyTiledObjectGroup *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledObjectGroup_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledObjectGroup_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.ObjectGroup",            /* tp_name */
    sizeof(PyTiledObjectGroup),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledObjectGroup__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledObjectGroup__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledObjectGroup_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledObjectGroup__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};




static int
_wrap_PyTiledLoggingInterface__tp_init(void)
{
    PyErr_SetString(PyExc_TypeError, "class 'LoggingInterface' cannot be constructed ()");
    return -1;
}


PyObject *
_wrap_PyTiledLoggingInterface_log(PyTiledLoggingInterface *self, PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    Tiled::LoggingInterface::OutputType type;
    const char *msg;
    Py_ssize_t msg_len;
    const char *keywords[] = {"type", "msg", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "is#", (char **) keywords, &type, &msg, &msg_len)) {
        return NULL;
    }
    self->obj->log(type, QString::fromUtf8(msg));
    Py_INCREF(Py_None);
    py_retval = Py_None;
    return py_retval;
}

static PyMethodDef PyTiledLoggingInterface_methods[] = {
    {(char *) "log", (PyCFunction) _wrap_PyTiledLoggingInterface_log, METH_KEYWORDS|METH_VARARGS, NULL },
    {NULL, NULL, 0, NULL}
};

static void
_wrap_PyTiledLoggingInterface__tp_dealloc(PyTiledLoggingInterface *self)
{
        self->obj = NULL;

    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyTiledLoggingInterface__tp_richcompare (PyTiledLoggingInterface *PYBINDGEN_UNUSED(self), PyTiledLoggingInterface *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyTiledLoggingInterface_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyTiledLoggingInterface_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.Tiled.LoggingInterface",            /* tp_name */
    sizeof(PyTiledLoggingInterface),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyTiledLoggingInterface__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)NULL,     /* tp_traverse */
    (inquiry)NULL,             /* tp_clear */
    (richcmpfunc)_wrap_PyTiledLoggingInterface__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyTiledLoggingInterface_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    0,                 /* tp_dictoffset */
    (initproc)_wrap_PyTiledLoggingInterface__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};


/* --- enumerations --- */







#if PY_VERSION_HEX >= 0x03000000
static struct PyModuleDef Tiled_moduledef = {
    PyModuleDef_HEAD_INIT,
    "tiled.Tiled",
    NULL,
    -1,
    tiled_Tiled_functions,
};
#endif

static PyObject *
inittiled_Tiled(void)
{
    PyObject *m;
    #if PY_VERSION_HEX >= 0x03000000
    m = PyModule_Create(&Tiled_moduledef);
    #else
    m = Py_InitModule3((char *) "tiled.Tiled", tiled_Tiled_functions, NULL);
    #endif
    if (m == NULL) {
        return NULL;
    }
    /* Register the 'Tiled::Properties' class */
    if (PyType_Ready(&PyTiledProperties_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "Properties", (PyObject *) &PyTiledProperties_Type);
    /* Register the 'Tiled::Object' class */
    if (PyType_Ready(&PyTiledObject_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "Object", (PyObject *) &PyTiledObject_Type);
    /* Register the 'Tiled::Tile' class */
    PyTiledTile_Type.tp_base = &PyTiledObject_Type;
    if (PyType_Ready(&PyTiledTile_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "Tile", (PyObject *) &PyTiledTile_Type);
    /* Register the 'Tiled::SharedTileset' class */
    if (PyType_Ready(&PyTiledSharedTileset_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "SharedTileset", (PyObject *) &PyTiledSharedTileset_Type);
    /* Register the 'Tiled::Tileset' class */
    PyTiledTileset_Type.tp_base = &PyTiledObject_Type;
    if (PyType_Ready(&PyTiledTileset_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "Tileset", (PyObject *) &PyTiledTileset_Type);
    /* Register the 'Tiled::Layer' class */
    PyTiledLayer_Type.tp_base = &PyTiledObject_Type;
    if (PyType_Ready(&PyTiledLayer_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "Layer", (PyObject *) &PyTiledLayer_Type);
    /* Register the 'Tiled::Map' class */
    PyTiledMap_Type.tp_base = &PyTiledObject_Type;
    if (PyType_Ready(&PyTiledMap_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "Map", (PyObject *) &PyTiledMap_Type);
    /* Register the 'Tiled::Cell' class */
    if (PyType_Ready(&PyTiledCell_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "Cell", (PyObject *) &PyTiledCell_Type);
    /* Register the 'Tiled::TileLayer' class */
    PyTiledTileLayer_Type.tp_base = &PyTiledLayer_Type;
    if (PyType_Ready(&PyTiledTileLayer_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "TileLayer", (PyObject *) &PyTiledTileLayer_Type);
    /* Register the 'Tiled::ImageLayer' class */
    PyTiledImageLayer_Type.tp_base = &PyTiledLayer_Type;
    if (PyType_Ready(&PyTiledImageLayer_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "ImageLayer", (PyObject *) &PyTiledImageLayer_Type);
    /* Register the 'Tiled::MapObject' class */
    PyTiledMapObject_Type.tp_base = &PyTiledObject_Type;
    if (PyType_Ready(&PyTiledMapObject_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "MapObject", (PyObject *) &PyTiledMapObject_Type);
    /* Register the 'Tiled::ObjectGroup' class */
    PyTiledObjectGroup_Type.tp_base = &PyTiledLayer_Type;
    if (PyType_Ready(&PyTiledObjectGroup_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "ObjectGroup", (PyObject *) &PyTiledObjectGroup_Type);
    /* Register the 'Tiled::LoggingInterface' class */
    if (PyType_Ready(&PyTiledLoggingInterface_Type)) {
        return NULL;
    }
    PyModule_AddObject(m, (char *) "LoggingInterface", (PyObject *) &PyTiledLoggingInterface_Type);
    {
        PyObject *tmp_value;
         // Tiled::Map::Unknown
        tmp_value = PyLong_FromLong(Tiled::Map::Unknown);
        PyDict_SetItemString((PyObject*) PyTiledMap_Type.tp_dict, "Unknown", tmp_value);
        Py_DECREF(tmp_value);
         // Tiled::Map::Orthogonal
        tmp_value = PyLong_FromLong(Tiled::Map::Orthogonal);
        PyDict_SetItemString((PyObject*) PyTiledMap_Type.tp_dict, "Orthogonal", tmp_value);
        Py_DECREF(tmp_value);
         // Tiled::Map::Isometric
        tmp_value = PyLong_FromLong(Tiled::Map::Isometric);
        PyDict_SetItemString((PyObject*) PyTiledMap_Type.tp_dict, "Isometric", tmp_value);
        Py_DECREF(tmp_value);
    }
    {
        PyObject *tmp_value;
         // Tiled::MapObject::Rectangle
        tmp_value = PyLong_FromLong(Tiled::MapObject::Rectangle);
        PyDict_SetItemString((PyObject*) PyTiledMapObject_Type.tp_dict, "Rectangle", tmp_value);
        Py_DECREF(tmp_value);
         // Tiled::MapObject::Polygon
        tmp_value = PyLong_FromLong(Tiled::MapObject::Polygon);
        PyDict_SetItemString((PyObject*) PyTiledMapObject_Type.tp_dict, "Polygon", tmp_value);
        Py_DECREF(tmp_value);
         // Tiled::MapObject::Polyline
        tmp_value = PyLong_FromLong(Tiled::MapObject::Polyline);
        PyDict_SetItemString((PyObject*) PyTiledMapObject_Type.tp_dict, "Polyline", tmp_value);
        Py_DECREF(tmp_value);
    }
    {
        PyObject *tmp_value;
         // Tiled::LoggingInterface::INFO
        tmp_value = PyLong_FromLong(Tiled::LoggingInterface::INFO);
        PyDict_SetItemString((PyObject*) PyTiledLoggingInterface_Type.tp_dict, "INFO", tmp_value);
        Py_DECREF(tmp_value);
         // Tiled::LoggingInterface::ERROR
        tmp_value = PyLong_FromLong(Tiled::LoggingInterface::ERROR);
        PyDict_SetItemString((PyObject*) PyTiledLoggingInterface_Type.tp_dict, "ERROR", tmp_value);
        Py_DECREF(tmp_value);
    }
    return m;
}
/* --- module functions --- */


PyObject *
_wrap_tiled_isTileLayerAt(PyObject * PYBINDGEN_UNUSED(dummy), PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    bool retval;
    PyTiledMap *map;
    Tiled::Map *map_ptr;
    int idx;
    const char *keywords[] = {"map", "idx", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!i", (char **) keywords, &PyTiledMap_Type, &map, &idx)) {
        return NULL;
    }
    map_ptr = (map ? map->obj : NULL);
    retval = isTileLayerAt(map_ptr, idx);
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}
PyObject * _wrap_tiled_isTileLayerAt(PyObject * PYBINDGEN_UNUSED(dummy), PyObject *args, PyObject *kwargs);


PyObject *
_wrap_tiled_loadTilesetFromFile(PyObject * PYBINDGEN_UNUSED(dummy), PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    bool retval;
    PyTiledTileset *ts;
    Tiled::Tileset *ts_ptr;
    const char *file;
    Py_ssize_t file_len;
    const char *keywords[] = {"ts", "file", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!s#", (char **) keywords, &PyTiledTileset_Type, &ts, &file, &file_len)) {
        return NULL;
    }
    ts_ptr = (ts ? ts->obj : NULL);
    retval = loadTilesetFromFile(ts_ptr, QString::fromUtf8(file));
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}
PyObject * _wrap_tiled_loadTilesetFromFile(PyObject * PYBINDGEN_UNUSED(dummy), PyObject *args, PyObject *kwargs);


PyObject *
_wrap_tiled_objectGroupAt(PyObject * PYBINDGEN_UNUSED(dummy), PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    Tiled::ObjectGroup *retval;
    PyTiledMap *map;
    Tiled::Map *map_ptr;
    int idx;
    const char *keywords[] = {"map", "idx", NULL};
    PyTiledObjectGroup *py_ObjectGroup;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!i", (char **) keywords, &PyTiledMap_Type, &map, &idx)) {
        return NULL;
    }
    map_ptr = (map ? map->obj : NULL);
    retval = objectGroupAt(map_ptr, idx);
    if (!(retval)) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    py_ObjectGroup = PyObject_New(PyTiledObjectGroup, &PyTiledObjectGroup_Type);
    py_ObjectGroup->obj = retval;
    py_ObjectGroup->flags = PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED;
    py_retval = Py_BuildValue((char *) "N", py_ObjectGroup);
    return py_retval;
}
PyObject * _wrap_tiled_objectGroupAt(PyObject * PYBINDGEN_UNUSED(dummy), PyObject *args, PyObject *kwargs);


PyObject *
_wrap_tiled_isObjectGroupAt(PyObject * PYBINDGEN_UNUSED(dummy), PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    bool retval;
    PyTiledMap *map;
    Tiled::Map *map_ptr;
    int idx;
    const char *keywords[] = {"map", "idx", NULL};

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!i", (char **) keywords, &PyTiledMap_Type, &map, &idx)) {
        return NULL;
    }
    map_ptr = (map ? map->obj : NULL);
    retval = isObjectGroupAt(map_ptr, idx);
    py_retval = Py_BuildValue((char *) "N", PyBool_FromLong(retval));
    return py_retval;
}
PyObject * _wrap_tiled_isObjectGroupAt(PyObject * PYBINDGEN_UNUSED(dummy), PyObject *args, PyObject *kwargs);


PyObject *
_wrap_tiled_tileLayerAt(PyObject * PYBINDGEN_UNUSED(dummy), PyObject *args, PyObject *kwargs)
{
    PyObject *py_retval;
    Tiled::TileLayer *retval;
    PyTiledMap *map;
    Tiled::Map *map_ptr;
    int idx;
    const char *keywords[] = {"map", "idx", NULL};
    PyTiledTileLayer *py_TileLayer;

    if (!PyArg_ParseTupleAndKeywords(args, kwargs, (char *) "O!i", (char **) keywords, &PyTiledMap_Type, &map, &idx)) {
        return NULL;
    }
    map_ptr = (map ? map->obj : NULL);
    retval = tileLayerAt(map_ptr, idx);
    if (!(retval)) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    py_TileLayer = PyObject_New(PyTiledTileLayer, &PyTiledTileLayer_Type);
    py_TileLayer->obj = retval;
    py_TileLayer->flags = PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED;
    py_retval = Py_BuildValue((char *) "N", py_TileLayer);
    return py_retval;
}
PyObject * _wrap_tiled_tileLayerAt(PyObject * PYBINDGEN_UNUSED(dummy), PyObject *args, PyObject *kwargs);

static PyMethodDef tiled_functions[] = {
    {(char *) "isTileLayerAt", (PyCFunction) _wrap_tiled_isTileLayerAt, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "loadTilesetFromFile", (PyCFunction) _wrap_tiled_loadTilesetFromFile, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "objectGroupAt", (PyCFunction) _wrap_tiled_objectGroupAt, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "isObjectGroupAt", (PyCFunction) _wrap_tiled_isObjectGroupAt, METH_KEYWORDS|METH_VARARGS, NULL },
    {(char *) "tileLayerAt", (PyCFunction) _wrap_tiled_tileLayerAt, METH_KEYWORDS|METH_VARARGS, NULL },
    {NULL, NULL, 0, NULL}
};
/* --- classes --- */



static int
_wrap_PyPythonPythonScript__tp_init(void)
{
    PyErr_SetString(PyExc_TypeError, "class 'PythonScript' cannot be constructed ()");
    return -1;
}

static PyMethodDef PyPythonPythonScript_methods[] = {
    {NULL, NULL, 0, NULL}
};

static void
PyPythonPythonScript__tp_clear(PyPythonPythonScript *self)
{
    Py_CLEAR(self->inst_dict);
        Python::PythonScript *tmp = self->obj;
    self->obj = NULL;
    if (!(self->flags&PYBINDGEN_WRAPPER_FLAG_OBJECT_NOT_OWNED)) {
        delete tmp;
    }
}


static int
PyPythonPythonScript__tp_traverse(PyPythonPythonScript *self, visitproc visit, void *arg)
{
    Py_VISIT(self->inst_dict);

    return 0;
}


static void
_wrap_PyPythonPythonScript__tp_dealloc(PyPythonPythonScript *self)
{
    PyPythonPythonScript__tp_clear(self);
    Py_TYPE(self)->tp_free((PyObject*)self);
}

static PyObject*
_wrap_PyPythonPythonScript__tp_richcompare (PyPythonPythonScript *PYBINDGEN_UNUSED(self), PyPythonPythonScript *other, int opid)
{

    if (!PyObject_IsInstance((PyObject*) other, (PyObject*) &PyPythonPythonScript_Type)) {
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    }
    switch (opid)
    {
    case Py_LT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_LE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_EQ:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_NE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GE:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    case Py_GT:
        Py_INCREF(Py_NotImplemented);
        return Py_NotImplemented;
    } /* closes switch (opid) */
    Py_INCREF(Py_NotImplemented);
    return Py_NotImplemented;
}

PyTypeObject PyPythonPythonScript_Type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    (char *) "tiled.PythonScript",            /* tp_name */
    sizeof(PyPythonPythonScript),                  /* tp_basicsize */
    0,                                 /* tp_itemsize */
    /* methods */
    (destructor)_wrap_PyPythonPythonScript__tp_dealloc,        /* tp_dealloc */
    (printfunc)0,                      /* tp_print */
    (getattrfunc)NULL,       /* tp_getattr */
    (setattrfunc)NULL,       /* tp_setattr */
    (cmpfunc)NULL,           /* tp_compare */
    (reprfunc)NULL,             /* tp_repr */
    (PyNumberMethods*)NULL,     /* tp_as_number */
    (PySequenceMethods*)NULL, /* tp_as_sequence */
    (PyMappingMethods*)NULL,   /* tp_as_mapping */
    (hashfunc)NULL,             /* tp_hash */
    (ternaryfunc)NULL,          /* tp_call */
    (reprfunc)NULL,              /* tp_str */
    (getattrofunc)NULL,     /* tp_getattro */
    (setattrofunc)NULL,     /* tp_setattro */
    (PyBufferProcs*)NULL,  /* tp_as_buffer */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC,                      /* tp_flags */
    NULL,                        /* Documentation string */
    (traverseproc)PyPythonPythonScript__tp_traverse,     /* tp_traverse */
    (inquiry)PyPythonPythonScript__tp_clear,             /* tp_clear */
    (richcmpfunc)_wrap_PyPythonPythonScript__tp_richcompare,   /* tp_richcompare */
    0,             /* tp_weaklistoffset */
    (getiterfunc)NULL,          /* tp_iter */
    (iternextfunc)NULL,     /* tp_iternext */
    (struct PyMethodDef*)PyPythonPythonScript_methods, /* tp_methods */
    (struct PyMemberDef*)0,              /* tp_members */
    0,                     /* tp_getset */
    NULL,                              /* tp_base */
    NULL,                              /* tp_dict */
    (descrgetfunc)NULL,    /* tp_descr_get */
    (descrsetfunc)NULL,    /* tp_descr_set */
    offsetof(PyPythonPythonScript, inst_dict),                 /* tp_dictoffset */
    (initproc)_wrap_PyPythonPythonScript__tp_init,             /* tp_init */
    (allocfunc)PyType_GenericAlloc,           /* tp_alloc */
    (newfunc)PyType_GenericNew,               /* tp_new */
    (freefunc)0,             /* tp_free */
    (inquiry)NULL,             /* tp_is_gc */
    NULL,                              /* tp_bases */
    NULL,                              /* tp_mro */
    NULL,                              /* tp_cache */
    NULL,                              /* tp_subclasses */
    NULL,                              /* tp_weaklist */
    (destructor) NULL                  /* tp_del */
};


#if PY_VERSION_HEX >= 0x03000000
static struct PyModuleDef tiled_moduledef = {
    PyModuleDef_HEAD_INIT,
    "tiled",
    NULL,
    -1,
    tiled_functions,
};
#endif


#if PY_VERSION_HEX >= 0x03000000
    #define MOD_ERROR NULL
    #define MOD_INIT(name) PyObject* PyInit_##name(void)
    #define MOD_RETURN(val) val
#else
    #define MOD_ERROR
    #define MOD_INIT(name) void init##name(void)
    #define MOD_RETURN(val)
#endif
#if defined(__cplusplus)
extern "C"
#endif
#if defined(__GNUC__) && __GNUC__ >= 4
__attribute__ ((visibility("default")))
#endif


MOD_INIT(tiled)
{
    PyObject *m;
    PyObject *submodule;
    #if PY_VERSION_HEX >= 0x03000000
    m = PyModule_Create(&tiled_moduledef);
    #else
    m = Py_InitModule3((char *) "tiled", tiled_functions, NULL);
    #endif
    if (m == NULL) {
        return MOD_ERROR;
    }
    /* Register the 'Python::PythonScript' class */
    if (PyType_Ready(&PyPythonPythonScript_Type)) {
        return MOD_ERROR;
    }
    PyModule_AddObject(m, (char *) "Plugin", (PyObject *) &PyPythonPythonScript_Type);
    submodule = inittiled_qt();
    if (submodule == NULL) {
        return MOD_ERROR;
    }
    Py_INCREF(submodule);
    PyModule_AddObject(m, (char *) "qt", submodule);
    submodule = inittiled_Tiled();
    if (submodule == NULL) {
        return MOD_ERROR;
    }
    Py_INCREF(submodule);
    PyModule_AddObject(m, (char *) "Tiled", submodule);
    return MOD_RETURN(m);
}

PyObject* _wrap_convert_c2py__Tiled__LoggingInterface(Tiled::LoggingInterface *cvalue)
{
        PyObject *py_retval;
        PyTiledLoggingInterface *py_LoggingInterface;
        
        py_LoggingInterface = PyObject_New(PyTiledLoggingInterface, &PyTiledLoggingInterface_Type);
        py_LoggingInterface->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
        py_LoggingInterface->obj = cvalue;
        py_retval = Py_BuildValue((char *) "N", py_LoggingInterface);
        return py_retval;
}


int _wrap_convert_py2c__Tiled__Map___star__(PyObject *value, Tiled::Map * *address)
{
    PyObject *py_retval;
    PyTiledMap *tmp_Map;
    
    py_retval = Py_BuildValue((char *) "(O)", value);
    if (!PyArg_ParseTuple(py_retval, (char *) "O!", &PyTiledMap_Type, &tmp_Map)) {
        Py_DECREF(py_retval);
        return 0;
    }
    *address = new Tiled::Map(*tmp_Map->obj);
    Py_DECREF(py_retval);
    return 1;
}


PyObject* _wrap_convert_c2py__Tiled__Map_const(Tiled::Map const *cvalue)
{
    PyObject *py_retval;
    PyTiledMap *py_Map;
    
    py_Map = PyObject_New(PyTiledMap, &PyTiledMap_Type);
    py_Map->flags = PYBINDGEN_WRAPPER_FLAG_NONE;
    py_Map->obj = new Tiled::Map(*cvalue);
    py_retval = Py_BuildValue((char *) "N", py_Map);
    return py_retval;
}


