#ifndef HASH_H__
#define HASH_H__

#include <sys/types.h>

typedef struct hashtab hashtab;

/* return the position of the given element */
typedef size_t (*jmphash_f) (void *, size_t);

/* compare two hash keys, return 0 if they are same */
typedef int (*jmphash_cmp_f) (void *, void *);

/* iterator function (key, value, data) */
typedef void (*jmphash_iter_f) (void *, void *, void *);

/** Create a new hash table */
hashtab* jmphash_new (size_t        size,
		      jmphash_f     h,
		      jmphash_cmp_f cmp);

/** Free the memory used by a given hash table.
 *  Note that this does not free the elements. 
 */
void jmphash_free (hashtab* htab);

/** Add an entry to the hash table */
void jmphash_insert (hashtab* htab, void* key, void* el);

/** Get the entry for a given key. 
 *  Will return NULL if no entry is found.
 */
void* jmphash_search (hashtab* htab, void* key);

/** Get the number of entries in the hash table */
size_t jmphash_size (hashtab* htab);

/** Call the given function on all elements in the hash table */
void jmphash_for_each (hashtab* htab, jmphash_iter_f proc, void* data);

#endif /* HASH_H__ */

