#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <jvmti.h>
#include <tijmp.h>
#include <class_file_load.h>
#include <java_crw_demo.h>

extern jvmtiEnv* jvmti;

static jint class_count = 0;

/* Callback from java_crw_demo() that gives us mnum mappings */
static void mnum_callbacks(unsigned cnum, const char **names, 
			   const char**sigs, int mcount) {
    /* ignore for now. */
}

void JNICALL class_file_load (jvmtiEnv *jvmti_env,
			      JNIEnv* jni_env,
			      jclass class_being_redefined,
			      jobject loader,
			      const char* name,
			      jobject protection_domain,
			      jint class_data_len,
			      const unsigned char* class_data,
			      jint* new_class_data_len,
			      unsigned char** new_class_data) {
    char* classname = NULL;
    jint  cnum;
    jint  system_class;
    unsigned char* new_image = NULL;
    long  new_length;

    if (tijmp_after_vm_death ())
	return;

    tijmp_bci_lock ();
    if (name == NULL)
	classname = java_crw_demo_classname (class_data, class_data_len, NULL);
    else
	classname = strdup (name);
    if (classname == NULL)
	goto cleanup;
    
    *new_class_data_len = 0;
    *new_class_data     = NULL;

    /* ignore profiler classes */
    if (strncmp (classname, "tijmp/", 6) == 0) 
	goto cleanup;
    if (strncmp (classname, "java/util/concurrent/atomic", 27) == 0) 
	goto cleanup;
    cnum = class_count++;
    system_class = !tijmp_after_vm_init ();

    new_length = 0;

    java_crw_demo (cnum, classname, class_data, class_data_len, system_class,
		   "tijmp/TIJMPMethodTracer", "Ltijmp.TIJMPMethodTracer;",
		   "methodEntry", "(II)V", "methodExit", "(II)V",
		   NULL, NULL, NULL, NULL,
		   &new_image, &new_length, NULL,
		   &mnum_callbacks);

    if (new_length > 0) {
	jvmtiError err;
	unsigned char *jvmti_space;	
	err = (*jvmti)->Allocate (jvmti, new_length, (unsigned char **)&jvmti_space);
	if (err != JVMTI_ERROR_NONE) {
	    fprintf (stderr, "failed to allocate memory\n");
	    goto cleanup;
	}
	memcpy (jvmti_space, new_image, new_length);
	*new_class_data_len = new_length;
	*new_class_data     = jvmti_space;
    }

cleanup:
    if (new_image != NULL)
	free (new_image); 
    if (classname != NULL)
	free (classname);
    tijmp_bci_unlock ();    
}
