package tijmp.actions;

import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import tijmp.io.Closer;
import tijmp.ui.ThreadInfoPanel;

/** An action that dumps all thread information to a file
 */
public class ThreadDumper extends AbstractAction {
    private final ThreadInfoPanel tip;
    
    public ThreadDumper (ThreadInfoPanel tip) {
	super ("Write Thread info to file");
	this.tip = tip;
    }

    public void actionPerformed (ActionEvent e){
	JFileChooser chooser = new JFileChooser ();
	int returnVal = chooser.showSaveDialog (tip);
	if (returnVal != JFileChooser.APPROVE_OPTION) 
	    return;
	File f = chooser.getSelectedFile ();
	
	BufferedWriter bw = null;
	FileOutputStream fos = null;
	try {
	    fos = new FileOutputStream (f);
	    bw = new BufferedWriter (new OutputStreamWriter (fos, "UTF-8"));
	    tip.writeFullState (bw);
	} catch (IOException ex) {
	    ex.printStackTrace ();
	} finally {
	    Closer.close (bw);
	    Closer.close (fos);
	}
    }
}
