;*
;* PedroM - Operating System for Ti-89/Ti-92+/V200.
;* Copyright (C) 2003 PpHd
;*
;* This program is free software ; you can redistribute it and/or modify it under the
;* terms of the GNU General Public License as published by the Free Software Foundation;
;* either version 2 of the License, or (at your option) any later version. 
;* 
;* This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
;* without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
;* See the GNU General Public License for more details. 
;* 
;* You should have received a copy of the GNU General Public License along with this program;
;* if not, write to the 
;* Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 

;******************************************************************
;***                                                            ***
;***            	Shell Functions (2)			***
;***                                                            ***
;******************************************************************

; Find a file in the path
; In:
;	a4 -> File Name (ANSI) (Shell string)
; Out:
;	a0.l -> SYM_ENTRY
FindSymInPath:
	; Search in the current or given folder.
	move.l	a4,a0
\cvt:		tst.b	(a0)+
		bne.s	\cvt
	clr.w	-(a7)			; Current Folder
	pea	-1(a0)			; Push filename
	bsr.s	LocalSymFindPtr		; Search for it
	move.l	a0,d0			; Success finding it ?
	bne.s	\Find
	bsr.s	PathInit		
\PathLoop	
		bsr.s	PathNext
		move.l	a0,(a7)			; Save Path Ptr and check if NULL
		beq.s	\Find
		move.w	#FOLDER_LIST_HANDLE,a0	; Folder List
		bsr.s	LocalFindSymEntry	; Find Folder
		move.l	a0,d0
		beq.s	\Next
			move.w	SYM_ENTRY.hVal(a0),a0
			move.l	a4,a1		
			bsr.s	LocalFindSymEntry	; Search file in this folder
			move.l	a0,d0		; Success ?
			bne.s	\Find
\Next		move.l	(a7),a0			; Reload Path Ptr
		bra.s	\PathLoop
\Find:	addq.l	#6,a7
	rts
LocalFindSymEntry
	jmp	FindSymEntry
LocalSymFindPtr
	jmp	SymFindPtr

PathInit:
	; Search path variable
	pea	Path_sym			; Push filename
	bsr.s	LocalSymFindPtr			; Search Path variable.
	addq.l	#4,a7
	move.l	a0,d0
	beq.s	PathEnd
	move.w	SYM_ENTRY.hVal(a0),a0		; Read Handle
	jsr	HToESI_reg			; Get Var Tag Ptr
	cmpi.b	#$D9,(a0)			; Check if var is a list.
	bne.s	PathEnd
	; Search in the path.
	subq.l	#1,a0				; Skip List Tag
	rts
PathEnd	suba.l	a0,a0
	rts
PathNext:
	cmpi.b	#$2D,(a0)			; Check String Tag (if NULL, (a0) != $2D!)
	bne.s	PathEnd
	jsr	next_expression_index_reg	; Next Expression
	lea	2(a0),a1			; Folder name
	rts
	
; Completion
; It is really written in 'I write it until it works' style.
; Not good, but nevertheless it works well...
; The chars are put inside the KeyBuffer, so there isn't any output.
; In:
;	a0 -> Start of string
;	a1 -> End of string
Completion:
	move.b	(a1),-(a7)				; Save Last Char (It is in RAM)
	movem.l	d0-d7/a0-a6,-(a7)
	; Create a PopUp
	movem.l	a0/a1,-(a7)
	clr.w	-(a7)					; Height = 0
	clr.l	-(a7)					; No title
	bsr	PopupNew				; New PopUp
	addq.l	#6,a7
	move.w	d0,a5					; a5 = HANDLE of Popup
	movem.l	(a7)+,a0/a1
	; Set vars
	suba.l	a6,a6					; Found Entry Ptr = NULL
	clr.b	(a1)					; Make it null string
	clr.w	d4					; Length of the string
	clr.w	d6					; Number of successful entries
	; Search back ' ' or start of string
\loop_char	cmp.l	a0,a1				; Check if the start of the string
		ble.s	\Done
		move.b	-(a1),d0			; Read next char
		cmpi.b	#' ',d0				; If ' ', then we have a word
		beq.s	\Done1
		cmpi.b	#SCRIPT_VARIABLE_CHAR,d0	; If '$', then we have a word.		
		beq.s	\Done1
		cmpi.b	#'{',d0				; If '{', then we have a word.		
		beq.s	\Done1		
		cmpi.b	#'\',d0				; If '\', then it is a folder\file completion
		beq	\Folder
		addq.w	#1,d4				; One more char
		bra.s	\loop_char			; Next char
\Done1:	addq.l	#1,a1					; *a1 == ' ', so skip again ' '
\Done	; Search for a command which starts with a1 string
	tst.w	d4					; Is a char ?
	beq	\EndCompletion				; No char => No completion
	move.l	a1,a4					; Save the file in GReg4
	; Search in the folder Table
	move.w	#FOLDER_LIST_HANDLE,a0
	bsr	CompletionFolderSearch
	moveq	#'\',d7					; Final char if we found inside the Folder Table
	; Search in the internal commands
	lea	CommandTable,a2
	move.l	a2,a3
\InternalSearchLoop:
		move.w	(a2),d0				; Read offset
		beq.s	\InternalSearchLoopEnd		; Check if zero
		lea	0(a3,d0.w),a0			; String Command Name
		bsr	CompletionCmp			; Check this command
		addq.l	#INTERNAL_COMMAND_SIZE,a2	; Next entry
		bra.s	\InternalSearchLoop
\InternalSearchLoopEnd
	; Search in the files in the current folder
	move.w	CUR_FOLDER_HD,a0
	bsr	CompletionFolderSearch
	; Search in the files of the PATH
	bsr	PathInit
\FolderLoop:	bsr	PathNext
		move.l	a0,d0
		beq.s	\resolve
		move.l	a0,a2			; Save Path Variable
		move.w	#FOLDER_LIST_HANDLE,a0
		bsr	LocalFindSymEntry
		move.l	a0,d0
		beq.s	\NextFolder		; Folder not found, next folder
			move.w	SYM_ENTRY.hVal(a0),a0
			bsr	CompletionFolderSearch
\NextFolder	move.l	a2,a0
		bra.s	\FolderLoop

\Folder	; Find inside the given folder
	tst.w	d4					; Is a char ?
	beq	\EndCompletion				; No char => No completion
	; a1 -> '\'
	lea	1(a1),a4				; File Ptr
	pea	(a1)					; Save ptr
	clr.b	(a1)					; Replace '\' by 0 (It is in RAM)
\Floop		cmp.l	a0,a1				; Search for the folder name
		ble.s	\FDone
		move.b	-(a1),d0			; Read char
		cmpi.b	#SCRIPT_VARIABLE_CHAR,d0	; If '$', then we have a word.		
		beq.s	\FDone1
		cmpi.b	#'{',d0				; If '{', then we have a word.		
		beq.s	\FDone1		
		cmpi.b	#' ',d0				; Cmp
		bne.s	\Floop				; Continue
\FDone1	addq.l	#1,a1
\FDone:		
	move.w	#FOLDER_LIST_HANDLE,a0			; Find folder (a1)
	bsr	LocalFindSymEntry			; Find entry ?
	move.l	(a7)+,a1				; Reload ptr
	move.b	#'\',(a1)				; Restore string
	move.l	a0,d0					; Check success
	beq	\EndCompletion				; No => quit
	move.w	SYM_ENTRY.hVal(a0),a0			; Folder Handle
	bsr	CompletionFolderSearch			; Complete

\resolve
	; Now we have a list of all the entries which may success
	; d6 = Number of Found Entries
	; d5 = Max Len of char to put
	; d4 = Len of entry to complete
	; a6 -> A sucessfull entry
	subq.w	#1,d6					; = Number of success find
	blt.s	\EndCompletion
		; Now we have at least one entry
		lea	0(a6,d4.w),a1			; Ptr to entry (Remaining char).
		move.w	d5,d0				; d5 = Number of char to put
		sub.w	d4,d0				; - Number of chars already put
		subq.w	#1,d0				; -1 for dbf
		blt.s	\DisplayMenu			; If no char can be put, display the menu
\PutLoop		clr.w	d4
			move.b	(a1)+,d4
			bsr	AddKeyToFIFOKeyBuffer
			dbf	d0,\PutLoop
		move.w	d7,d4				; Add final ' ' or '\' character
		beq.s	\EndCompletion
			bsr	AddKeyToFIFOKeyBuffer
\EndCompletion
	move.w	a5,-(a7)
	jsr	HeapFree				; Free Menu (HeapFree(H_NULL) doesn't crash contrary to AMS).
	addq.l	#2,a7
	movem.l	(a7)+,d0-d7/a0-a6
	move.b	(a7)+,(a1)				; Restore Last Char (It is in RAM)
	rts

\DisplayMenu:
	move.w	a5,d0					; Check if PopUp is created
	beq.s	\EndCompletion				; No so quit.
	clr.w	-(a7)					; Start ID
	moveq	#-1,d0		
	move.l	d0,-(a7)				; X & Y
	move.w	a5,-(a7)				; Handle
	bsr	PopupDo					; Display the menu
	addq.l	#8,a7
	tst.w	d0					; Memory Error or ESC ?
	beq.s	\EndCompletion				; => End completion
	move.w	d0,-(a7)
	move.w	a5,-(a7)
	bsr	PopupText				; Get the associated text
	addq.l	#4,a7
	move.l	a0,d0
	beq.s	\EndCompletion				; Error ? => Quit
	move.l	a0,a6
	jsr	strlen_reg				; d5.w = Length of the text
	move.w	d0,d5					; I hope it is > d4 ...
	moveq	#' ',d7					; Completion char (Error if folder.)
	lea	0(a6,d4.w),a1				; Ptr to entry (Remaining char).
	sub.w	d4,d0					; - Number of chars already put
	subq.w	#1,d0					; -1 for dbf
	blt.s	\EndCompletion
	bra.s	\PutLoop
	
; Search in the given folder 
;	a0= FOLDER HANDLE
CompletionFolderSearch:
	trap	#3
	addq.w	#2,a0				; Skip Max
	move.w	(a0)+,d3			; Number of folders (at least one !)
	subq.w	#1,d3
	blt.s	\EndFolder
\Loop		bsr.s	CompletionCmp		; Compare and add to buffer
		lea	SYM_ENTRY.sizeof(a0),a0	; Next entry
		dbf	d3,\Loop	
\EndFolder
	rts
			
CompletionCmp:
	pea	(a0)
	move.l	a4,a1				; String Source
	move.w	d4,d2				; Length
	subq.w	#1,d2				; -1 for dbf
\IntCmp		cmpm.b	(a1)+,(a0)+		; Compare 
		dbne	d2,\IntCmp		; and decrement
	bne.s	\Ret
		; Add this string to the list of the possibility
		move.l	a6,d2
		beq.s	\FirstEntry
			; Find the max length of the 2 commands so that we put as mush char as possible
			move.l	a6,a1		; Old string
			move.l	(a7),a0		; New string
			moveq	#-1,d0		; Length
			\StrCmp:	addq.w	#1,d0
					tst.b	(a1)
					beq.s	\StrDone
					cmpm.b	(a1)+,(a0)+		; Compare 
					beq.s	\StrCmp		; 
			\StrDone:
				clr.w	d7	; No final char !
				cmp.w	d0,d5		; Get minimum between d5 and d0
				ble.s	\NewEntry
					move.w	d0,d5
					bra.s	\NewEntry
\FirstEntry	jsr	strlen
		move.w	d0,d5			; Length of command
		move.l	(a7),a6			; Save found command
		moveq	#' ',d7			; d7 = Final Char
\NewEntry	addq.w	#1,d6
		; Add this entry in the Popup
		move.w	a5,d0			; Check if PopUp is created
		beq.s	\Ret			; no so quit
			clr.w	-(a7)		; No parent
			move.l	2(a7),-(a7)	; Push Text Ptr
			clr.w	-(a7)		; Auto-Id
			move.w	a5,-(a7)	; Push Handle
			bsr	PopupAddText	; Add Text in PopUp
			lea	10(a7),a7	; FIXME: Check success ?
\Ret	move.l	(a7)+,a0
	rts
	
; Replace the vars in the command line.
; It replaces $x, or ${x} or ${x[1]} by its value (String int).
; In:
;	a4 -> Buffer of Size SHELL_MAX_LINE
ReplaceVars:
	movem.l	d0-d7/a0-a6,-(a7)
	; Alloc Another Buffer on the stack
	moveq	#SHELL_MAX_LINE,d3
	suba.w	d3,a7
	move.l	a7,a3
	pea	(a4)
	; Copy translated version of OrgBuffer To StackBuffer
\CopyLoop
		move.b	(a4)+,d2			; Read Char
		beq.s	\Return
		cmpi.b	#SCRIPT_VARIABLE_CHAR,d2
		beq.s	\TranslateVar
		bsr.s	\AddChar
		bra.s	\CopyLoop

\Return		clr.b	(a3)
		; Copy StackBuffer to OrgBuffer
		moveq	#SHELL_MAX_LINE,d0
		move.l	(a7)+,a0			; Org Buffer
		move.l	a7,a1				; Temp Buffer
		jsr	memcpy_reg
		; Pop Frame / Restore registers / Return
		lea	SHELL_MAX_LINE(a7),a7
		movem.l	(a7)+,d0-d7/a0-a6
		rts

\AddChar	subq.w	#1,d3
		blt.s	\NoAdd
			move.b	d2,(a3)+
\NoAdd		rts

	; Find $. Translate var
\TranslateVar
	moveq	#0,d7
	move.l	a4,a2				; File Name
	cmpi.b	#'{',(a4)			; Check if "{"
	bne.s	\SingleVar
		; Form= ${toto}
		addq.l	#1,a2
		; Find '}'
\LoopSVar		move.b	(a4)+,d2
			beq.s	\Return		; if end of string, return
			cmpi.b	#'}',d2
			bne.s	\LoopSVar
		bra.s	\EvalVariable
\EndOfString
	moveq	#0,d7
	subq.l	#1,a4
	bra.s	\EvalVariable2
\SingleVar	; Form= $x
		moveq	#' ',d7		; Final character	
		; Find Space or End of string
\LoopVar	move.b	(a4)+,d2
		beq.s	\EndOfString
		cmpi.b	#' ',d2
		bne.s	\LoopVar
\EvalVariable
	clr.b	-1(a4)			; Clear it
\EvalVariable2
	; Eval Variable
	movem.l	d4-d7/a4-a6,-(a7)
	lea	-60(a7),a7		; Push Error Frame
	pea	(a7)
	jsr	ER_catch
	tst.w	d0
	bne.s	\Error
		jsr	EStackReInit		; ReInit EStack
		pea	(a2)
		bsr	push_parse_text		; Push parse text
		move.l	top_estack,(a7)
		bsr	NG_approxESI		; Eval It
		addq.l	#4,a7
		move.l	top_estack,a5		; Expression
		move.w	d3,d4			; Remaining chars
		move.l	a3,a4			; Output buffer
		moveq	#1,d5			; Do not add '"' for string
		bsr	Display1DESI		; Put in buffer
		move.w	d4,d3			; Update remaining chars
		move.l	a4,a3			; Update output buffer
		jsr	ER_success		; Ok!
\Error	lea	64(a7),a7		; Pop Error Frame
	movem.l	(a7)+,d4-d7/a4-a6
	move.b	d7,d2
	beq	\CopyLoop
		bsr	\AddChar	; Add final space.
		bra	\CopyLoop	;


; Shell redirection. Support of stdin/stdout/stderr
; WARNING: It is not a function! It is the natural sequel of TranslateArg!
; Only TranslateArg can call this!
; In:
;	d4.w = Num of arg*4
;	a3 -> argv
; out:
;	d4.w = New num of arg
CheckRedirection:
\RedirectLoop
		move.l	-4(a3,d4.w),a0		; Get last arg
		move.b	(a0)+,d0		; Check first char of last arg
		lea	stdin,a2		; default: stdin
		lea	ReadModeStr(pc),a1	; defautl: read
		cmpi.b	#'<',d0			; Check redirection of stdin
		beq.s	\Redirect		; Yes=> redirect it!
		addq.l	#WriteModeStr-ReadModeStr,a1	; default: write
		lea	stdout,a2		; default: stdout
		cmpi.b	#'>',d0			; Check redirection of stdout
		bne.s	\CheckStderr		; Yes=>redirect
		cmpi.b	#'>',(a0)		; Check '>>'
		bne.s	\Redirect
			addq.l	#1,a0		; Skip second char '>'
			addq.l	#AppendModeStr-WriteModeStr,a1	; mode: append
			bra.s	\Redirect
\CheckStderr
		lea	stderr,a2		; stderr	
		cmpi.b	#'2',d0			; stderr is 2>. First check 2
		bne.s	\EndRedirect		; No, so end of redirection
		move.b	(a0)+,d0		; Read next char
		cmpi.b	#'>',d0			; Check second char
		bne.s	\EndRedirect		; no
\Redirect		tst.b	(a0)		; Redirection: Check if there is at least a char
			beq.s	\EndRedirect
			bsr	freopen		; Reopen stream to a file
			move.l	a0,d0
			beq.s	\ResetRedirect	; Error: Reset to default
			subq.w	#4,d4
			bhi.s	\RedirectLoop
\ResetRedirect:
	bsr	InitTerminal
\EndRedirect
	rts
ReadModeStr	dc.b	'r',0
WriteModeStr	dc.b	'w',0
AppendModeStr	dc.b	'a',0
	

; Execute a command (aka system).
; It prepares the call to ShellExecuteSingleCommand (Reinit terminal, restart APD, replace vars).
; It also decomposes in Single command, aka it translates pipe connection.
; In:
;	a4 -> Shell String
ShellExecuteCommand:
	bsr	InitTerminal			; Set stdin/stdout/stderr to the terminal
	bsr	ShellRestartAPD			; Restart Auto Power Down
	bsr	ReplaceVars			; Replace the Vars ($x and so on)
	; Scan string for | or "
\LoopPipe	
	move.l	a4,a0
\SearchPipe:	
		move.b	(a0)+,d0
		beq.s	\EndOfString
		cmpi.b	#'"',d0
		bne.s	\CheckPipe
\SkipString		move.b	(a0)+,d0
			beq.s	\EndOfString
			cmpi.b	#'"',d0
			bne.s	\SkipString
\CheckPipe	cmpi.b	#'|',d0
		bne.s	\SearchPipe
	pea	(a0)		; Push String to keep ptr

	clr.b	-(a0)		; 0 string
	
	; Redirect stdin
	btst.b	#0,stdout	; If stdout=Terminal
	bne.s	\First
		clr.w	stdout		; Fast fclose(stdout) since we don't want to lose the temp file.
		lea	stdin+2,a0	
		move.w	stdout+2,(a0)	; Copy handle
		move.w	#$0201,-(a0)	; Read Flag | TMP file
		bsr	rewind		; rewind (stdin)
\First	; Redirect stdout
	suba.l	a0,a0			; Name = NULL (Create a temp file)
	lea	WriteModeStr(pc),a1
	lea	stdout,a2
	bsr	freopen			; freopen(NULL,"w",stdout) = tmpfile;
	
	; Execute simple command
	bsr.s	\SingleCommand
	move.l	(a7)+,a4		; Pop next command
	
	; Check stdin.flags.Terminal
	btst.b	#0,stdin
	bne.s	\StdinTerminal
		lea	stdin,a0	; if stdin!=terminal,
		bsr	fclose		; fclose(stdin)
\StdinTerminal	
	bra	\LoopPipe

\EndOfString
	; Check if redirection is needed
	btst.b	#0,stdout		; If stdout=Terminal
	bne.s	\SingleCommand		; No need to redirect stdin/stdout

	; Redirect stdin
	clr.w	stdout			; Fast fclose(stdout) since we don't want to lose the temp file.
	lea	stdin+2,a0	
	move.w	stdout+2,(a0)		; Copy handle
	move.w	#$0201,-(a0)		; Read Flag | TMP file
	bsr	rewind			; rewind (stdin)
	; stdout = terminal
	move.w	#$0102,stdout
	; Execute simple command
	bsr.s	\SingleCommand
	; Close stdin
	lea	stdin,a0
	bra	fclose			; fclose(stdin)
\SingleCommand
	jmp	ShellExecuteSimpleCommand	; Execute simple command

; Restart APD timer by reading system\apd.
ShellRestartAPD:
	lea	APD_str,a2
	bsr	getenv			; getenv("apd")
	move.l	a0,d0
	beq.s	\End
	bsr	atoi			; Transform it to a number
	cmpi.w	#10,d0
	blt.s	\End
	cmpi.w	#1000,d0
	bgt.s	\End
	mulu.w	#20,d0
	move.l	d0,-(a7)
	move.w	#2,-(a7)
	jsr	OSFreeTimer		; Free APD timer
	jsr	OSRegisterTimer		; Set new value of APD
	addq.l	#6,a7
\End:	rts
