; Warning:
;	Avant de modifier quelque chose, faites gaffe.
;	C de la haute precision.
;	La moindre difference dans le code peut s'averer fatale !

MAX_HANDLES	EQU	2000		; Nombre d'handles a sauvegarder
MAX_RAMCALL	EQU	$2A		; Nombre de RAMCALLS

kernel::start_kernel_prgm:		; 'exec' function
	move.l	(a7)+,a0		; Load program address
	HW2TSR_PATCH a0,d0
	movem.l	d3-d7/a2-a6,-(a7)
	; Load program
	lea	-4(a0),a5
	; Restore line1111 and a6
	bsr	kernel_install_int
	; Init
	tst.w	(a6)
	bne.s	already_install
		trap	#12			; supervisor mode
		clr.l	RetVal-FirstRun(a6)	; Return Value : Reinit it to NULL
		; Save the handle tab + some unused space so that an overflow of lcd_mem doesn't crash the calc. Yes, yes. Some programs are very buggy
		lea	-30*3-MAX_HANDLES/8(sp),sp	; Push Table
		move.l	RAM_TABLE+$11*4(Pc),a1		; a1 = Heap Table
		move.l	(a1),a1
		move.l	sp,a0				; A0 = Save table
		move.w	a0,(HdTable+2-FirstRun)(a6)	; Save Table
		move.w	#MAX_HANDLES-1,d2	; d2 = number of handles we save the state of
		moveq	#%01111111,d1		; d1 = bit mask
		st.b	d3			; All handles are free
\loop			tst.l	(a1)+		; this handle is allocated ?
			beq.s	\noset
				and.b	d1,d3	;  -> clear corresponding bit within the info-table
\noset			ror.b	#1,d1		; go to next bit
			bcs.s	\nonext		; next bit is within the next byte ?
				move.b	d3,(a0)+
				st.b	d3	; Set next Bytes
\nonext			dbra	d2,\loop	; loop 2000 times
		; Save the vector table & ev_hook
		moveq	#64-1,d0		; number of vectors to save.
		suba.l	a1,a1			; NULL ptr
EV_hook2	move.l	($0).l,-(sp)		; save ev_hook
\loop_autoint:		move.l  (a1)+,-(sp)	; Save old handler
			dbra    d0,\loop_autoint
		move.l	usp,a0			; save user stack
		pea	(a0)
ErrorFrameAdr2	move.l	($5400).w,-(sp)		; save error frame
		move.w	sp,org_stack-FirstRun(a6)	; save Supervisor Stack Ptr
		move.w	#$0000,sr		; Back to user mode.
		; Protection ER_catch
		lea	-60(a7),a7		;60 for ErrorFrame
		pea	(a7)
		ROM_THROW ER_catch		; Catch all standard Errors from Ti-Os
		tst.w	d0
		beq.s	\ok_catch		; Normal exit ?
			bsr	kernel_install_int	; Reinstall Line1111/a6/trap 12
			move.w	d0,(a7)			; Get error message
			ROM_THROW find_error_message	
			move.l	a0,ErrorString-FirstRun(a6) ; Save Error message
			bra.s	_quit
\ok_catch
already_install
	addq.w	#1,(a6)				; One more Kernel program.

	ifd	CheckCalc
		lea	CheckCalc_str(Pc),a0	; Check if the current calc is ok with 
		move.l	a0,ErrorString-FirstRun(a6) ; the program.
ChkCalc		btst.b	#0,KHEADER_flags(a5)	; Check bit
		beq.s	\reloc_error		; If no => Error
	endif
	
	bsr	kernel::relocation		; Relocation of prog -> a5
	tst.w	d0				; In case of an error we don't need to unrealloc it.
	bne.s	\reloc_error
	
	pea	(a5)				; save 'a5' program ref
	moveq	#0,d0
	move.w	KHEADER_main(a5),d0
	beq.s	\no_run
		ifnd	WTI_BP
			jsr	0(a5,d0.l)		; Execution
		endif
		ifd	WTI_BP
			lea	0(a5,d0.l),a0
			SET_WTI_BP a0
			jsr	(a0)
			CLEAR_WTI_BP
		endif
\no_run move.l	(a7)+,a5			; pop 'a5' program ref
		
	bsr	kernel_install_int		; reinstall line1111 and a6 ptr
	bsr	kernel::unrelocation		; Unrelocation du prog -> a5
	clr.l	ErrorString-FirstRun(a6)	; No error

\reloc_error
	subq.w	#1,(a6)
	bne	no_finish
_quit		bsr	kernel_install_int	; Restore the ints
		st.b	(a6)			; Mode : kernel exit
		trap	#12			; Goes to supervisor mode
		move.w	#$2700,sr		; Stop Auto Ints
		move.w	org_stack-FirstRun(a6),sp	; restore stack ptr
ErrorFrameAdr3	move.l	(sp)+,($5400).w		; restore error frame
		move.l	(sp)+,a0
		move.l	a0,usp			; restore user stack ptr
		bsr	reinstall_tios		; Reinstall the ports, the screen and the auto-ints.
		bsr	clean_up		; Clean up of all relocated progs / calls exits points / free memory / delete unused files.
		moveq	#64-1,d0		; number of vectors to restore.
		lea	($40100),a1		; Final vector in Ghost Space
\loop_autoint:		move.l  (sp)+,-(a1)		; restore old handler
			dbra    d0,\loop_autoint
EV_hook4	move.l	(sp)+,($0).l		; restore ev_hook
		move.l	RAM_TABLE+$11*4(Pc),a2	; Restore handle table
		move.l	(a2),a2			; a2 = Heap Table
		move.l	sp,a3			; A3 = save table	
		move.w	#MAX_HANDLES/8-1,d5	; d5 = number of handles
		clr.w	d3			; d3 = handle number = 0
\loop			move.b	(a3)+,d6	; Read Handle Flags
			bne.s	\start_sloop	; Is 8 handles already allocated ?
						; Yes (If d6 = 0), we can skip 8 handles
				addq.w	#8,d3	; Handle Number += 8
				lea	8*4(a2),a2
				bra.s	\next
\start_sloop:		moveq	#8-1,d4		; 8 at a times
\small_loop:			tst.l	(a2)+
				beq.s	\OK
				btst	d4,d6	; Check if Bit is set ? (Handle not allocated before)
				beq.s	\OK	; If bit is clear, then the handle was already allocated
					move.w	d3,d0
					bsr	kernel::Hd2Sym	; Then see if this handle is in VAT (it is a file or a folder)
					move.l	a0,d0		; Test if Null
					bne.s	\OK
						clr.w	-(a7)	; Check if it is a Home History Handle (I don't think a program should do it, but...)
\HomeLoop						addq.w	#1,(a7)	; From index 1 to Max
							ROM_THROW HS_getFIFONode
							tst.w	d0	; No more index
							beq.s	\Free
							cmp.w	d0,d3
							beq.s	\HomeEnd
							ROM_THROW HS_getAns
							cmp.w	d0,d3
							beq.s	\HomeEnd
							ROM_THROW HS_getEntry
							cmp.w	d0,d3
							beq.s	\HomeEnd
							bra.s	\HomeLoop
\Free						move.w	d3,(a7)		; Free this handle (It may be usefull, but it is very probably that it is a memory leak.
						ROM_THROW HeapFree
\HomeEnd					addq.w	#2,a7
\OK:				addq.w	#1,d3		; increase handle number
				dbf	d4,\small_loop	; increase bit number
\next			dbf	d5,\loop
		lea	MAX_HANDLES/8+30*3(sp),sp	; Pop handle tabs + some unused space so that an overflow of lcd_mem doesn't crash the calc
		move.w	#$0000,sr			; User mode / allow auto-ints
		lea	RetVal(Pc),a0			; Get RetVal value
		move.l	(a0),d0				; Check if it is NULL
		beq.s	\noretval
			move.l	40(a7),a0		; No NULL, so check the return address
			cmp.l	#$200000,a0		; is it called from TiOs ?
			bls.s	\noretval		; No, no fix the return addr.
			cmpi.w	#$21EE,(a0)+		; Is-it : movea.w -$40(a6) ? or movea.l a3, ? (AMS 2.0x / AMS 1.0x)
			bne.s	\norom2			; AMS 1.0x
				addq.l	#2,a0		; Skip -$40(a6)
\norom2			movea.w	(a0)+,a1		; Read the ret-val addr.
			move.l	d0,(a1)			; Write its new value.
			move.l	a0,40(a7)		; Fix the return address
\noretval	clr.w	(a6)				; End of kernel
no_finish
	ROM_THROW GKeyFlush			; Clear Keys (It crashes sometimes !)
	ROM_THROW OSClearBreak			; Clear Break
	move.l	ErrorString-FirstRun(a6),-(a7)	; Print Errors in the Help Window
	beq.s	\noh			
		ROM_THROW ST_showHelp		
\noh	move.l	(a7)+,d0			; Return in d0.l the error ptr
	movem.l (a7)+,d3-d7/a2-a6
	rts

	; Restore the auto-int, the trap and the ptr of preos 
kernel_install_int:
	lea	FirstRun(Pc),a6		; Ptr to access data 
	lea	new1111(Pc),a0		; Line1111 (Rom calls)
	move.l	a0,GHOST_SPACE+$2C	; $2C
	lea	newtrap12(Pc),a0	; address of trap 12
	move.l	a0,GHOST_SPACE+$B0	; Supervisor mode
	rts
	
; ReInstall the traps of the TiOs, and the ports.
; and redraw the current application
reinstall_tios:
	ROM_THROW PortRestore	; Restore standard screen
	; Test if program doesn't want to be redrawn
	btst.b	#2,$11(a5)		; In case of a crash kernel, a5 = -$10
	bne.s	reinstall_tios_vars

	; Ask to the current application to redraw the screen (Properly).
	lea	-60(a7),a7		; Space for window struct
	move.l	a7,a0
	move.w	#$0300,-(a7)		; flags : no bold / no border
	pea	FullScr(Pc)		; Push SCR_RECT
	pea	(a0)			; Push Window
	ROM_THROW WinOpen		; Create the window
	ROM_THROW WinActivate		; Print it
	ROM_THROW WinClose		; And close it 
	lea	(4+4+2+60)(a7),a7	; Pop The args

; ReInstall the traps of the TiOs, and the ports.
; and redraw the ST line.
reinstall_tios_stat
	pea	mmemory_end(Pc)
	ROM_THROW ST_showHelp		; Draw something so that ST_eraseHelp works
	ROM_THROW ST_eraseHelp		; Redraw the statut bar
	addq.l	#4,a7
blackline	lea	(LCD_MEM+30*(100-7)).w,a0	
		moveq	#30-1,d0	; Redraw the black line 
\blck_line		st.b	(a0)+
			dbf	d0,\blck_line

; ReInstall the traps of the TiOs, and the ports.
reinstall_tios_vars:
	lea	GHOST_SPACE,a2		; Get Vector Table in the Ghost Space.
	lea	newER_throw(Pc),a0	; Reinstall ER_throw
	move.l	a0,$28(a2)		; -> $28
	lea	crash_handler(Pc),a0	; ReInstall crash handler
	moveq	#7-1,d0			; 8 vectors
	lea	($8+$4)(a2),a1		
\loop_handler:	move.l  a0,(a1)+	; ReInstall new one
		dbf	d0,\loop_handler
	moveq	#7-1,d0			; Restore auto-ints
	lea	$64(a2),a1		; Dest
	lea	$E0(a2),a0		; Src
\loop_autoint:	move.l  (a0)+,(a1)+	; restore old handler
		dbra    d0,\loop_autoint
	; Restore the kernel vectors
	lea	$30(a2),a1
	move.l	#PREOS_VERSION,(a1)+	; $30=version
	lea	kernel::start_kernel_prgm(Pc),a0
	move.l	a0,(a1)+		; $34.l = Exec function
	lea	reloc(Pc),a0
	move.l	a0,(a1)+		; $38.l = Reloc(Handle) function
	lea	reloc2(Pc),a0
	move.l	a0,(a1)+		; $3C.l = Reloc2(ptr) function
	lea	unreloc(Pc),a0
	move.l	a0,(a1)+		; $40.l = UnReloc(Handle)
	lea	unreloc2(Pc),a0
	move.l	a0,(a1)+		; $44.l = UnReloc2(ptr)
	bsr	kernel::Ptr2Hd
	move.w	d0,(a1)+		; $48.w = Kernel's Handle
	lea	ExeArchive(Pc),a0
	move.l	a1,$50(a2)
	; Restore the ports
	move.w	#$4C00/8,$600010	; Reset screen on HW1
hwtimer	move.b	#$B2,$600017		; Reset Timer
	; Restore the contrast
orgcontrast	move.b	#$00,($5000).w	; Restore Org value in Contrast Var 
	ROM_THROW OSContrastUp
	; Restore the Hardware Protection by calling trap #$b (CAN'T USE function out of range since it is buggy in Trap #$B : it skips the saving vectors function, but it calls the restoring vectors function. So it will crash in an endless loop !
	moveq	#0,d3			; Function number 0 (write)
	suba.l	a3,a3			; Address out or range
	trap	#$B			; Redo Hardware protection.
	rts



RAM_TABLE	ds.l	MAX_RAMCALL	; RAM CALL table

Calc		dc.b	0		; CALCULATOR
Hw		dc.b	0		; HW_VERSION
Hw_disp_version	dc.b	0		; HW_DISPLAY_VERSION
Emulator	dc.b	0		; EMULATOR
Calc_copy	dc.l	0		; Copy of CALCULATOR for V200

org_stack	dc.w	0		; Du kernel
RelocStackList	dc.l	0		; De la relocation & error string ptr
ErrorString	dc.l	0		; Program Ref
FirstRun	dc.w	0		; Nombre de lancement
RetVal		dc.l	0		; Valeur de retour de l'estack
LibsExecList	dc.l	0		; List needed by LibsExec
UsedLibraryHd	dc.w	0
UsedLibraryNum	dc.w	0
FullScr		dc.w	0,0,239,127
mpastrouve	dc.b	"Library not found:"
mlibrairie	ds.b	9		;8 lettres et un 0
mwrong		dc.b	"New version needed:"
mmauvaise	ds.b	9
mmemory		dc.b	"Out of memory"
mmemory_end	dc.b	0
errortext	dc.b	"Crash intercepted",0
wrongrom	dc.b	"New Rom needed",0
wrongkernel	dc.b	"New Kernel needed",0
parityerror	dc.b	"Illegal stub",0
	ifd	CheckCalc
CheckCalc_str	dc.b	"Not right calc",0
	endif
	EVEN

