/*
 * font.h - Internationalization font module header file
 *
 * Copyright (c) 2001 Seiichi SATO <ssato@sh.rim.or.jp>
 *
 * licensed under the GPL.
 */

/* date structure */
typedef struct _Font_I18N {
    XFontSet fontset;
    XFontStruct *fontstruct;
    Bool use_fontset;
    int height;
    int y;
} FontI18N;

/*  global functions */
extern FontI18N *CreateFont(Display * dpy, char *fontname);
extern void DrawString(Display * dpy, Drawable d, FontI18N * font, GC gc,
		       int x, int y, char *str, int len);
int GetStringWidth(FontI18N * font, char *str, int len);
