/*
 *  Copyright (C) 2000 by Marco G"otze.
 *
 *  This code is part of the ThoughtTracker source package, which is
 *  distributed under the terms of the GNU GPL2.
 */

#include <cstdio>
#include <cstdlib>
#include <cstring>
#include <iostream>

#include <gdk/gdkx.h>
#include <gtk/gtkclist.h>

#include <gdk--/bitmap.h>
#include <gdk--/pixmap.h>

#include "thoughttracker.h"
#include "linklist.h"
#include "xpm.h"

#ifdef ENABLE_DEBUG
#undef DMSG 
#define DMSG cerr << "TTLinkList::" << __FUNCTION__ << "(): "
#endif  /* ENABLE_DEBUG */

using namespace Gtk;

//:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
TTLinkList::TTLinkList() : CList(2)
{
  // configure appearance
  set_selection_mode(GTK_SELECTION_SINGLE);
  set_column_auto_resize(0, false);
  set_column_resizeable(0, false);
  set_column_width(0, 25);
  set_column_justification(0, GTK_JUSTIFY_CENTER);
  set_column_auto_resize(1, false);
  set_column_resizeable(1, false);

  // configure sorting settings
  set_sort_column(1);
  set_sort_type(GTK_SORT_ASCENDING);
  set_auto_sort(true);
  set_compare_func((GtkCListCompareFunc) &ll_cmp);

  show();
}

//:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
void
TTLinkList::delete_link(dbid_t id)
{
  gint rows = GTK_CLIST(gtkobj())->rows;
  for (gint i = 0; i < rows; i++)
    if (*(dbid_t*) get_row_data(i) == id) {
      remove_row(i);
      break;  // can't be in there more than once, in theory, that is
    }
}

//:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
void
TTLinkList::new_link(bool update, dbid_t id, const string &summary,
  bool is_hub, bool is_linked)
{
  // create pixmaps/masks
  static GdkBitmap *m1, *m2, *m3, *m4;
  // symbold for isolated entry
  static GdkPixmap *i1 = gdk_pixmap_create_from_xpm_d(get_window(), &m1,
    &GTK_WIDGET(gtkobj())->style->bg[GTK_STATE_NORMAL], symbol_isolated_xpm);
  // linked entry
  static GdkPixmap *i2 = gdk_pixmap_create_from_xpm_d(get_window(), &m2,
    &GTK_WIDGET(gtkobj())->style->bg[GTK_STATE_NORMAL], symbol_linked_xpm);
  // isolated hub
  static GdkPixmap *i3 = gdk_pixmap_create_from_xpm_d(get_window(), &m3,
    &GTK_WIDGET(gtkobj())->style->bg[GTK_STATE_NORMAL],
    symbol_hub_isolated_xpm);
  // linked hub
  static GdkPixmap *i4 = gdk_pixmap_create_from_xpm_d(get_window(), &m4,
    &GTK_WIDGET(gtkobj())->style->bg[GTK_STATE_NORMAL],
    symbol_hub_linked_xpm);

  if (!update) {  // append
    // append row
    const char *arr[2] = { 0, summary.c_str() };
    gint row = append(arr);
  
    // set pixmap
  
    // CList::set_pixmap() appears to be broken in GTK-- 1.1.8, so we do this
    // manually
  
    // set appropriate pixmap
    gtk_clist_set_pixmap(gtkobj(), row, 0,
      is_hub ? (is_linked ? i4 : i3) : (is_linked ? i2 : i1),
      is_hub ? (is_linked ? m4 : m3) : (is_linked ? m2 : m1));
  
    // set row data (pointer to id)
    dbid_t *data = new dbid_t;
    *data = id;
    set_row_data_full(row, data, (GtkDestroyNotify) &free_row_data);
  } else {  // update
    gint rows = GTK_CLIST(gtkobj())->rows;
    for (gint i = 0; i < rows; i++)
      if (*(dbid_t*) get_row_data(i) == id) {
        // update text
        gtk_clist_set_text(gtkobj(), i, 1, summary.c_str());
        // update pixmap
        gtk_clist_set_pixmap(gtkobj(), i, 0,
          is_hub ? (is_linked ? i4 : i3) : (is_linked ? i2 : i1),
          is_hub ? (is_linked ? m4 : m3) : (is_linked ? m2 : m1));
        break;  // can't be in there more than once--in theory, that is
      }
  }
}

