/*
    Theseus - maximum likelihood superpositioning of macromolecular structures

    Copyright (C) 2004-2009 Douglas L. Theobald

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the:

    Free Software Foundation, Inc.,
    59 Temple Place, Suite 330,
    Boston, MA  02111-1307  USA

    -/_|:|_|_\-
*/

#ifndef LELE_SEEN
#define LELE_SEEN

void
SetupLele(CdsArray *cdsA);

void
CalcLeleCovMat(CdsArray *cdsA);

double
VariancesEDMA(double *var, double **edmamat, double **distmat, const int n);

void
CalcLeleVariances(CdsArray *cdsA);

void
NNxCds(double **mat, Cds *cds);

void
CdsxNN(Cds *cds, const double **mat);

double
RadGyrSqr(const Cds *cds);

double
RadGyrSqrW(const Cds *cds, const double *weights);

double
RadGyrSqrCov(Cds *cds, const double **weightmat);

void
CdsInnerProd(Cds *cds);

void
CdsInnerProd2(Cds *cds);

void
MatInnerProdSymIp(double **mat, const int N);

void
MatInnerProdSymOp(double **mato, const double **mati, const int N);

void
CalcEDMADistMat(CdsArray *cdsA);

void
CalcEDMADistMatOcc(CdsArray *cdsA);

void
LeleCenterMat(double **mat, const int len);

void
DoubleCenterMat(double **mat, const int len);

void
CalcMLDistMat(CdsArray *cdsA);

void
CalcMLDistMatOcc(CdsArray *cdsA);

void
EmbedAveCds(CdsArray *cdsA);

#endif
