/*
 * Author:     Denise Jorge de Oliveira <dezinha@land.ufrj.br> in Dec, 1999
 *
 */
#ifndef  _WB_SEG_E
#define  _WB_SEG_E

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>

#define  FALSE            0
#define  TRUE             1
#define  SEG_ID           256
#define  SEG_DATA_SIZE    512

struct SegmentationList *first;
struct SegmentationList *last;

typedef struct SegmentationPack{
    char    id[SEG_ID];
    char    data[SEG_DATA_SIZE];
    int     DataSize;
    int     LogicalClock;
    int     NumSeq;
    int     NumPackets;
}* ptrSegPack, SegPack;

typedef struct SegmentationList{
    char                    id[SEG_ID];
    int                     LogicalClock;
    int                     NumPackets;
    int                     ArrivedPcts;
    struct Fragment         *Frag;
    struct SegmentationList *prev, *next;
}* ptrSegList;

typedef struct Fragment{
    char    data[SEG_DATA_SIZE];
    int     DataSize;
}* ptrSegVec;



void InitializeSegmentation ();
ptrSegPack Segment (char *, int, char *, int, int *);
char *DeSegment (struct SegmentationPack, int * );

#endif  /* _WB_SEG_E */
