
/******************************************************************************
* MODULE     : attribute_event.gen.h
* DESCRIPTION: Events for setting and retrieving attributes of a widget.
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <event.gen.h>
#include <Event/event_codes.gen.h>

#module attribute_event
#import event
#import event_codes

/******************************************************************************
* Events for retrieving attributes
******************************************************************************/

struct get_integer_event_rep: public event_rep {
  string which; int& i;
  get_integer_event_rep (string which, int& i);
  operator tree ();
};
#import event (get_integer_event, get_integer_event_rep)

struct get_double_event_rep: public event_rep {
  string which; double& x;
  get_double_event_rep (string which, double& x);
  operator tree ();
};
#import event (get_double_event, get_double_event_rep)

struct get_string_event_rep: public event_rep {
  string which; string& s;
  get_string_event_rep (string which, string& s);
  operator tree ();
};
#import event (get_string_event, get_string_event_rep)

struct get_command_event_rep: public event_rep {
  string which; command& cmd;
  get_command_event_rep (string which, command& cmd);
  operator tree ();
};
#import event (get_command_event, get_command_event_rep)

struct get_coord1_event_rep: public event_rep {
  string which; SI& c1;
  get_coord1_event_rep (string which, SI& c1);
  operator tree ();
};
#import event (get_coord1_event, get_coord1_event_rep)

struct get_coord2_event_rep: public event_rep {
  string which; SI& c1; SI& c2;
  get_coord2_event_rep (string which, SI& c1, SI& c2);
  operator tree ();
};
#import event (get_coord2_event, get_coord2_event_rep)

struct get_coord3_event_rep: public event_rep {
  string which; SI& c1; SI& c2; SI& c3;
  get_coord3_event_rep (string which, SI& c1, SI& c2, SI& c3);
  operator tree ();
};
#import event (get_coord3_event, get_coord3_event_rep)

struct get_coord4_event_rep: public event_rep {
  string which; SI& c1; SI& c2; SI& c3; SI& c4;
  get_coord4_event_rep (string which, SI& c1, SI& c2, SI& c3, SI& c4);
  operator tree ();
};
#import event (get_coord4_event, get_coord4_event_rep)

/******************************************************************************
* Events for setting attributes
******************************************************************************/

struct set_integer_event_rep: public event_rep {
  string which; int i;
  set_integer_event_rep (string which, int i);
  operator tree ();
};
#import event (set_integer_event, set_integer_event_rep)

struct set_double_event_rep: public event_rep {
  string which; double x;
  set_double_event_rep (string which, double x);
  operator tree ();
};
#import event (set_double_event, set_double_event_rep)

struct set_string_event_rep: public event_rep {
  string which; string s;
  set_string_event_rep (string which, string s);
  operator tree ();
};
#import event (set_string_event, set_string_event_rep)

struct set_command_event_rep: public event_rep {
  string which; command cmd;
  set_command_event_rep (string which, command cmd);
  operator tree ();
};
#import event (set_command_event, set_command_event_rep)

struct set_coord1_event_rep: public event_rep {
  string which; SI c1;
  set_coord1_event_rep (string which, SI c1);
  operator tree ();
};
#import event (set_coord1_event, set_coord1_event_rep)

struct set_coord2_event_rep: public event_rep {
  string which; SI c1; SI c2;
  set_coord2_event_rep (string which, SI c1, SI c2);
  operator tree ();
};
#import event (set_coord2_event, set_coord2_event_rep)

struct set_coord3_event_rep: public event_rep {
  string which; SI c1; SI c2; SI c3;
  set_coord3_event_rep (string which, SI c1, SI c2, SI c3);
  operator tree ();
};
#import event (set_coord3_event, set_coord3_event_rep)

struct set_coord4_event_rep: public event_rep {
  string which; SI c1; SI c2; SI c3; SI c4;
  set_coord4_event_rep (string which, SI c1, SI c2, SI c3, SI c4);
  operator tree ();
};
#import event (set_coord4_event, set_coord4_event_rep)

#endmodule // attribute_event
