
/******************************************************************************
* MODULE     : tm_data.gen.h
* DESCRIPTION: Buffer management for TeXmacs server
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <server.gen.h>
#include <tm_buffer.gen.h>

#module tm_data
#import server
#import tm_buffer

class tm_data_rep: virtual public server_rep {
protected:
  array<tm_buffer> bufs; // the buffers

  /* Low level buffer menu manipulation */
  int       find_buffer (string name);
  string    new_menu_name (string name);
  void      update_menu ();
  void      menu_insert_buffer (tm_buffer buf);
  void      menu_delete_buffer (tm_buffer buf);
  void      menu_focus_buffer (tm_buffer buf);

  /* Low level buffer manipulation */
  tm_buffer new_buffer (string name);
  tm_buffer new_buffer (string name, tree t);
  void      revert_buffer (string name, tree doc);
  void      delete_buffer (tm_buffer buf);
  void      set_name_buffer (string name);
  string    get_name_buffer ();

  /* Low level view manipulation */
  tm_view   new_view (string name);
  tm_view   get_passive_view (tm_buffer buf);
  void      delete_view (tm_view vw);
  void      attach_view (tm_window win, tm_view vw);
  void      detach_view (tm_view vw);

  /* Low level window manipulation */
  tm_window new_window (display dis, bool map_flag= TRUE);
  bool      delete_view_from_window (tm_window win);
  void      delete_window (tm_window win);

  /* Other subroutines */
  void new_buffer_in_this_window (string name, tree t);
  void new_buffer_in_new_window (string name, tree t);
  tree make_document (tm_view vw);
  bool save (string name, tm_view vw);
  tree file_to_tree (string dir, string name, string fm);
  tm_buffer load_passive_buffer (string name);

public:
  tm_data_rep ();
  ~tm_data_rep ();

  /* Buffer management */
  void new_buffer ();
  void switch_to_buffer (int nr);
  void switch_to_buffer (string name);
  void revert_buffer ();
  void kill_buffer ();
  void open_window ();
  void clone_window ();
  void kill_window ();
  void set_max_undo_depth (int i);
  int  get_max_undo_depth ();
  bool no_bufs ();

  /* Project management */
  void project_attach (string prj_name);
  bool project_attached ();
  void project_update_menu ();

  /* File management */
  void load_buffer (string d, string n, string f, int w=0, bool a=FALSE);
  void save_buffer (string name, string fm);
  bool no_name ();
  bool exists_unsaved_buffer ();
  void pretend_save_buffer ();
  void auto_save ();
};

#endmodule // tm_data
