
/******************************************************************************
* MODULE     : resource.gen.h
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <string.gen.h>
#include <hashmap.gen.h>

#module resource (R, T)
#import hashmap (string, pointer)

extern hashmap<string,pointer> resource<T>;

struct rep<T> {
  string res_name;
  inline rep<T> (string res_name);
  inline virtual ~rep<T> ();
};

struct R;
struct T {
  R* rep;
  inline T (R* rep= NULL);
  inline T (string s);
  inline R* operator ->();
};

inline rep<T>::rep<T> (string s): res_name (s) {
  resource<T> (res_name)= (pointer) this; }
inline rep<T>::~rep<T> () {
  resource<T> -> reset (res_name); }
inline T::T (R* rep2): rep (rep2) {}
inline T::T (string s): rep ((R*) resource<T> [s]) {}
inline R* T::operator ->() { return rep; }
inline bool nil (T res) { return res.rep == NULL; }

ostream& operator << (ostream& out, T t);

#define make<T>(s,im) ((resource<T> -> contains (s))? T(s): T(im))

#endmodule // resource (R,T)

#module code_resource (R,T)

hashmap<string,pointer> resource<T> (NULL);

ostream& operator << (ostream& out, T t) {
  return out << t->res_name;
}

#endmodule // code_resource (R,T)
