
/******************************************************************************
* MODULE     : verbatim.gen.cc
* DESCRIPTION: routines for converting between TeXmacs trees and text
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <convert.gen.h>

#module code_verbatim
#import convert

/******************************************************************************
* Verbatim input
******************************************************************************/

string
tree_to_verbatim (tree t) {
  if (is_atomic (t))
    return tm_decode (t->label);

  int n= N(t);
  switch (L (t)) {
  case DOCUMENT:
    {
      int i;
      string buffer;
      for (i=0; i<n; i++) {
	if (i>0) buffer << '\n';
	buffer << tree_to_verbatim (t[i]);
      }
      return buffer;
    }
  case CONCAT:
    {
      int i;
      string buffer;
      for (i=0; i<n; i++)
	buffer << tree_to_verbatim (t[i]);
      return buffer;
    }
  default:
    return "";
  }
}

/******************************************************************************
* Verbatim output
******************************************************************************/

static string
un_tab (string s) {
  int i, j;
  string r;
  for (i=0, j=0; i<N(s); i++, j++)
    if (s[i]=='\t') {
      do {
	r << " "; j++;
      } while ((j&7) != 0);
      j--;
    }
    else r << s[i];
  return r;
}

tree
verbatim_to_tree (string s) {
  int i, j;
  for (i=0; i<N(s); i++)
    if (s[i]=='\n') {
      tree t (DOCUMENT);
      for (i=0, j=0; i<N(s); i++)
	if (s[i]=='\n') {
	  t << tm_encode (un_tab (s (j, i)));
	  j= i+1;
	}
      t << tm_encode (un_tab (s (j, i)));
      return t;
    }
  return tm_encode (un_tab (s));
}

#endmodule // code_verbatim
