
/******************************************************************************
* MODULE     : inittex.gen.cc
* DESCRIPTION: initialize conversion from and to TeX
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <convert.gen.h>
#include <file.gen.h>
#include <rel_hashmap.gen.h>

#module code_inittex
#import convert
#import file
#import rel_hashmap (string, int)
#import rel_hashmap (string, string)
#import rel_hashmap (string, tree)

static rel_hashmap<string,string> command_type ("undefined");
static rel_hashmap<string,int>    command_arity (0);
static rel_hashmap<string,string> command_def ("undefined");
static bool                       command_initialized = FALSE;

/******************************************************************************
* Initialization of TeX conversions
******************************************************************************/

static void
initialize_tex_sub (string s, string type, int arity) {
  command_type  (s) = type;
  command_arity (s) = arity;
  if ((N(s)>7) && (s(0,7)=="\\begin-") && (s[N(s)-1]!='*'))
    initialize_tex_sub ("\\end-" * s(7,N(s)), type, 0);
  if (arity<0) initialize_tex_sub (s * "*", type, -1-arity);
}

void
initialize_tex_conversions () {
  if (!command_initialized) {
    file f ("$TEXMACS_PATH/misc/convert", "latex_commands", "r");
    f->check_open ("latex <-> TeXmacs conversion not well installed",
		   "latexer::latexer");
    string s;
    f >> s;

    int i, j;
    scheme_tree p= block_to_scheme_tree (s);
    for (i=0; i<arity (p); i++)
      if (arity (p[i]) == 3) {
	string      type  = p[i][0]->label;
	int         arity = as_int (p[i][1]->label);
	scheme_tree q     = p[i][2];
	for (j=0; j<N(q); j++) {
	  string s= "\\" * q[j]->label;
	  initialize_tex_sub (s, type, arity);
	}
      }

    command_initialized= TRUE;
  }
}

#endmodule // code_inittex
