
/******************************************************************************
* MODULE     : tm_lisp.gen.cc
* DESCRIPTION: dynamically linked routines using (the obsolete) TeXmacs lisp
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <convert.gen.h>

#module code_tm_lisp
#import convert

static string    tm_lisp_install_error;
static bool      tm_lisp_installed= FALSE;
static void   (**tl_initialize) ();
static tree   (**tl_compile_lisp) (tree t);
static tree   (**tl_eval_lisp) (tree t);

/******************************************************************************
* Installation of TeXmacs-lisp
******************************************************************************/

#define get_symbol(r,p) \
  (tm_lisp_install_symbol (r,*((pointer*) ((void*)(&p)) )))

static bool
tm_lisp_install_symbol (string routine, pointer& p) {
  tm_lisp_install_error= symbol_install ("libprg.so", routine, p);
  if (p==NULL) cerr << "TeXmacs] Error: " << tm_lisp_install_error << "\n";
  else tm_lisp_install_error= "";
  return (p==NULL);
}

bool
tm_lisp_install () {
  if (tm_lisp_install_error != "") return FALSE;
  if (tm_lisp_installed) return TRUE;
  if (get_symbol ("c_tm_lisp_initialize", tl_initialize)) return FALSE;
  if (get_symbol ("c_compile_lisp", tl_compile_lisp)) return FALSE;
  if (get_symbol ("c_eval_lisp", tl_eval_lisp)) return FALSE;
  tm_lisp_installed= TRUE;
  (*tl_initialize) ();
  return TRUE;
}

/******************************************************************************
* Routines imported from TeXmacs-lisp
******************************************************************************/

tree
dl_compile_lisp (tree t) {
  if (tm_lisp_install ())
    return (*tl_compile_lisp) (t);
  else return "";
}

tree
dl_eval_lisp (tree t) {
  if (tm_lisp_install ())
    return (*tl_eval_lisp) (t);
  else return "";
}

#endmodule // code_tm_lisp
