
/******************************************************************************
* MODULE     : fast_alloc.gen.h
* DESCRIPTION: see fast_alloc.gen.cc
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include <tm_configure.gen.h>

#module fast_alloc
#import tm_configure
#include <stdlib.h>
#include <iostream.h>

#define BLOCK_SIZE 65536 // should be >>> MAX_FAST

/******************************************************************************
* Globals
******************************************************************************/

extern char*  alloc_table[MAX_FAST];
extern char*  alloc_mem;
extern size_t alloc_remains;
extern int    allocated;

#define alloc_ptr(i) (*((void **) (alloc_table+i)))
#define ind(ptr) (*((void **) ptr))

/******************************************************************************
* General purpose fast allocation routines
******************************************************************************/

extern void* safe_malloc (register size_t s);
extern void* enlarge_malloc (register size_t s);
extern void* fast_alloc (register size_t s);
extern void  fast_free (register void* ptr, register size_t s);

extern int   mem_used ();
extern void  mem_info ();

#endmodule // fast_alloc
