
/******************************************************************************
* MODULE     : gg_array_string.cc
* DESCRIPTION: fixed size arrays with reference counting
* COPYRIGHT  : (C) 1999  Joris van der Hoeven
*******************************************************************************
* This software falls under the GNU general public license and comes WITHOUT
* ANY WARRANTY WHATSOEVER. See the file $TEXMACS_PATH/LICENSE for more details.
* If you don't have this file, write to the Free Software Foundation, Inc.,
* 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
******************************************************************************/

#include "gg_array_string.h"

/******************************************************************************
* Routines intern to the array_string class
******************************************************************************/

static inline int
round_length_string (int n) {
  if (n<6) return n;
  register int i=8;
  while (n>i) i<<=1;
  return i;
}

array_rep_string::array_rep_string(int n2):
  ref_count (1), n(n2),
  a((n==0)?((string*) NULL):(new string[round_length_string(n)])) {}

array_string::array_string (string* a, int n) {
  register int i;
  rep= new array_rep_string(n);
  for (i=0; i<n; i++)
    rep->a[i]=a[i];
}

void
array_string::resize (register int n2) {
  register int n= round_length_string (rep->n);
  register int m= round_length_string (n2);
  if (m!=n) {
    if (m!=0) {
      register int i,k=(n2<rep->n?n2:rep->n);
      string* b= new string[m];
      for (i=0; i<k; i++) b[i]=rep->a[i];
      if (n!=0) delete[] rep->a;
      rep->a=b;
    }
    else if (n!=0) delete[] rep->a;
  }
  rep->n=n2;
}

/******************************************************************************
* Other routines on arrays
******************************************************************************/

bool
array_rep_string::contains (string s) {
  int i;
  for (i=0; i<n; i++)
    if (a[i]==s) return TRUE;
  return FALSE;
}

bool
operator == (array_string a, array_string b) {
  register int i;
  if (N(a)!=N(b)) return FALSE;
  for (i=0; i<N(a); i++)
    if (a[i]!=b[i]) return FALSE;
  return TRUE;
}

bool
operator != (array_string a, array_string b) {
  register int i;
  if (N(a)!=N(b)) return TRUE;
  for (i=0; i<N(a); i++)
    if (a[i]!=b[i]) return TRUE;
  return FALSE;
}

ostream&
operator << (ostream& out, array_string a) {
  int i;
  
  if (N(a)==0) return out << "[ ]";
  out << "[ ";
  for (i=0; i<N(a)-1; i++)
    out << a[i] << ", ";
  if (N(a)!=0) out << a[i];
  out << " ]";
  return out;
}

array_string&
operator << (array_string& a, string x) {
  a.resize (N(a)+ 1);
  a[N(a)-1]=x;
  return a;
}

array_string&
operator << (array_string& a, array_string b) {
  register int i, k= N(a);
  a.resize (N(a)+ N(b));
  for (i=0; i<N(b); i++) a[i+k]= b[i];
  return a;
}
