/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.mvel2.CompileException;
import org.mvel2.ParserContext;
import org.mvel2.ast.ArraySize;
import org.mvel2.compiler.AbstractParser;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ArrayTools;
import org.mvel2.util.ParseTools;

public class TypeDescriptor
implements Serializable {
    private String className;
    private char[] classNameArray;
    private ArraySize[] arraySize;
    private ExecutableStatement[] compiledArraySize;
    int endRange;

    public TypeDescriptor() {
    }

    public TypeDescriptor(char[] name, int fields) {
        this.classNameArray = name;
        this.updateClassName(name, fields);
    }

    public void updateClassName(char[] name, int fields) {
        this.classNameArray = name;
        if (name.length == 0 || !ParseTools.isIdentifierPart(name[0]) || Character.isDigit(name[0])) {
            return;
        }
        this.endRange = ArrayTools.findFirst('(', name);
        if (this.endRange == -1) {
            this.endRange = ArrayTools.findFirst('[', name);
            if (this.endRange != -1) {
                int i;
                this.className = new String(name, 0, this.endRange).trim();
                LinkedList<char[]> sizes = new LinkedList<char[]>();
                while (this.endRange < name.length) {
                    while (this.endRange < name.length && ParseTools.isWhitespace(name[this.endRange])) {
                        ++this.endRange;
                    }
                    if (this.endRange == name.length || name[this.endRange] == '{') break;
                    if (name[this.endRange] != '[') {
                        throw new CompileException("unexpected token in contstructor", name, this.endRange);
                    }
                    int to = ParseTools.balancedCapture(name, this.endRange, '[');
                    sizes.add(ParseTools.subset(name, ++this.endRange, to - this.endRange));
                    this.endRange = to + 1;
                }
                Iterator iter = sizes.iterator();
                this.arraySize = new ArraySize[sizes.size()];
                for (i = 0; i < this.arraySize.length; ++i) {
                    this.arraySize[i] = new ArraySize((char[])iter.next());
                }
                if ((fields & 0x10) != 0) {
                    this.compiledArraySize = new ExecutableStatement[this.arraySize.length];
                    for (i = 0; i < this.compiledArraySize.length; ++i) {
                        this.compiledArraySize[i] = (ExecutableStatement)ParseTools.subCompileExpression(this.arraySize[i].value);
                    }
                }
                return;
            }
            this.className = new String(name).trim();
        } else {
            this.className = new String(name, 0, this.endRange).trim();
        }
    }

    public boolean isArray() {
        return this.arraySize != null;
    }

    public int getArrayLength() {
        return this.arraySize.length;
    }

    public ArraySize[] getArraySize() {
        return this.arraySize;
    }

    public ExecutableStatement[] getCompiledArraySize() {
        return this.compiledArraySize;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isClass() {
        return this.className != null && this.className.length() != 0;
    }

    public int getEndRange() {
        return this.endRange;
    }

    public void setEndRange(int endRange) {
        this.endRange = endRange;
    }

    public static Class getClassReference(Class baseType, TypeDescriptor tDescr, VariableResolverFactory factory, ParserContext ctx) throws ClassNotFoundException {
        return ParseTools.findClass(factory, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + baseType.getName() + ";", ctx);
    }

    public static Class getClassReference(ParserContext ctx, Class cls, TypeDescriptor tDescr) throws ClassNotFoundException {
        if (tDescr.isArray()) {
            cls = ParseTools.findClass(null, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + cls.getName() + ";", ctx);
        }
        return cls;
    }

    public static Class getClassReference(ParserContext ctx, TypeDescriptor tDescr) throws ClassNotFoundException {
        Class cls;
        if (ctx != null && ctx.hasImport(tDescr.className)) {
            cls = ctx.getImport(tDescr.className);
            if (tDescr.isArray()) {
                cls = ParseTools.findClass(null, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + cls.getName() + ";", ctx);
            }
        } else if (ctx == null && TypeDescriptor.hasContextFreeImport(tDescr.className)) {
            cls = TypeDescriptor.getContextFreeImport(tDescr.className);
            if (tDescr.isArray()) {
                cls = ParseTools.findClass(null, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + cls.getName() + ";", ctx);
            }
        } else {
            cls = ParseTools.createClass(tDescr.getClassName(), ctx);
            if (tDescr.isArray()) {
                cls = ParseTools.findClass(null, ParseTools.repeatChar('[', tDescr.arraySize.length) + "L" + cls.getName() + ";", ctx);
            }
        }
        return cls;
    }

    public boolean isUndimensionedArray() {
        if (this.arraySize != null) {
            for (ArraySize anArraySize : this.arraySize) {
                if (anArraySize.value.length != 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasContextFreeImport(String name) {
        return AbstractParser.LITERALS.containsKey(name) && AbstractParser.LITERALS.get(name) instanceof Class;
    }

    public static Class getContextFreeImport(String name) {
        return (Class)AbstractParser.LITERALS.get(name);
    }

    public char[] getClassNameArray() {
        return this.classNameArray;
    }
}

