/*
 * defs.h - a header file for xldvi
 * by Hirotsugu Kakugawa
 */
/*
 * Copyright (C) 1996-1997 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 */

#define VERSION  "2.4.3"

#define Public   /*null*/
#define Private  static
#define Import   extern

#define Bool  int
#define TRUE   (1==1)
#define FALSE  (1==0)


#define MAX_MAGNIFICATION        6

#define WIN_MOVE_X         5
#define WIN_MOVE_X_MAX   200
#define WIN_MOVE_Y         5

#define EPS_STYLE_LATEX2E_GRAPHICS_STY       0
#define EPS_STYLE_LATEX2E_GRAPHICS_STY_STR   "LaTeX2e/graphics.sty"
#define EPS_STYLE_LATEX209_EPSF_STY          1
#define EPS_STYLE_LATEX209_EPSF_STY_STR      "LaTeX2.09/epsf.sty"

Import DVI          dviobj;
Import DVI_DEVICE   dev;
Import int          current_page;
Import double       shrink;
Import int          x_offset_x, x_offset_y;

Import void  main_loop(void);
Public void  goto_page(int);

Import int   paper_sym2id(char*,char*);
Import void  paper_size(int,unsigned int*,unsigned int*);
Import char* find_dvi_file(char*);
Import Bool  atob(char*);
Import void  set_shrink(double);
Import void  change_shrink(double);

Import int   DEV_poll(DVI_DEVICE,DVI,int);
Import void  DEV_put_bitmap(DVI_DEVICE,DVI,DVI_BITMAP,int,long,long,long,long);
Import void  DEV_put_pixmap_rgb(DVI_DEVICE,DVI,DVI_PIXMAP_RGB,
				int,long,long,long,long);
Import void  DEV_put_graymap(DVI_DEVICE,DVI,DVI_GRAYMAP,
			     int,long,long,long,long);
Import void  DEV_put_rectangle(DVI_DEVICE,DVI,long,long,long,long);
Import void  DEV_color_rgb(DVI_DEVICE,DVI,int,double,double,double);
Import void  DEV_bgcolor_rgb(DVI_DEVICE,DVI,int,double,double,double);
Import void  DEV_color_gray(DVI_DEVICE,DVI,int,double);
Import void  DEV_bgcolor_gray(DVI_DEVICE,DVI,int,double);
Import int   DEV_draw_ps_figures(DVI_DEVICE,DVI);
Import int   DEV_before_ps_figure(DVI_DEVICE,DVI,char*,long,long,long);
Import void  DEV_after_ps_figure(DVI_DEVICE,DVI,char*,long,long,long);
Import int   DEV_special_command_undef(DVI_DEVICE,DVI,char*,long,long,long);
Import char* DEV_gs_program_path(DVI_DEVICE,DVI);
Import int   DEV_gs_timeout_value(DVI_DEVICE,DVI);
Import int   DEV_gs_timeout_giveup(DVI_DEVICE,DVI);
Import void  DEV_message_advice(DVI_DEVICE,DVI,char*,...);
Import void  DEV_message_warning(DVI_DEVICE,DVI,char*,...);
Import void  DEV_message_error(DVI_DEVICE,DVI,char*,...);
Import void  DEV_message_fatal(DVI_DEVICE,DVI,char*,...);


/*EOF*/
