/*  XGDVI
 *  Copyright (C) 1999  Hirotsugu Kakugawa
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "../config.h"

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#if HAVE_STRING_H
#  include <string.h>
#endif
#if HAVE_STRINGS_H
#  include <strings.h>
#endif

#include <glib.h>
#include "path.h"

static char  *dir_match(char *path, char *dir);


char*
path_canonical(char *path)
{
  char  *p, *s, *p1, *p2;

  if (path == NULL)
    return NULL;

  if (g_path_is_absolute(path)){
    p = g_strdup(path);
  } else {
    p = g_strdup_printf("%s%s%s", g_get_current_dir(), "/", path);
  }
  if (p == NULL)
    return NULL;
  
  for (;;){
    if ((s = dir_match(p, "..")) != NULL){
      if (s == p){
	p1 = p;
	p2 = p + strlen("/..");
	while ((*p1++ = *p2++) != '\0')
	  ;
      } else {
	p1 = s - 1;
	p2 = s + strlen("/..");
	while (strncmp(p1, "/", strlen("/")) != 0)
	  p1--;
	while ((*p1++ = *p2++) != '\0')
	  ;
      }
    } else if ((s = dir_match(p, ".")) != NULL){
      p1 = s + strlen("/");
      p2 = s + strlen("/./");
      while ((*p1++ = *p2++) != '\0')
	;
    } else {
      break;
    }
  }
  return  p;
}

static char*
dir_match(char *path, char *dir)
{
  int  len;
  char *s;

  len = strlen(dir);
  for (s = path; *s != '\0'; s++){
    if (strncmp(s, "/", 1) != 0)
      continue;
    if (strncmp(s+1, dir, len) != 0)
      continue;
    if (strncmp(s+1+len, "/", 1) != 0)
      continue;
    return s;
  }
  return NULL;
}


#ifdef DEBUG
/*
 * gcc -DDEBUG `glib-config --cflags` path.c `glib-config --libs`
 */

int 
main(int argc, char **argv)
{
  argc--; 
  argv++;

  while (argc > 0){
    printf("%s\n", path_canonical(*argv));
    argc--;
    argv++;
  }

  return 0;
}
#endif
