# Top-level Makefile for kpathsea-using programs.
INCLUDE=$(INCLUDE);../../win32

!include <make/paths.mak>
!include <make/makevars.mak>

# Package subdirectories.
all_dirs = goo xpdf doc

# It's too bad we have to pass all these down, but I see no alternative,
# if we are to propagate changes at the top level.
# XMAKEARGS is for the user to override.
# makeargs = $(MFLAGS) CC='$(CC)' CFLAGS='$(CFLAGS)' $(makevars) $(XMAKEARGS)
# installargs = INSTALL_DATA='$(INSTALL_DATA)' \
#  INSTALL_PROGRAM='$(INSTALL_PROGRAM)' $(makeargs)
makeargs = -$(MAKEFLAGS)
installargs = $(makeargs)

# Not everything from common.mk is relevant to this top-level
# Makefile, but most of it is, and it doesn't seem worth separating the
# compilation-specific stuff.
!include <make/common.mak>

all:
	-@echo $(verbose) & echo Entering xpdf for 'c-auto.h' \
		& pushd xpdf & $(MAKE) $(makeargs) c-auto.h & popd
	-@echo $(verbose) & for %%d in ($(all_dirs)) do \
		echo Entering %%d for $@ \
		& pushd %%d & $(MAKE) $(makeargs) $@ & popd

install install-data install-exec install-info install-man install-doc:
	for %%d in ($(all_dirs)) do cd %%d & $(MAKE) $(installargs) $@ & cd ..

# Other standard targets for everything.
uninstall uninstall-exec uninstall-data \
mostlyclean clean distclean realclean extraclean configclean \
info dvi check depend::
	-@echo $(verbose) & for %%d in ($(all_dirs)) do \
		echo Entering %%d for $@ \
		& pushd %%d & $(MAKE) $(makeargs) $@ & popd

distclean realclean::
	-@$(RM) config.status config.cache config.log

##ifdef HOSTNAME
##ac_dir = $(gnu)/share/autoconf
##autoconf = $(ac_dir)/acspecific.m4 $(ac_dir)/acgeneral.m4 $(ac_dir)/acsite.m4
##configure_in = $(srcdir)/configure.in
##$(srcdir)/configure: $(configure_in) $(autoconf)
##	cd $(srcdir); autoconf
##endif

!include <make/config.mak>

# Local Variables:
# mode: Makefile
# End:
