/*

    File: chgtype.c

    Copyright (C) 1998-2004 Christophe GRENIER <grenier@cgsecurity.org>
  
    This software is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
 
#include <stdarg.h>
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#include <ctype.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>	/* geteuid */
#endif
#include "types.h"
#include "common.h"
#include "lang.h"
#include "intrf.h"
#include "fnctdsk.h"
#include "chgtype.h"

int change_part_type(const t_param_disk *disk_car,t_partition *partition)
{
  char response[100];
  int nbr=0;
  int i;
  aff_buffer(BUFFER_RESET,"Q");
  aff_buffer(BUFFER_ADD,"List of partition type\n");
  for(i=0;i<=0xFF;i++)
  {
    const char *part_name;
    part_name=partition_type(i, disk_car->arch->parttype_name_table);
    if(part_name!=NULL)
    {
      aff_buffer(BUFFER_ADD,"%02x %-20s ",i,part_name);
      nbr++;
      if(nbr==3)
      {
	nbr=0;
	aff_buffer(BUFFER_ADD,"\n");
      }
    }
  }
  aff_copy(stdscr);
  wmove(stdscr,4,0);
  aff_part(stdscr,AFF_PART_ORDER,disk_car,partition);
  aff_buffer(BUFFER_DISPLAY,"Q",stdscr);
  wmove(stdscr,23,0);
  wdoprintf(stdscr,"New partition type [current %02x] ?",partition->part_type);
  if (get_string(response, sizeof(response), NULL) > 0) {
    int tmp_val = strtol(response, NULL, 16);
    if(disk_car->arch->is_part_type_ok(tmp_val)!=0)
    {
      partition->part_type = tmp_val;
    }
  }
  return 0;
}


