/*
 * Telepathy Inspector - A Telepathy client which exposes Telepathy interfaces.
 *                       Meant to inspect and/or test connection managers.
 *
 * ti-dlg-get-handles.c:
 * Dialog to get handles.
 *
 * Copyright (C) 2008 Collabora Ltd. <http://www.collabora.co.uk/>
 * Copyright (C) 2008 Nokia Corporation
 * Copyright (C) 2006 INdT - Instituto Nokia de Tecnologia
 * Originally by Daniel d'Andrada T. de Carvalho <daniel.carvalho@indt.org.br>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "dlg-get-handles.h"

#include <glade/glade.h>

#include "util.h"

G_DEFINE_TYPE (TIDlgGetHandles, ti_dlg_get_handles, G_TYPE_OBJECT);

/**
 * Instance private data.
 */
struct _TIDlgGetHandlesPrivate {
    gboolean disposed;

    GtkWindow *parent;

    GladeXML *glade_xml;

    GtkWidget *dialog;

    GtkComboBox *combo_handle_type;
    GtkComboBox *comboentry_handle_names;
};
typedef struct _TIDlgGetHandlesPrivate TIDlgGetHandlesPrivate;

#define TI_DLG_GET_HANDLES_GET_PRIVATE(object) \
    (G_TYPE_INSTANCE_GET_PRIVATE ((object), TI_TYPE_DLG_GET_HANDLES, \
        TIDlgGetHandlesPrivate))

static void
ti_dlg_get_handles_dispose (GObject *object)
{
  TIDlgGetHandles *self = TI_DLG_GET_HANDLES (object);
  TIDlgGetHandlesPrivate *priv = TI_DLG_GET_HANDLES_GET_PRIVATE (self);

  if (priv->disposed)
    {
      return;
    }

  priv->disposed = TRUE;

  if (priv->glade_xml != NULL)
    {
      g_object_unref (priv->glade_xml);
      priv->glade_xml = NULL;
    }

  G_OBJECT_CLASS (ti_dlg_get_handles_parent_class)->dispose (object);
}

static void
ti_dlg_get_handles_class_init (TIDlgGetHandlesClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->dispose = ti_dlg_get_handles_dispose;

  g_type_class_add_private (klass, sizeof (TIDlgGetHandlesPrivate));
}

static void
ti_dlg_get_handles_init (TIDlgGetHandles *self)
{
  TIDlgGetHandlesPrivate *priv = TI_DLG_GET_HANDLES_GET_PRIVATE (self);

  priv->disposed = FALSE;
}

TIDlgGetHandles *
ti_dlg_get_handles_new (GtkWindow *parent)
{
  TIDlgGetHandles *dialog = NULL;
  TIDlgGetHandlesPrivate *priv = NULL;
  gchar *glade_file_path = NULL;

  dialog = g_object_new (TI_TYPE_DLG_GET_HANDLES, NULL);
  priv = TI_DLG_GET_HANDLES_GET_PRIVATE (dialog);

  priv->parent = parent;

  glade_file_path = ti_get_glade_path ("dlg-get-handles.xml");
  priv->glade_xml = glade_xml_new (glade_file_path, NULL, NULL);

  if (priv->glade_xml == NULL)
    {
      g_critical ("Error loading glade file \"%s\".", glade_file_path);
      g_object_unref (dialog);
      dialog = NULL;
      goto CLEAN_UP;
    }

  priv->dialog = glade_xml_get_widget (priv->glade_xml, "dialog_get_handles");
  g_assert (GTK_IS_DIALOG (priv->dialog));

  priv->combo_handle_type = GTK_COMBO_BOX (
      glade_xml_get_widget (priv->glade_xml, "combo_handle_type"));
  g_assert (GTK_IS_COMBO_BOX (priv->combo_handle_type));

  priv->comboentry_handle_names = GTK_COMBO_BOX (
      glade_xml_get_widget (priv->glade_xml, "comboentry_handle_names"));
  g_assert (GTK_IS_COMBO_BOX_ENTRY (priv->comboentry_handle_names));

  gtk_window_set_transient_for (GTK_WINDOW (priv->dialog),
      GTK_WINDOW (priv->parent));
  gtk_window_set_position (GTK_WINDOW (priv->dialog),
      GTK_WIN_POS_CENTER_ON_PARENT);

  glade_xml_signal_connect_data (priv->glade_xml, "button_ok_clicked",
      G_CALLBACK (ti_ok_button_clicked), priv->dialog);
  glade_xml_signal_connect_data (priv->glade_xml, "button_cancel_clicked",
      G_CALLBACK (ti_cancel_button_clicked), priv->dialog);

CLEAN_UP:
  g_free (glade_file_path);

  return dialog;
}

gboolean
ti_dlg_get_handles_run (TIDlgGetHandles *self,
                        const gchar *title,
                        guint *type,
                        gchar ***names)
{
  TIDlgGetHandlesPrivate *priv = TI_DLG_GET_HANDLES_GET_PRIVATE (self);
  gint result;
  gint active_handle_type;

  gtk_window_set_title (GTK_WINDOW (priv->dialog), title);

  gtk_widget_show_all (priv->dialog);
  result = gtk_dialog_run (GTK_DIALOG (priv->dialog));
  gtk_widget_hide_all (priv->dialog);

  if (result != GTK_RESPONSE_OK)
    return FALSE;

  active_handle_type = gtk_combo_box_get_active (priv->combo_handle_type);

  if (active_handle_type >= 0)
    {
      *type = (guint) active_handle_type;
    }
    else
    {
      return FALSE;
    }

    /* Get handle names
     * TODO: Parse a comma-separated list of names
     * Currently it's a hardcoded one-entry list. */
  *names = g_new0 (gchar *, 2);
  **names = gtk_combo_box_get_active_text (priv->comboentry_handle_names);

  return TRUE;
}
