/*	$Id: status.c,v 1.27 2001/12/22 04:23:34 riq Exp $	*/
/* Tenes Empanadas Graciela
 *
 * Copyright (C) 2000 Ricardo Quesada
 *
 * Author: Ricardo Calixto Quesada <rquesada@core-sdi.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; only version 2 of the License
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
/**
 * @file status.c
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <assert.h>
#include <gnome.h>

#include "gui.h"
#include "client.h"
#include "support.h"
#include "interface.h"
#include "callbacks.h"
#include "status.h"
#include "colors.h"
#include "priv.h"

#define HELVETICA_10_FONT  "-adobe-helvetica-medium-r-normal-*-10-*-*-*-*-*-*-*"
#define HELVETICA_20_FONT  "-adobe-helvetica-medium-r-normal-*-20-*-*-*-*-*-*-*"
#define HELVETICA_20_BFONT "-adobe-helvetica-bold-r-normal-*-20-*-*-*-*-*-*-*"
#define HELVETICA_14_BFONT "-adobe-helvetica-bold-r-normal-*-14-*-*-*-*-*-*-*"

GtkWidget *status_dialog=NULL;
static GtkWidget *ministatus = NULL;
static int linesindisplay=0;

static GtkWidget *status_clist=NULL;

static gint status_boton_clicked_cb(GtkWidget *area, GdkEventExpose *event, gpointer user_data)
{
	out_status();
	return FALSE;
}

/**
 * @fn TEG_STATUS status_paint_color( int color , GdkPixmap **pixmap )
 */
static TEG_STATUS status_paint_color( int color, GdkPixmap **pixmap )
{
	int i, h, w;

	assert( pixmap );

	i = (color<0 || color>=TEG_MAX_PLAYERS) ? TEG_MAX_PLAYERS : color;

	*pixmap = gdk_pixmap_new(status_dialog->window,
		48, 16, gtk_widget_get_visual(status_dialog)->depth);

	if( *pixmap == NULL )
		return TEG_STATUS_ERROR;


	gdk_gc_set_foreground(g_colors_gc, colors_get_player_from_color(color));
	gdk_draw_rectangle( *pixmap, g_colors_gc, TRUE, 0, 0, 47, 15);

	gdk_gc_set_foreground(g_colors_gc, colors_get_common(COLORS_BLACK));
	gdk_draw_rectangle( *pixmap, g_colors_gc, FALSE, 0, 0, 47, 15);

	gdk_gc_set_foreground(g_colors_gc, colors_get_player_ink_from_color(color));



	h = gdk_string_height (g_pixmap_font10, _(g_colores[i]) );
	w = gdk_string_width  (g_pixmap_font10, _(g_colores[i]) );

	gdk_draw_string( *pixmap, g_pixmap_font10, g_colors_gc, 
			((48 - w )/2),
			((16 - h)/2) + h, _(g_colores[i]));
	return TEG_STATUS_SUCCESS;
}

TEG_STATUS status_turn_color(PJUGADOR pJ, GdkPixmap **pixmap)
{
	int i;

	assert( pixmap );
	assert( pJ );


	if( pJ->empezo_turno )
		i = pJ->numjug;
	else
		i = -1;

	*pixmap = gdk_pixmap_new(status_dialog->window,
		16, 16, gtk_widget_get_visual(status_dialog)->depth);

	if( *pixmap == NULL )
		return TEG_STATUS_ERROR;

	gdk_gc_set_foreground(g_colors_gc, colors_get_player(i));
	gdk_draw_rectangle( *pixmap, g_colors_gc, TRUE, 0, 0, 15, 15);

	gdk_gc_set_foreground(g_colors_gc, colors_get_common(COLORS_BLACK));
	gdk_draw_rectangle( *pixmap, g_colors_gc, FALSE, 0, 0, 15, 15);

	return TEG_STATUS_SUCCESS;
}



/**
 * @fn void status_view()
 * Funcion que sirve para ver el status
 */
void status_view()
{
	gint i ;
	char *titles[S_CLIST_N_LAST] = {
		_("Color"), _("Number"),_("Name"),_("Score"), _("Address"), _("Human"), _("Countries"), _("Armies"), _("Cards"),_("Status"), _("Who started"),
	};

	if( status_dialog == NULL) {

		status_dialog = teg_dialog_new(_("Player's Status"),_("Player's Status")); 

		gtk_window_set_transient_for (GTK_WINDOW(status_dialog), NULL);

		gnome_dialog_append_buttons(GNOME_DIALOG(status_dialog),
				GNOME_STOCK_PIXMAP_REFRESH,
				GNOME_STOCK_BUTTON_CLOSE,
				NULL );

		gnome_dialog_close_hides( GNOME_DIALOG(status_dialog), TRUE );
		gnome_dialog_set_default(GNOME_DIALOG(status_dialog),1);

		/* signals de los botones */
		gnome_dialog_button_connect (GNOME_DIALOG(status_dialog),
						0, GTK_SIGNAL_FUNC(status_boton_clicked_cb),status_dialog);
		gnome_dialog_button_connect (GNOME_DIALOG(status_dialog),
						1, GTK_SIGNAL_FUNC(dialog_close),status_dialog);
		gnome_dialog_set_default( GNOME_DIALOG(status_dialog),1);


		status_clist = gtk_clist_new_with_titles (S_CLIST_N_LAST, titles);
		
		gtk_clist_set_row_height (GTK_CLIST (status_clist), 18);
//		gtk_widget_set_usize (status_clist, -1, 300);

		gtk_box_pack_start_defaults( GTK_BOX(GNOME_DIALOG(status_dialog)->vbox), GTK_WIDGET(status_clist));

		gtk_clist_set_selection_mode (GTK_CLIST (status_clist), GTK_SELECTION_EXTENDED);
		for (i = 0; i < S_CLIST_N_LAST; i++) {
			gtk_clist_set_column_justification (GTK_CLIST (status_clist), i, GTK_JUSTIFY_CENTER);
			gtk_clist_set_column_auto_resize (GTK_CLIST (status_clist), i, TRUE);
		}

		linesindisplay = 0;
	}
	status_fill_clist( status_clist);
	gtk_widget_show_all(status_dialog);
	raise_and_focus(status_dialog);
	out_status();
}

/**
 * @fn TEG_STATUS status_fill_clist( GtkWidget *clist )
 */
TEG_STATUS status_fill_clist( GtkWidget *clist )
{
#define S_CLIST_MAX (100)
	PJUGADOR j;
	PLIST_ENTRY l = g_list_jugador.Flink;
	char clist_text[S_CLIST_N_LAST][S_CLIST_MAX];
	char *clist_texts[S_CLIST_N_LAST];
	int i, row;
	GdkPixmap *pixmap;
	
	gtk_clist_freeze(GTK_CLIST(clist));

	for(i=0;i<S_CLIST_N_LAST;i++) {
		int b;

		clist_texts[i] = clist_text[i];
		memset( clist_text[i],0,S_CLIST_MAX);

		b = gui_private.status_show & (1 <<i ) ? 1 : 0;
		gtk_clist_set_column_visibility( GTK_CLIST(clist), i, b );
	}

	row = 0;
	while( !IsListEmpty( &g_list_jugador ) && (l != &g_list_jugador) ) {
		j = (PJUGADOR) l;

		/* sprintf(clist_texts[0],"%s",g_colores[j->color]); */
		snprintf(clist_texts[S_CLIST_N_NUMBER],S_CLIST_MAX-1,"%d",j->numjug);
		snprintf(clist_texts[S_CLIST_N_NAME],S_CLIST_MAX-1,"%s",j->nombre);
		snprintf(clist_texts[S_CLIST_N_SCORE],S_CLIST_MAX-1,"%d",j->score);
		snprintf(clist_texts[S_CLIST_N_ADDR],S_CLIST_MAX-1,"%s",j->addr);
		snprintf(clist_texts[S_CLIST_N_HUMAN],S_CLIST_MAX-1,"%s",(j->human?_("yes"):_("no")) );
		snprintf(clist_texts[S_CLIST_N_COUNTRIES],S_CLIST_MAX-1,"%d",j->tot_paises);
		snprintf(clist_texts[S_CLIST_N_ARMIES],S_CLIST_MAX-1,"%d",j->tot_ejercitos);
		snprintf(clist_texts[S_CLIST_N_CARDS],S_CLIST_MAX-1,"%d",j->tot_tarjetas);
		snprintf(clist_texts[S_CLIST_N_STATUS],S_CLIST_MAX-1,"%s",_(g_estados[j->estado]));

		if (linesindisplay < row+1) {
			gtk_clist_append (GTK_CLIST (clist), clist_texts);
			linesindisplay++;
		}
		else {
	 		for(i=1;i<S_CLIST_N_LAST;i++)
	   			gtk_clist_set_text(GTK_CLIST (clist), row, i, clist_texts[i]);
		}

		if( status_paint_color( j->color, &pixmap ) == TEG_STATUS_SUCCESS )
			gtk_clist_set_pixmap(GTK_CLIST(clist), row, S_CLIST_N_COLOR, pixmap, NULL);

		if( status_turn_color( j, &pixmap ) == TEG_STATUS_SUCCESS )
			gtk_clist_set_pixmap(GTK_CLIST(clist), row, S_CLIST_N_WHO, pixmap, NULL);

		l = LIST_NEXT(l);
		row ++;
	}
	while (linesindisplay > row)
		gtk_clist_remove(GTK_CLIST(clist), --linesindisplay);

	gtk_clist_thaw(GTK_CLIST(clist));

	return TEG_STATUS_SUCCESS;
}

/**
 * @fn TEG_STATUS status_update()
 */
TEG_STATUS status_update()
{
	if( status_dialog != NULL)
		status_fill_clist( status_clist );

	return TEG_STATUS_SUCCESS;
}

TEG_STATUS ministatus_update()
{
	if( ministatus == NULL )
		return TEG_STATUS_ERROR;

	gtk_widget_draw( ministatus, NULL);

	return TEG_STATUS_SUCCESS;
}

/**
 * @fn TEG_STATUS_SUCCESS ministatus_update()
 */
static gint ministatus_expose_cb(GtkWidget *area, GdkEventExpose *event, gpointer user_data)
{
	static GdkGC *ms_gc = NULL;
	int i=0;

	if( area == NULL )
		return FALSE;

	if( area->window == NULL )
		return FALSE;;

	if( ms_gc == NULL )
		ms_gc = gdk_gc_new(area->window);

	if( ESTADO_GET() == JUG_ESTADO_DESCONECTADO || g_juego.observer )
		i = -1;
	else
		i = g_juego.numjug;

	gdk_gc_set_foreground(ms_gc, colors_get_player(i));
	gdk_draw_arc( area->window, ms_gc, TRUE, 0, 3, 10, 10, 0, 360 * 64);

	gdk_gc_set_foreground(ms_gc, colors_get_common(COLORS_BLACK));
	gdk_draw_arc( area->window, ms_gc, FALSE, 0, 3, 10, 10, 0, 360* 64);

	return FALSE;
}

/**
 * @fn GtkWidget *ministatus_build()
 */
GtkWidget *ministatus_build()
{
	if( ministatus == NULL ) {
		ministatus = gtk_drawing_area_new();

		gtk_signal_connect(GTK_OBJECT(ministatus), "expose_event",
			   GTK_SIGNAL_FUNC(ministatus_expose_cb), NULL);
	}
	gtk_widget_set_usize(ministatus, 15, -1);
	gtk_widget_show( ministatus );

	return ministatus;
}


/*
 * Main Status
 */

/**
 * @fn TEG_STATUS mainstatus_create( GtkWidget **window )
 * Creates the widget for the Main Status
 */

#define MAINSTATUS_X (150)
#define MAINSTATUS_Y (30)
TEG_STATUS mainstatus_create( GtkWidget **window )
{
	GtkWidget *r_hbox;
	GtkWidget *table;
	GtkWidget *label;
	GtkWidget* canvas;
	GnomeCanvasItem *item;

	r_hbox = gtk_hbox_new( FALSE, 0 );
	if (!r_hbox) goto error;


	canvas = gnome_canvas_new();
	gtk_widget_set_usize (canvas, MAINSTATUS_X, MAINSTATUS_Y );
	gnome_canvas_set_scroll_region (GNOME_CANVAS (canvas), 0, 0, MAINSTATUS_X, MAINSTATUS_Y);

	item = gnome_canvas_item_new(
		gnome_canvas_root(GNOME_CANVAS(canvas)),
		gnome_canvas_rect_get_type (),
		"x1", 0.0,
		"y1", 0.0,
		"x2", (double) MAINSTATUS_X,
		"y2", (double) MAINSTATUS_Y,
		"fill_color","light green",
		"outline_color","black",
		NULL);


	item = gnome_canvas_item_new(
		gnome_canvas_root(GNOME_CANVAS(canvas)),
		gnome_canvas_text_get_type(),
		"text","Testing",
		"x", (double) (MAINSTATUS_X/2),
		"y", (double) (MAINSTATUS_Y/2),
		"x_offset", (double) -1,
		"y_offset", (double) -1,
		"font", HELVETICA_14_BFONT,
		"fill_color", "black",
		"anchor",GTK_ANCHOR_CENTER,
		NULL);

	gtk_widget_show (canvas);
	gtk_container_add( GTK_CONTAINER(r_hbox), canvas);


	table = gtk_table_new (2, 3, TRUE);
	if (!table) goto error;

	gtk_container_border_width (GTK_CONTAINER (table), 0);
	gtk_table_set_row_spacings (GTK_TABLE (table), 0);
	gtk_table_set_col_spacings (GTK_TABLE (table), 0);

#ifdef I_DONT_CARE_THE_ORDER
	{
		int i,x,y;
		for(i=0,x=0;i<CONT_CANT;x++) {
			for(y=0;y<2 && i<CONT_CANT;y++) {
				label = gtk_label_new( _(g_conts[i].nombre) );
				gtk_table_attach_defaults( GTK_TABLE(table), label, 0+x, 1+x, (0+y)%2, ((0+y)%2)+1 );

				i++;
			}
		}
	}
#else
	label = gtk_label_new( _( g_conts[CONTINENTE_AMERICANORTE].nombre) );
	gtk_table_attach_defaults( GTK_TABLE(table), label, 0, 1, 0, 1 );
	label = gtk_label_new( _( g_conts[CONTINENTE_AMERICASUR].nombre) );
	gtk_table_attach_defaults( GTK_TABLE(table), label, 0, 1, 1, 2 );

	label = gtk_label_new( _( g_conts[CONTINENTE_EUROPA].nombre) );
	gtk_table_attach_defaults( GTK_TABLE(table), label, 1, 2, 0, 1 );
	label = gtk_label_new( _( g_conts[CONTINENTE_AFRICA].nombre) );
	gtk_table_attach_defaults( GTK_TABLE(table), label, 1, 2, 1, 2 );

	label = gtk_label_new( _( g_conts[CONTINENTE_ASIA].nombre) );
	gtk_table_attach_defaults( GTK_TABLE(table), label, 2, 3, 0, 1 );
	label = gtk_label_new( _( g_conts[CONTINENTE_OCEANIA].nombre) );
	gtk_table_attach_defaults( GTK_TABLE(table), label, 2, 3, 1, 2 );


#endif

	gtk_container_add( GTK_CONTAINER(r_hbox), table );

	gtk_widget_show_all(r_hbox);

	*window = r_hbox;
	return TEG_STATUS_SUCCESS;

error:
	return TEG_STATUS_ERROR;
}
