#!/bin/sh

########################################################################
#
#  Convert an rtf document to PostScript format using 'Ted'.
#
#  Usage	rtf2ps.sh --paper paper something.rtf something.ps
#  Or		rtf2ps.sh something.rtf something.ps
#
#  Valid values for paper are a4, a5, a6, letter, legal and executive
#
#  This is an example. Refer to http://www.nllgg.nl/Ted/index.html for the
#  'Ted' documentation.
#
#  If you want 'Ted' to set configurable resources, use
#  Ted  --printToFilePaper --setProperty ... in the Ted way. E.G:
#  Ted  --setProperty usePostScriptFilters 1 \
#	--setProperty usePostScriptIndexedImages 1  \
#	--setProperty afmDirectory /usr/share/ghostscript/fonts  \
#	--setProperty fontDirectory /usr/share/ghostscript/fonts  \
#	--setProperty ghostscriptFontmap \
#				/usr/share/ghostscript/6.53/lib/Fontmap \
#	--setProperty ghostscriptFontToXmapping \
#				/usr/share/ghostscript/6.53/lib/fonts.dir \
#	--printToFilePaper .....
#  This has the advantage over the ++printToFilePaper call and X11 
#  resource settings with -xrm Ted.usePostScriptFilters:1 style arguments 
#  that it does not require an X11 server.
#  The settings can also be stored in /etc/Ted.properties or in 
#  $(HOME)/.Ted.properies files. Refer to the Ted documentation for 
#  more details.
#
########################################################################

PAPER=

case $# in
    2)
	;;
    4)
	case $1 in
	    --paper)
		;;
	    *)
		echo $0: '$1='$1 'Expected --paper'
		exit 1
		;;
	esac

	case $2 in
	    a4|a5|a6|letter|legal|executive)
		PAPER=$2
		;;
	    *)
		echo $0: '$2='$2 'Expected a4|a5|a6|letter|legal|executive'
		exit 1
		;;
	esac
	shift; shift;
	;;
    *)
	echo $0: '$#='$#
	exit 1
	;;
esac

case $PAPER in
    ?*)
	Ted --printToFilePaper "$1" "$2" $PAPER
	;;
    *)
	Ted --printToFile "$1" "$2"
	;;
esac

