/************************************************************************/
/*									*/
/*  A Format Tool.							*/
/*									*/
/************************************************************************/

#   include	"tedConfig.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<stddef.h>
#   include	<limits.h>

#   include	<appDebugon.h>

#   include	<appGeoString.h>
#   include	<appUnit.h>

#   include	"tedApp.h"
#   include	"tedFormatTool.h"

/************************************************************************/
/*									*/
/*  Refresh the 'Column' page of the format tool.			*/
/*									*/
/************************************************************************/

static void tedFormatToolRefreshColumnPage(	ColumnTool *	ct )
    {
    RowProperties *		rp= &(ct->ctPropertiesChosen);
    CellProperties *		cp;
    const TableRectangle *	tr= &(ct->ctTableRectangle);

    int				width;
    char			scratch[50];

    appIntegerToTextWidget( ct->ctNumberText, tr->trCol0+ 1 );

    if  ( tr->trCol0 == 0 )
	{
	width= rp->rpCells[tr->trCol0  ].cpRightBoundaryTwips-
						    rp->rpLeftIndentTwips;
	}
    else{
	width= rp->rpCells[tr->trCol0  ].cpRightBoundaryTwips-
			    rp->rpCells[tr->trCol0-1].cpRightBoundaryTwips;
	}

    appGeoLengthToString( scratch, width, UNITtyPOINTS );
    appStringToTextWidget( ct->ctWidthText, scratch );

    cp= rp->rpCells;

    tedFormatReflectBorder( &(ct->ctLeftBorderTool),
					&(cp[tr->trCol0].cpLeftBorder) );
    tedFormatReflectBorder( &(ct->ctRightBorderTool),
					&(cp[tr->trCol0].cpRightBorder) );
    }

void tedFormatToolRefreshColumnTool(
				ColumnTool *			ct,
				int *				pEnabled,
				InspectorSubject *		is,
				const DocumentSelection *	ds )
    {
    const RowProperties *	rp;
    const DocumentGeometry *	dg;

    const BufferItem *		rowBi;
    const BufferItem *		sectBi;

    TableRectangle *		tr= &(ct->ctTableRectangle);

    if  ( tedGetTableRectangle( tr, ds )	||
	  tr->trCol1 != tr->trCol0		)
	{
	docInitTableRectangle( tr );
	*pEnabled= 0; return;
	}

    rowBi= ds->dsBegin.dpBi;
    rowBi= rowBi->biParent;
    rowBi= rowBi->biParent;
    sectBi= rowBi->biParent;

    dg= &(sectBi->biSectDocumentGeometry);

    ct->ctPageRight= dg->dgPageWideTwips-
			    dg->dgLeftMarginTwips- dg->dgRightMarginTwips;
    ct->ctPageLeftMargin= dg->dgLeftMarginTwips;

    rp= &(rowBi->biRowProperties);

    if  ( docCopyRowProperties( &(ct->ctPropertiesChosen), rp ) )
	{ LDEB(1); return;	}
    if  ( docCopyRowProperties( &(ct->ctPropertiesSet), rp ) )
	{ LDEB(1); return;	}

    appGuiEnableWidget( is->isPrevButton,
				ct->ctTableRectangle.trCol0 > 0 );
    appGuiEnableWidget( is->isNextButton,
				ct->ctTableRectangle.trCol1 <
				ct->ctTableRectangle.trCol11 );

    tedFormatToolRefreshColumnPage( ct );

    appGuiEnableWidget( is->isDeleteButton, rp->rpCellCount > 1 );

    *pEnabled= 1;
    return;
    }

static int tedFormatToolGetColumnWidth(	const RowProperties *	rp,
					int			col0,
					int			pageRight,
					int *			pValue,
					int *			pShift,
					APP_WIDGET		w )
    {
    int				width;
    int				changed;

    const CellProperties *	cp= &(rp->rpCells[col0]);
    int				rightRight;

    int				right;
    int				d;

    const int			minValue= 1;
    const int			adaptToMin= 0;
    const int			maxValue= INT_MAX;
    const int			adaptToMax= 0;
    
    right= cp->cpRightBoundaryTwips;
    if  ( col0 == 0 )
	{ width= right- rp->rpLeftIndentTwips;		}
    else{ width= right- cp[-1].cpRightBoundaryTwips;	}

    if  ( appGetLengthFromTextWidget( w, &width, &changed, UNITtyPOINTS,
				minValue, adaptToMin, maxValue, adaptToMax ) )
	{ return -1; }

    if  ( col0 == 0 )
	{ right= rp->rpLeftIndentTwips+ width;		}
    else{ right= cp[-1].cpRightBoundaryTwips+ width;	}

    d= right- cp->cpRightBoundaryTwips;

    rightRight= rp->rpCells[rp->rpCellCount-1].cpRightBoundaryTwips;
    rightRight -= rp->rpHalfGapWidthTwips;

    if  ( rightRight+ d >= pageRight )
	{
	char		scratch[50];

	d= pageRight- rightRight;
	right= cp->cpRightBoundaryTwips+ d;

	if  ( col0 == 0 )
	    { width= right- rp->rpLeftIndentTwips;		}
	else{ width= right- cp[-1].cpRightBoundaryTwips;	}

	width -= 10;

	if  ( width <= 0 )
	    { appRefuseTextValue( w ); return -1;	}

	appGeoLengthToString( scratch, width, UNITtyPOINTS );
	appStringToTextWidget( w, scratch );
	appRefuseTextValue( w );
	return 1;
	}

    *pValue= width; *pShift= d; return 0;
    }

/************************************************************************/
/*									*/
/*  Set/Revert buttons have been pushed.				*/
/*									*/
/************************************************************************/

static void tedTableChangeColumnPushed(	APP_WIDGET	w,
					void *		voidct,
					void *		voidpbcs	 )
    {
    ColumnTool *		ct= (ColumnTool *)voidct;
    RowProperties *		rp= &(ct->ctPropertiesChosen);
    const TableRectangle *	tr= &(ct->ctTableRectangle);
    CellProperties *		cp= &(rp->rpCells[tr->trCol0]);

    int				col;

    int				d;
    int				width;
    int				res;

    TableRectangle		trChange;

    res= tedFormatToolGetColumnWidth( rp, tr->trCol0,
			    ct->ctPageRight, &width, &d, ct->ctWidthText );
    if  ( res != 0 )
	{ return;	}

    if  ( tedBorderToolGetWidth( &(ct->ctLeftBorderTool),
						&(cp->cpLeftBorder) ) )
	{ return;	}

    if  ( tedBorderToolGetWidth( &(ct->ctRightBorderTool),
						&(cp->cpRightBorder) ) )
	{ return;	}

    for ( col= tr->trCol0; col < rp->rpCellCount; cp++, col++ )
	{ cp->cpRightBoundaryTwips += d; }

    trChange= *tr;
    docExpandTableRectangleToWholeColumns( &trChange );

    tedAppSetTableProperties( ct->ctApplication, &trChange, rp );

    return;
    }

static void tedFormatRevertColumnPushed(	APP_WIDGET	w,
						void *		voidct,
						void *		voidpbcs )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;

    docCopyRowProperties( &(ct->ctPropertiesChosen), &(ct->ctPropertiesSet) );

    tedFormatToolRefreshColumnPage( ct );

    return;
    }

/************************************************************************/
/*									*/
/*  A border style has been chosen.					*/
/*									*/
/************************************************************************/

static void tedColumnBorderStyleChosen(	APP_WIDGET	w,
					void *		voidct,
					void *		voidtbcs )
    {
    ColumnTool *		ct= (ColumnTool *)voidct;
    RowProperties *		rp= &(ct->ctPropertiesChosen);
    const TableRectangle *	tr= &(ct->ctTableRectangle);
    CellProperties *		cp= &(rp->rpCells[tr->trCol0]);

    if  ( ! tedBorderToolGetStyle( &(ct->ctLeftBorderTool),
						&(cp->cpLeftBorder), w ) )
	{ return;	}

    if  ( ! tedBorderToolGetStyle( &(ct->ctRightBorderTool),
						&(cp->cpRightBorder), w ) )
	{ return;	}

    XDEB(w); return;
    }

/************************************************************************/
/*									*/
/*  Check a number as typed by the user.				*/
/*									*/
/************************************************************************/

static void tedColumnWidthChanged(	APP_WIDGET	w,
					void *		voidct,
					void *		voidpbcs )
    {
    ColumnTool *		ct= (ColumnTool *)voidct;
    RowProperties *		rp= &(ct->ctPropertiesChosen);
    const TableRectangle *	tr= &(ct->ctTableRectangle);

    int				d;
    int				width;

    if  ( ! tedFormatToolGetColumnWidth( rp, tr->trCol0,
			    ct->ctPageRight, &width, &d, ct->ctWidthText ) )
	{
	char	scratch[50];

	appGeoLengthToString( scratch, width, UNITtyPOINTS );

	appStringToTextWidget( ct->ctWidthText, scratch );
	}
    }

/************************************************************************/
/*									*/
/*  Previous/Next Column/Row buttons have been pushed.			*/
/*									*/
/************************************************************************/

static void tedColumnPreviousColumn(	APP_WIDGET	w,
					void *		voidct,
					void *		voidpbcs	 )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    EditApplication *	ea= ct->ctApplication;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;

    TableRectangle	tr;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tr= ct->ctTableRectangle;
    td= (TedDocument *)ed->edPrivateData;

    docExpandTableRectangleToWholeColumns( &tr );

    if  ( docShiftTableRectangleByColumns( &tr, -1 ) )
	{ return;	}

    tedAppSetTableSelection( ed, &tr );

    return;
    }

static void tedTableSelectColumn(	APP_WIDGET	w,
					void *		voidct,
					void *		voidpbcs	 )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    EditApplication *	ea= ct->ctApplication;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;

    TableRectangle	tr;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tr= ct->ctTableRectangle;
    td= (TedDocument *)ed->edPrivateData;

    docExpandTableRectangleToWholeColumns( &tr );

    tedAppSetTableSelection( ed, &tr );

    return;
    }

static void tedColumnNextColumn(		APP_WIDGET	w,
					void *		voidct,
					void *		voidpbcs	 )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    EditApplication *	ea= ct->ctApplication;
    EditDocument *	ed= ea->eaCurrentDocument;
    TedDocument *	td;

    TableRectangle	tr;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tr= ct->ctTableRectangle;
    td= (TedDocument *)ed->edPrivateData;

    docExpandTableRectangleToWholeColumns( &tr );

    if  ( docShiftTableRectangleByColumns( &tr, +1 ) )
	{ return;	}

    tedAppSetTableSelection( ed, &tr );

    return;
    }

/************************************************************************/
/*									*/
/*  Delete Column/Row/Table buttons have been pushed.			*/
/*									*/
/************************************************************************/

static void tedTableDeleteColumn(	APP_WIDGET	w,
					void *		voidct,
					void *		voidpbcs	 )
    {
    ColumnTool *		ct= (ColumnTool *)voidct;
    const TableRectangle *	tr= &(ct->ctTableRectangle);
    EditApplication *		ea= ct->ctApplication;
    EditDocument *		ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    if  ( tedDeleteColumnsFromRows( ed,
		tr->trRow00, tr->trRow11, tr->trCol0, tr->trCol1 ) )
	{ LLDEB(tr->trRow00,tr->trRow11); return;	}

    appDocumentChanged( ed, 1 );

    return;
    }

/************************************************************************/
/*									*/
/*  Insert/Append Column/Row buttons have been pushed.			*/
/*									*/
/************************************************************************/

static void tedTableInsertColumn(	APP_WIDGET	w,
					void *		voidct,
					void *		voidpbcs	 )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    EditApplication *	ea= ct->ctApplication;

    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedInsertColumnInTable( ed );

    appDocumentChanged( ed, 1 );
    }

static void tedTableAppendColumn(	APP_WIDGET	w,
					void *		voidct,
					void *		voidpbcs	 )
    {
    ColumnTool *	ct= (ColumnTool *)voidct;
    EditApplication *	ea= ct->ctApplication;

    EditDocument *	ed= ea->eaCurrentDocument;

    if  ( ! ed )
	{ XDEB(ed); return;	}

    tedAppendColumnToTable( ed );

    appDocumentChanged( ed, 1 );
    }

/************************************************************************/
/*									*/
/*  One of the 'Column Border' toggles has been activated.		*/
/*									*/
/************************************************************************/

static void tedColumnToggleBorder(	APP_WIDGET	w,
					void *		voidct,
					void *		voidtbcs )
    {
    ColumnTool *		ct= (ColumnTool *)voidct;
    RowProperties *		rp= &(ct->ctPropertiesChosen);
    const TableRectangle *	tr= &(ct->ctTableRectangle);
    CellProperties *		cp= &(rp->rpCells[tr->trCol0]);

    int				set;

    const int			influenceStyleMenu= 1;

    set= appGuiGetToggleStateFromCallback( w, voidtbcs );

    if  ( w == ct->ctLeftBorderTool.btOnOffToggle )
	{
	tedFormatToggleBorder( &(cp->cpLeftBorder), &(ct->ctLeftBorderTool),
						    influenceStyleMenu, set );
	return;
	}

    if  ( w == ct->ctRightBorderTool.btOnOffToggle )
	{
	tedFormatToggleBorder( &(cp->cpRightBorder), &(ct->ctRightBorderTool),
						    influenceStyleMenu, set );
	return;
	}

    XDEB(w); return;
    }

/************************************************************************/
/*									*/
/*  Make a column tool, I.E. the 'Column' page of the format tool.	*/
/*									*/
/************************************************************************/

void tedFormatFillColumnPage(	ColumnTool *			ct,
				const ColumnPageResources *	cpr,
				InspectorSubject *		is,
				APP_WIDGET			pageWidget,
				const InspectorSubjectResources * isr )
    {
    APP_WIDGET	widthLabel;
    APP_WIDGET	columnLabel;

    APP_WIDGET	row= (APP_WIDGET)0;

    const int	textColumns= 10;

    /**/
    ct->ctPageResources= cpr;

    /**/

    docInitTableRectangle( &(ct->ctTableRectangle) );

    docInitRowProperties( &(ct->ctPropertiesSet) );
    docInitRowProperties( &(ct->ctPropertiesChosen) );

    /**/
    appMakeLabelAndTextRow( &row, &columnLabel, &(ct->ctNumberText),
			    pageWidget, isr->isrSubjectName, textColumns, 0 );

    appMakeLabelAndTextRow( &row, &widthLabel, &(ct->ctWidthText),
			pageWidget, cpr->cprWidth, textColumns, 1 );

    appGuiSetGotValueCallbackForText( ct->ctWidthText,
					tedColumnWidthChanged, (void *)ct );

    tedFormatMakeBorderTool( &(ct->ctLeftBorderTool), &row, pageWidget,
		    cpr->cprLeftBorder, tedColumnToggleBorder, (void *)ct );

    tedFormatMakeBorderTool( &(ct->ctRightBorderTool), &row, pageWidget,
		    cpr->cprRightBorder, tedColumnToggleBorder, (void *)ct );

    appInspectorMakeButtonRow( &row, pageWidget,
		    &(is->isPrevButton), &(is->isNextButton),
		    isr->isrPrevButtonText, isr->isrNextButtonText,
		    tedColumnPreviousColumn, tedColumnNextColumn, ct );

    appInspectorMakeButtonRow( &row, pageWidget,
		    &(is->isSelectButton), &(is->isDeleteButton),
		    isr->isrSelectButtonText, isr->isrDeleteButtonText,
		    tedTableSelectColumn, tedTableDeleteColumn, ct );

    appInspectorMakeButtonRow( &row, pageWidget,
		    &(is->isInsertButton), &(is->isAppendButton),
		    isr->isrInsertButtonText, isr->isrAppendButtonText,
		    tedTableInsertColumn, tedTableAppendColumn, ct );

    appInspectorMakeButtonRow( &row, pageWidget,
		    &(is->isRevertButton), &(is->isApplyButton),
		    isr->isrRevert, isr->isrApplyToSubject,
		    tedFormatRevertColumnPushed, tedTableChangeColumnPushed,
		    (void *)ct );

    return;
    }

void tedFormatFillColumnChoosers(	ColumnTool *			ct,
					const ColumnPageResources *	cpr )
    {
    tedFormatFillBorderTool( &(ct->ctLeftBorderTool),
				    tedColumnBorderStyleChosen, (void *)ct );
    tedFormatFillBorderTool( &(ct->ctRightBorderTool),
				    tedColumnBorderStyleChosen, (void *)ct );
    return;
    }

void tedFormatFinishColumnPage(		ColumnTool *			ct,
					TedFormatTool *			tft,
					const ColumnPageResources *	cpr )
    {
    tedFormatFinishBorderTool( &(ct->ctLeftBorderTool), tft );
    tedFormatFinishBorderTool( &(ct->ctRightBorderTool), tft );
    }

/************************************************************************/
/*									*/
/*  Get column tool resources.						*/
/*									*/
/************************************************************************/

static AppConfigurableResource TED_TedColumnSubjectResourceTable[]=
    {
    APP_RESOURCE( "tableToolColumn",
		offsetof(InspectorSubjectResources,isrSubjectName),
		"Column" ),
    APP_RESOURCE( "tableToolChangeColumn",
		offsetof(InspectorSubjectResources,isrApplyToSubject),
		"Apply to Column" ),
    APP_RESOURCE( "tableToolRevert",
		offsetof(InspectorSubjectResources,isrRevert),
		"Revert" ),
    APP_RESOURCE( "tableToolNextColumn",
		offsetof(InspectorSubjectResources,isrNextButtonText),
		"Next Column" ),
    APP_RESOURCE( "tableToolPreviousColumn",
		offsetof(InspectorSubjectResources,isrPrevButtonText),
		"Previous Column" ),
    APP_RESOURCE( "tableToolSelectColumn",
		offsetof(InspectorSubjectResources,isrSelectButtonText),
		"Select Column" ),
    APP_RESOURCE( "tableToolDeleteColumn",
		offsetof(InspectorSubjectResources,isrDeleteButtonText),
		"Delete Column" ),
    APP_RESOURCE( "tableToolInsertColumn",
		offsetof(InspectorSubjectResources,isrInsertButtonText),
		"Insert Column" ),
    APP_RESOURCE( "tableToolAppendColumn",
		offsetof(InspectorSubjectResources,isrAppendButtonText),
		"Append Column" ),
    };

static AppConfigurableResource TED_TedColumnToolResourceTable[]=
    {
    APP_RESOURCE( "tableToolWidth",
		offsetof(ColumnPageResources,cprWidth),
		"Width" ),
    APP_RESOURCE( "tableToolColumnLeftBorder",
		offsetof(ColumnPageResources,cprLeftBorder),
		"Left Border" ),
    APP_RESOURCE( "tableToolColumnRightBorder",
		offsetof(ColumnPageResources,cprRightBorder),
		"Right Border" ),
    };

void tedFormatToolGetColumnResourceTable(EditApplication *		ea,
					ColumnPageResources *		cpr,
					InspectorSubjectResources *	isr )
    {
    appGuiGetResourceValues( ea, (void *)cpr,
				TED_TedColumnToolResourceTable,
				sizeof(TED_TedColumnToolResourceTable)/
				sizeof(AppConfigurableResource) );

    appGuiGetResourceValues( ea, (void *)isr,
				TED_TedColumnSubjectResourceTable,
				sizeof(TED_TedColumnSubjectResourceTable)/
				sizeof(AppConfigurableResource) );

    return;
    }
