/************************************************************************/
/*									*/
/*  Text Buffer: Obects inserted in the text.				*/
/*  Objects are independent entities that are embedded in the text.	*/
/*									*/
/************************************************************************/

#   ifndef	DOC_OBJECT_H
#   define	DOC_OBJECT_H

#   include	<utilMemoryBuffer.h>

struct BufferDocument;
struct BufferItem;
struct TextParticule;

/************************************************************************/
/*									*/
/*  Kinds of object.							*/
/*									*/
/************************************************************************/

typedef enum ObjectKind
    {
    DOCokUNKNOWN= 0,

    DOCokPICTWMETAFILE,
    DOCokPICTPNGBLIP,
    DOCokPICTJPEGBLIP,
    DOCokPICTEMFBLIP,
    DOCokMACPICT,
    DOCokOLEOBJECT,

    DOCokINCLUDEPICTURE,
    DOCokEPSF,
	    /************************************************************/
	    /*  To include pictures. In Particular EPS pictures. As	*/
	    /*  this is different from what 'Word' does, they are not	*/
	    /*  saved in the RTF file.					*/
	    /************************************************************/

    DOCok__COUNT
    } ObjectKind;

typedef struct InsertedObject
    {
    int			ioKind;		/*  Kind of object.		*/
    int			ioResultKind;	/*  Kind of object.		*/
    int			ioTwipsWide;	/*  Width of object.		*/
    int			ioTwipsHigh;	/*  Height of object.		*/
    int			ioScaleX;	/*  In %.			*/
    int			ioScaleY;	/*  In %.			*/
    int			ioPixelsWide;	/*  Width of object on screen	*/
    int			ioPixelsHigh;	/*  Height of object on screen	*/
    int			io_xWinExt;	/*  Of metafile picture.	*/
    int			io_yWinExt;	/*  Of metafile picture.	*/
    int			ioUnitsPerInch;	/*  Only use if > 0		*/

    int			ioTopCropTwips;
    int			ioBottomCropTwips;
    int			ioLeftCropTwips;
    int			ioRightCropTwips;

    int			ioDragWide;	/*  PixelsWide during resize.	*/
    int			ioDragHigh;	/*  PixelsHigh during resize.	*/

    int			ioMapMode;
    int			ioResultMapMode;
					/*  Used for metafile pictures	*/
					/*  or objects with a result	*/
					/*  that is a metafile picture.	*/
    MemoryBuffer	ioObjectData;
    MemoryBuffer	ioResultData;

    unsigned char *	ioObjectName;
    unsigned char *	ioObjectClass;
    int			ioBliptag;

#   ifdef USE_MOTIF
    unsigned long	ioPixmap;
#   endif

#   ifdef USE_GTK
    void *		ioPixmap;
#   endif

    void *		ioPrivate;
    } InsertedObject;

typedef void (*DOC_CLOSE_OBJECT)(	struct BufferDocument *	bd,
					struct BufferItem *	bi,
					struct TextParticule *	tp,
					void *			voidadd );

/************************************************************************/
/*									*/
/*  Routine declarations.						*/
/*									*/
/************************************************************************/

extern int docGetBitmapForObject(	InsertedObject *	io );

extern int docObjectSetData(	InsertedObject *	io,
				const unsigned char *	bytes,
				int			size );

extern int docSetResultData(	InsertedObject *	io,
				const unsigned char *	bytes,
				int			size );

extern int docSaveObjectTag(	InsertedObject *	io,
				const char *		tag,
				int			arg );

extern int docSaveResultTag(	InsertedObject *	io,
				const char *		tag,
				int			arg );

extern int docSetObjectName(	InsertedObject *	io,
				const unsigned char *	name,
				int			len );

extern int docSetObjectClass(	InsertedObject *	io,
				const unsigned char *	name,
				int			len );

extern void docCleanObject(	InsertedObject *	io );

#   endif	/*  DOC_OBJECT_H	*/
