/*
 * syslog.c - POSIX syslog replacement that does nothing
 * $Id: syslog.c,v 1.3 2003/01/26 09:09:08 rdenisc Exp $
 */

/***********************************************************************
 *  Copyright (C) 2002-2003 Rmi Denis-Courmont.                       *
 *  This program is free software; you can redistribute and/or modify  *
 *  it under the terms of the GNU General Public License as published  *
 *  by the Free Software Foundation; version 2 of the license.         *
 *                                                                     *
 *  This program is distributed in the hope that it will be useful,    *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.               *
 *  See the GNU General Public License for more details.               *
 *                                                                     *
 *  You should have received a copy of the GNU General Pulic License   *
 *  along with this program; if not, you can get it from:              *
 *  http://www.gnu.org/copyleft/gpl.html                               *
 ***********************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#if! HAVE_SYSLOG
# include <stdio.h>

void openlog (const char *ident, int option, int facility)
{
	fprintf (stderr,
		"WARNING: no system logging available for %s\n"
		"(requested facility number %d, option=0x%x)\n"
		"Any further logging information will be dropped.\n",
		ident, facility, option);
}
	
void
syslog (int priority, char *fmt, ... )
{
}

void closelog (void)
{
}

# if 0
# include <stdarg.h>
void
vsyslog (int priority, char *fmt, va_list ap)
{
}
# endif
#endif

