'\"
'\" Generated from file 'rest\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "rest" n 1\&.0\&.1 tcllib "A framework for RESTful web services"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
rest \- define REST web APIs and call them inline or asychronously
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBrest  ?1\&.0\&.1?\fR
.sp
\fB::rest::simple\fR \fIurl\fR \fIquery\fR ?config? ?body?
.sp
\fB::rest::get\fR \fIurl\fR \fIquery\fR ?config? ?body?
.sp
\fB::rest::post\fR \fIurl\fR \fIquery\fR ?config? ?body?
.sp
\fB::rest::head\fR \fIurl\fR \fIquery\fR ?config? ?body?
.sp
\fB::rest::put\fR \fIurl\fR \fIquery\fR ?config? ?body?
.sp
\fB::rest::delete\fR \fIurl\fR \fIquery\fR ?config? ?body?
.sp
\fB::rest::save\fR \fIname\fR \fIfile\fR
.sp
\fB::rest::describe\fR \fIname\fR
.sp
\fB::rest::parameters\fR \fIurl\fR ?args?
.sp
\fB::rest::parse_opts\fR \fIstatic\fR \fIrequired\fR \fIoptional\fR \fIstring\fR
.sp
\fB::rest::substitute\fR \fIstring\fR ?var?
.sp
\fB::rest::create_interface\fR \fIname\fR
.sp
describe
.sp
uplevel token token
.sp
upvar body body
.sp
uplevel token token
.sp
uplevel token token
.sp
.BE
.SH DESCRIPTION
.PP
There are 2 types of usage this package supports: simple calls, and complete interfaces\&. In an interface you specify a set of rules and then the package builds commands which correspond to the REST methods\&. These commands can have many options such as input and output transformations and data type specific formatting\&. This results in a cleaner and simpler script\&. On the other hand, a simple call is easier and quicker to implement but less featureful\&. It takes the url and a few options on the command and returns the result directly\&. Any formatting or checking is up to rest of the script\&.
Simple usage
In simple usage you make calls using http method procedures and then check or process the returned data yourself
.TP
\fB::rest::simple\fR \fIurl\fR \fIquery\fR ?config? ?body?
.TP
\fB::rest::get\fR \fIurl\fR \fIquery\fR ?config? ?body?
.TP
\fB::rest::post\fR \fIurl\fR \fIquery\fR ?config? ?body?
.TP
\fB::rest::head\fR \fIurl\fR \fIquery\fR ?config? ?body?
.TP
\fB::rest::put\fR \fIurl\fR \fIquery\fR ?config? ?body?
.TP
\fB::rest::delete\fR \fIurl\fR \fIquery\fR ?config? ?body?
.PP
The above commands are all equivalent except for the http method used\&. If you use \fBsimple\fR then the method should be specified as an option in the ?config? dict, otherwise it defaults to \fBget\fR\&. If a body is needed then the config dict must be present, however it may be empty\&.
.CS


    set appid APPID
    set search tcl
    set res [rest::get http://boss\&.yahooapis\&.com/ysearch/web/v1/$search [list appid $appid]]
    set res [rest::format_json $res]

.CE
.CS


    set res [rest::simple http://twitter\&.com/statuses/update\&.json  [list status $text]  {
          method post
          auth {basic user password}
          format json
        }
    ]

.CE
the options supported in the config dict are as follows
headers
cookie
auth
format
method
content-type
Interface usage
An interface to a REST API consists of a series of definitions of REST calls contained in an array\&. The array name becomes a namespace containing the defined commands\&. Each array element defines the name of the call and takes the form of a dict, aka key/value pairs\&. These keys are the defined configuration options below\&.
After creating the definitions simply call rest::create_interface on the array to create the commands\&.
.CS


package require rest

set yweather(forecast) {
   url http://weather\&.yahooapis\&.com/forecastrss
   req_args { p: }
   opt_args { u: }
}

rest::create_interface yweather

puts [yweather::forecast -p 94089]

.CE
::${name}::basic_auth \fIu\fR \fIp\fR
::${name}::set_static_args ?args?]
.TP
\fB::rest::save\fR \fIname\fR \fIfile\fR
saves a copy of the dynamically created procs to a file for later loading
.TP
\fB::rest::describe\fR \fIname\fR
print a description of defined api calls
.TP
\fB::rest::parameters\fR \fIurl\fR ?args?
parse a url query string into a dict
.TP
\fB::rest::parse_opts\fR \fIstatic\fR \fIrequired\fR \fIoptional\fR \fIstring\fR
.TP
\fB::rest::substitute\fR \fIstring\fR ?var?
take a string and substitute real values for any option identifiers
.TP
\fB::rest::create_interface\fR \fIname\fR
TOKENS
the value is substituted into the url at call time\&. tokens in the form of %name:default_value% will be an optional argument with a default value\&.
url
the target of the http request
description
a string which describes the call\&. used only for
.TP
describe
body
indicates if arguments are required for the request body or not\&. should
be one of none, optional, required, argument or mime_multipart\&. default is optional\&.
if \fBargument\fR is used then the option is parsed as a list where the second value is the name
of a option\&. the body will then be used as the value for that option\&.
if the value is \fBmime_multipart\fR then the body is required and interpreted as each argument
representing one part of a mime multipart document\&. each argument should be a 2 item list with the first being
a list of header keys and values, and the second being the mime part body\&.
.CS


set ygeo(parse) {
    url http://wherein\&.yahooapis\&.com/v1/document
    method post
    body { arg documentContent }
}
ygeo::parse "san jose ca"
# "san jose ca" will be interpreted as if it were specified as the -documentContent option

.CE
.CS


set gdocs(upload) {
    url http://docs\&.google\&.com/feeds/default/private/full
    body mime_multipart
}
gdocs::upload [list {Content-Type application/atom+xml} $xml] [list {Content-Type image/jpeg} $filedata]

.CE
.IP
method
The HTTP method to call on the url\&. The default is GET\&.
copy
this copies the definition of a previously defined call\&. after copying you can override selected options by defining them again\&.
unset
removes the named option\&. useful when using copy of another definition\&.
headers
the value must be another dict containing header fields and their values\&. The default is to not add any additional headers\&.
content-type
Specifies the content type for the request data\&.
req_args
a list of the required arguments\&. names ending in a colon will require a value\&.
opt_args
arguments that may be present but are not required\&.
static_args
arguments that are always the same\&. no sense in troubling the user with these\&. A leading - is allowed but not required to maintain consistancy with the command line\&.
auth
should be one of basic or sign\&. if basic is used you can configure basic auth with the proc auth_basic which takes 2 arguments, the username and password\&.
if sign is specified then the value must be a list with the second element being the name of a proc which will be called to perform the request signing\&.
.CS


set delicious(updated) {
    url https://api\&.del\&.icio\&.us/v1/posts/update
    auth basic
}

rest::create_interface flickr

flickr::basic_auth username password

.CE
.CS


set flickr(auth\&.getToken) {
   url http://api\&.flickr\&.com/services/rest/
   req_args { api_key: secret: }
   auth { sign do_signature }
}

rest::create_interface flickr

proc ::flickr::do_signature {query} {
    # perform some operations on the query here
    return $query
}

.CE
.IP
callback
If this option is present then the method will be created as an async call\&. An async call will return immediately with the value of the http token\&. The event loop must be active to use this option\&. The value of this option is the name of a proc which is invoked when the HTTP call is complete\&. The proc receives three arguments, the name of the calling procedure, the status of the result (one of OK or ERROR), and the data associated with the result\&.
the http request header is available via
.TP
uplevel token token
cookie
a list of cookies to be passed in the http header\&. this is just a shortcut to the headers option
input_transform
commands which take the variable $query and transform it in some manner before returning a new value\&. return value must be a dict which will be passed to http::formatQuery
the request body is accessible via
.TP
upvar body body
format or result
defines the format of the returned data\&. should be one of discard, raw, json, xml, or tdom\&. the default is auto which should auto detect between xml and json\&. rss is formated as
a special case of xml\&.
pre_transform
this value takes the form of a proc which should perform some action on $result and return a value\&. it is run on the result before the output (xml/json/etc) transformation is done\&.
the http request header is available via
.TP
uplevel token token
result
may have the value xml, json, tdom, raw, or auto\&. the default is auto and should auto detect json or xml results and transform them into a tcl list\&. this is here if you want to specify it explicitly\&.
post_transform
this value takes the form of a proc which should perform some action on $result and return a value\&. it is run on the result after the output transformation but before returning the value to the calling procedure\&.
the http request header is available via
.TP
uplevel token token
check_result
this value should be a list of 2 expressions either of which may be empty\&. the first expression is checks the OK condition, it must return true when the result is satisfactory\&. the second expression is the error condition, it must return false unless there is an error\&.
.PP
.SH INCLUDED
functional but incomplete implementations are included for the following services:
flickr
twitter
yahoo boss
yahoo weather
google calendar
facebook
del\&.icio\&.us
read the file or source it and use \fBdescribe\fR for more information\&. also see the
developers documentation on the respective sites\&.