#include "tcl.h"
#include "sql-mysql.h"

// -------------------------------------------------------------
Sql_mysql::Sql_mysql() {
	for (int i=0; i < maxResults; i++) {
		results[i] = NULL;
	}
	connect(0,NULL);
}

// -------------------------------------------------------------
Sql_mysql::Sql_mysql(int argc, char** argv) {
	for (int i=0; i < maxResults; i++) {
		results[i] = NULL;
	}
	connect(argc, argv);
}

// -------------------------------------------------------------
char *
Sql_mysql::getErrorMsg() {
	char *msg = mysql_error(&mysql);
	if (*msg == '\0') {
		return errormsg;
	} else {
		return msg;
	}
}

// -------------------------------------------------------------
// Return 0 in case of error, 1 otherwise
int 
Sql_mysql::connect(int argc, char **argv) {
	char *host = NULL;
	char *user = NULL;
	char *passwd = NULL;

	if (argc > 0 && argv[0]) { host   = argv[0]; }
	if (argc > 1 && argv[1]) { user   = argv[1]; }
	if (argc > 2 && argv[2]) { passwd = argv[2]; }

	if (!(mysql_connect(&mysql,host,user,passwd))) {
		connected = 0;
		return -1;
	}

	connected = 1;
	return 1;
}

// -------------------------------------------------------------
int 
Sql_mysql::selectdb(char *dbname) { 
	if (!connected || !dbname) return 0;
	if (mysql_select_db(&mysql,dbname)) {
		return 0;
	}
	return 1;
}

// -------------------------------------------------------------
int
Sql_mysql::exec(char *cmd) {

	if (mysql_query(&mysql,cmd)) {
		return 0;
	}
	return 1;
}

// -------------------------------------------------------------
int
Sql_mysql::numRows(int resHandle=0) {
	if (!results[resHandle]) { return -1; }
	return(mysql_num_rows(results[resHandle]));
}

// -------------------------------------------------------------
int
Sql_mysql::getFreeResultHandle() {
	for (int i=0; i < maxResults; i++) {
		if (!results[i]) { return i; }
	}

	// If we make it to here no result handles were free.
	return -1;
}

// -------------------------------------------------------------
int
Sql_mysql::query(char *cmd) {

	int resHandle = getFreeResultHandle();

	MYSQL_RES *res;
	if (resHandle < 0) {
		// No result handles left open
		sprintf(errormsg, "Too many pending results: max %d allowed.\n", maxResults);
		return -1;
	}

	if (mysql_query(&mysql,cmd)) { return -2; }
	if (!(res = mysql_store_result(&mysql))) { return -3; }

	results[resHandle] = res;
	return (resHandle);
}

// -------------------------------------------------------------
void
Sql_mysql::endquery(int resHandle=0) {
	if (!results[resHandle]) return;
	mysql_free_result(results[resHandle]);
	results[resHandle] = NULL;
}


// -------------------------------------------------------------
// Note: A new Sql_row is allocated. Has to be freed by calling
// party.
Sql_row *
Sql_mysql::fetchrow(int resHandle=0) {

	if (!results[resHandle]) {
		sprintf(errormsg, "Result handle [%d] not in use.\n", resHandle);
		return NULL;
	}

	MYSQL_ROW row;
	MYSQL_RES *res = results[resHandle];
	row = mysql_fetch_row(res);
	if (!row) return NULL;

	Sql_row *srow = new Sql_row(mysql_num_fields(res));
	for (unsigned int i=0 ; i < mysql_num_fields(res); i++) {
		srow->setColumn(i, row[i]);
	}
	return srow;
}

// -------------------------------------------------------------
Sql_mysql::~Sql_mysql() {
	for (int i=0; i < maxResults ; i++) {
		if (results[i]) { endquery(i); }
	}
	mysql_close(&mysql);
}
