/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.x11;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.Debug;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.x11.GLX;
import net.java.games.jogl.impl.x11.GLXFBConfig;
import net.java.games.jogl.impl.x11.X11GLContext;

public class X11PbufferGLContext
extends X11GLContext {
    private static final boolean DEBUG = Debug.debug("X11PbufferGLContext");
    private int initWidth;
    private int initHeight;
    private long buffer;
    private GLXFBConfig fbConfig;
    private int width;
    private int height;
    private long parentContext;
    private static final int MAX_PFORMATS = 256;
    private static final int MAX_ATTRIBS = 256;

    public X11PbufferGLContext(GLCapabilities gLCapabilities, int n, int n2) {
        super(null, gLCapabilities, null, null);
        this.initWidth = n;
        this.initHeight = n2;
        if (this.initWidth <= 0 || this.initHeight <= 0) {
            throw new GLException("Initial width and height of pbuffer must be positive (were (" + this.initWidth + ", " + this.initHeight + "))");
        }
    }

    public boolean canCreatePbufferContext() {
        return false;
    }

    public GLContext createPbufferContext(GLCapabilities gLCapabilities, int n, int n2) {
        throw new GLException("Not supported");
    }

    public void bindPbufferToTexture() {
        throw new GLException("Not yet implemented");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Not yet implemented");
    }

    public void createPbuffer(long l, long l2, GL gL) {
        if (l == 0L) {
            throw new GLException("Null display");
        }
        if (l2 == 0L) {
            throw new GLException("Null parentContext");
        }
        if (this.capabilities.getOffscreenRenderToTexture()) {
            throw new GLException("Render-to-texture pbuffers not supported yet on X11");
        }
        if (this.capabilities.getOffscreenRenderToTextureRectangle()) {
            throw new GLException("Render-to-texture-rectangle pbuffers not supported yet on X11");
        }
        int[] nArray = new int[512];
        float[] fArray = new float[512];
        boolean bl = false;
        int n = 0;
        nArray[n++] = 32784;
        nArray[n++] = 4;
        nArray[n++] = 32785;
        nArray[n++] = 1;
        nArray[n++] = 5;
        nArray[n++] = this.capabilities.getDoubleBuffered() ? 1 : 0;
        nArray[n++] = 12;
        nArray[n++] = this.capabilities.getDepthBits();
        nArray[n++] = 8;
        nArray[n++] = this.capabilities.getRedBits();
        nArray[n++] = 9;
        nArray[n++] = this.capabilities.getGreenBits();
        nArray[n++] = 10;
        nArray[n++] = this.capabilities.getBlueBits();
        nArray[n++] = 11;
        nArray[n++] = this.capabilities.getAlphaBits();
        if (this.capabilities.getStencilBits() > 0) {
            nArray[n++] = 13;
            nArray[n++] = this.capabilities.getStencilBits();
        }
        if (this.capabilities.getAccumRedBits() > 0 || this.capabilities.getAccumGreenBits() > 0 || this.capabilities.getAccumBlueBits() > 0) {
            nArray[n++] = 14;
            nArray[n++] = this.capabilities.getAccumRedBits();
            nArray[n++] = 15;
            nArray[n++] = this.capabilities.getAccumGreenBits();
            nArray[n++] = 16;
            nArray[n++] = this.capabilities.getAccumBlueBits();
        }
        if (this.capabilities.getOffscreenFloatingPointBuffers()) {
            if (!gL.isExtensionAvailable("GLX_NV_float_buffer")) {
                throw new GLException("Floating-point pbuffers on X11 currently require NVidia hardware");
            }
            nArray[n++] = 8368;
            nArray[n++] = 1;
        }
        nArray[n++] = 0;
        int n2 = 0;
        int[] nArray2 = new int[1];
        GLXFBConfig[] gLXFBConfigArray = GLX.glXChooseFBConfig(l, n2, nArray, nArray2);
        if (gLXFBConfigArray == null || gLXFBConfigArray.length == 0 || gLXFBConfigArray[0] == null) {
            throw new GLException("pbuffer creation error: glXChooseFBConfig() failed");
        }
        GLXFBConfig gLXFBConfig = gLXFBConfigArray[0];
        int n3 = nArray2[0];
        if (n3 <= 0) {
            throw new GLException("pbuffer creation error: couldn't find a suitable frame buffer configuration");
        }
        if (DEBUG) {
            System.err.println("Found " + gLXFBConfigArray.length + " matching GLXFBConfigs");
            System.err.println("Parameters of default one:");
            System.err.println("render type: 0x" + Integer.toHexString(this.queryFBConfig(l, gLXFBConfig, 32785)));
            System.err.println("rgba: " + ((this.queryFBConfig(l, gLXFBConfig, 32785) & 1) != 0));
            System.err.println("r: " + this.queryFBConfig(l, gLXFBConfig, 8));
            System.err.println("g: " + this.queryFBConfig(l, gLXFBConfig, 9));
            System.err.println("b: " + this.queryFBConfig(l, gLXFBConfig, 10));
            System.err.println("a: " + this.queryFBConfig(l, gLXFBConfig, 11));
            System.err.println("depth: " + this.queryFBConfig(l, gLXFBConfig, 12));
            System.err.println("double buffered: " + this.queryFBConfig(l, gLXFBConfig, 5));
        }
        n = 0;
        nArray[n++] = 32833;
        nArray[n++] = this.initWidth;
        nArray[n++] = 32832;
        nArray[n++] = this.initHeight;
        nArray[n++] = 0;
        long l3 = GLX.glXCreatePbuffer(l, gLXFBConfig, nArray);
        if (l3 == 0L) {
            throw new GLException("pbuffer creation error: glXCreatePbuffer() failed");
        }
        this.display = l;
        this.mostRecentDisplay = l;
        this.parentContext = l2;
        this.buffer = l3;
        this.fbConfig = gLXFBConfig;
        int[] nArray3 = new int[1];
        GLX.glXQueryDrawable(l, (long)((int)this.buffer), 32797, nArray3);
        this.width = nArray3[0];
        GLX.glXQueryDrawable(l, (long)((int)this.buffer), 32798, nArray3);
        this.height = nArray3[0];
        if (DEBUG) {
            System.err.println("Created pbuffer " + this.width + " x " + this.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean makeCurrent(Runnable runnable) throws GLException {
        if (this.buffer == 0L) {
            return false;
        }
        this.lockAWT();
        try {
            boolean bl = false;
            if (this.context == 0L) {
                this.create();
                if (DEBUG) {
                    System.err.println("!!! Created GL context for " + this.getClass().getName());
                }
                bl = true;
            }
            if (!GLX.glXMakeContextCurrent(this.display, this.buffer, this.buffer, this.context)) {
                throw new GLException("Error making context current");
            }
            if (bl) {
                this.resetGLFunctionAvailability();
                runnable.run();
            }
            boolean bl2 = true;
            return bl2;
        }
        finally {
            this.unlockAWT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void free() throws GLException {
        this.lockAWT();
        try {
            if (!GLX.glXMakeContextCurrent(this.display, 0L, 0L, 0L)) {
                throw new GLException("Error freeing OpenGL context");
            }
        }
        finally {
            this.unlockAWT();
        }
    }

    public void handleModeSwitch(long l, long l2) {
        throw new GLException("Not yet implemented");
    }

    protected boolean isOffscreen() {
        return false;
    }

    public int getOffscreenContextBufferedImageType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    protected void create() {
        if (DEBUG) {
            System.err.println("Creating context for pbuffer " + this.width + " x " + this.height);
        }
        this.context = GLX.glXCreateNewContext(this.display, this.fbConfig, 32788, this.parentContext, true);
        if (this.context == 0L) {
            throw new GLException("pbuffer creation error: glXCreateNewContext() failed");
        }
        if (DEBUG) {
            System.err.println("Created context for pbuffer " + this.width + " x " + this.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyImpl() throws GLException {
        this.lockAWT();
        try {
            if (this.context != 0L) {
                super.destroyImpl();
                GLX.glXDestroyPbuffer(this.display, this.buffer);
                this.buffer = 0L;
            }
        }
        finally {
            this.unlockAWT();
        }
    }

    public void swapBuffers() throws GLException {
    }

    public int getFloatingPointMode() {
        return 3;
    }

    private int queryFBConfig(long l, GLXFBConfig gLXFBConfig, int n) {
        int[] nArray = new int[1];
        if (GLX.glXGetFBConfigAttrib(l, gLXFBConfig, n, nArray) != 0) {
            throw new GLException("glXGetFBConfigAttrib failed");
        }
        return nArray[0];
    }
}

