/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.common;

import edu.uoregon.tau.common.EPSOutput;
import edu.uoregon.tau.common.ImageExport;
import edu.uoregon.tau.common.ImageFormatFileFilter;
import edu.uoregon.tau.common.ImageOptionsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class VectorExport {
    public static void promptForVectorExport(ImageExport imageExport, String string) throws Exception {
        int n;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Save Vector Graphics File");
        jFileChooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        FileFilter[] fileFilterArray = jFileChooser.getChoosableFileFilters();
        for (int i = 0; i < fileFilterArray.length; ++i) {
            jFileChooser.removeChoosableFileFilter(fileFilterArray[i]);
        }
        jFileChooser.addChoosableFileFilter(new ImageFormatFileFilter(ImageFormatFileFilter.EPS));
        jFileChooser.addChoosableFileFilter(new ImageFormatFileFilter(ImageFormatFileFilter.SVG));
        jFileChooser.setFileSelectionMode(0);
        ImageOptionsPanel imageOptionsPanel = new ImageOptionsPanel((Component)((Object)imageExport), true, true);
        jFileChooser.setAccessory(imageOptionsPanel);
        jFileChooser.addPropertyChangeListener(imageOptionsPanel);
        int n2 = jFileChooser.showSaveDialog((Component)((Object)imageExport));
        if (n2 != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        String string2 = file.getCanonicalPath();
        String string3 = ImageFormatFileFilter.getExtension(file);
        if (string3 == null) {
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter instanceof ImageFormatFileFilter) {
                ImageFormatFileFilter imageFormatFileFilter = (ImageFormatFileFilter)fileFilter;
                string2 = string2 + "." + imageFormatFileFilter.getExtension();
            }
            file = new File(string2);
        }
        if (file.exists() && (n = JOptionPane.showConfirmDialog((Component)((Object)imageExport), file + " already exists\nOverwrite existing file?", "Confirm Overwrite", 2, 3)) == 2) {
            return;
        }
        boolean bl = imageOptionsPanel.getTextAsShapes();
        VectorExport.export(imageExport, file, bl, string, imageOptionsPanel.isFullScreen(), imageOptionsPanel.isPrependHeader());
    }

    public static void export(ImageExport imageExport, File file, boolean bl, String string, boolean bl2, boolean bl3) throws Exception {
        String string2 = ImageFormatFileFilter.getExtension(file).toLowerCase();
        if (string2.compareTo("svg") == 0) {
            DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
            Document document = dOMImplementation.createDocument(null, "svg", null);
            SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(SVGGeneratorContext.createDefault((Document)document), bl);
            imageExport.export((Graphics2D)sVGGraphics2D, false, bl2, bl3);
            boolean bl4 = true;
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            sVGGraphics2D.stream((Writer)outputStreamWriter, bl4);
        } else if (string2.compareTo("eps") == 0) {
            Dimension dimension = imageExport.getImageSize(bl2, bl3);
            EPSOutput ePSOutput = new EPSOutput(string, file, dimension.width, dimension.height);
            imageExport.export(ePSOutput, false, bl2, bl3);
            ePSOutput.finish();
            ePSOutput = new EPSOutput(string, file, dimension.width, dimension.height);
            ePSOutput.setDrawTextAsShapes(bl);
            imageExport.export(ePSOutput, false, bl2, bl3);
            ePSOutput.finish();
        } else {
            JOptionPane.showMessageDialog((JComponent)((Object)imageExport), "Unknown format: '" + string2 + "'");
        }
    }
}

