/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.paraprof.treetable;

import edu.uoregon.tau.paraprof.ColorBar;
import edu.uoregon.tau.paraprof.DataSorter;
import edu.uoregon.tau.paraprof.PPFunctionProfile;
import edu.uoregon.tau.paraprof.ParaProfTrial;
import edu.uoregon.tau.perfdmf.Function;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public class MiniHistogram
extends JComponent {
    private ParaProfTrial ppTrial;
    private Function function;
    private int[] bins;
    private int maxInAnyBin;
    private double maxValue;
    private double minValue;
    private double binWidth;
    private List list;

    public MiniHistogram(ParaProfTrial paraProfTrial, Function function) {
        this.ppTrial = paraProfTrial;
        this.function = function;
        DataSorter dataSorter = new DataSorter(paraProfTrial);
        this.list = dataSorter.getFunctionData(function, false, false);
        this.processData();
    }

    private void processData() {
        this.maxValue = 0.0;
        this.minValue = 0.0;
        PPFunctionProfile pPFunctionProfile = null;
        int n = 0;
        boolean bl = true;
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            pPFunctionProfile = (PPFunctionProfile)iterator.next();
            ++n;
            double d = pPFunctionProfile.getValue();
            if (bl) {
                this.minValue = d;
                bl = false;
            }
            this.maxValue = Math.max(this.maxValue, d);
            this.minValue = Math.min(this.minValue, d);
        }
        int n2 = 10;
        double d = this.maxValue / (double)n2;
        this.binWidth = (this.maxValue - this.minValue) / (double)n2;
        this.bins = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.bins[n3] = 0;
            ++n3;
        }
        int n4 = 0;
        Iterator iterator2 = this.list.iterator();
        block2: while (iterator2.hasNext()) {
            pPFunctionProfile = (PPFunctionProfile)iterator2.next();
            double d2 = pPFunctionProfile.getValue();
            int n5 = 0;
            while (n5 < n2) {
                if (d2 <= this.minValue + this.binWidth * (double)(n5 + 1)) {
                    int n6 = n5;
                    this.bins[n6] = this.bins[n6] + 1;
                    ++n4;
                    continue block2;
                }
                ++n5;
            }
        }
        this.maxInAnyBin = 0;
        int n7 = 0;
        while (n7 < n2) {
            this.maxInAnyBin = Math.max(this.maxInAnyBin, this.bins[n7]);
            ++n7;
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Rectangle rectangle = this.getBounds();
        int n = rectangle.width / 10;
        int n2 = (int)rectangle.getHeight() - 1;
        graphics.setColor(Color.red);
        int n3 = 0;
        while (n3 < this.bins.length) {
            if (this.bins[n3] != 0) {
                double d = (double)this.bins[n3] / (double)this.maxInAnyBin;
                int n4 = (int)(d * (double)n2);
                n4 = Math.max(1, n4);
                Color color = ColorBar.getColor((float)d);
                graphics.fillRect(n * n3, (int)rectangle.getHeight() - n4, n, n4);
            }
            ++n3;
        }
    }
}

