/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf.loader;

import edu.uoregon.tau.perfdmf.database.DB;
import edu.uoregon.tau.perfdmf.loader.AppLoadHandler;
import edu.uoregon.tau.perfdmf.loader.ExpLoadHandler;
import edu.uoregon.tau.perfdmf.loader.LoadHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Load {
    private DB db = null;
    private String parserClass;

    public Load(String string) {
        this.parserClass = new String(string);
    }

    public Load(DB dB, String string) {
        this.parserClass = new String(string);
        this.setDB(dB);
    }

    public DB getDB() {
        return this.db;
    }

    public void setDB(DB dB) {
        this.db = dB;
    }

    public LoadHandler newHandler(String string, String string2) {
        return new LoadHandler(this.getDB(), string, string2);
    }

    public AppLoadHandler newAppHandler() {
        return new AppLoadHandler(this.getDB());
    }

    public ExpLoadHandler newExpHandler(String string) {
        return new ExpLoadHandler(this.getDB(), string);
    }

    public String parse(String string, String string2, String string3) {
        try {
            String string4 = this.getProblemString(string3);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(this.parserClass);
            LoadHandler loadHandler = this.newHandler(string2, string4);
            xMLReader.setContentHandler(loadHandler);
            xMLReader.setErrorHandler(loadHandler);
            try {
                loadHandler.setDocumentName(string);
                File file = new File(string);
                xMLReader.parse(new InputSource(new FileInputStream(file)));
                return loadHandler.getTrialId();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return null;
    }

    public String parseApp(String string) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(this.parserClass);
            AppLoadHandler appLoadHandler = this.newAppHandler();
            xMLReader.setContentHandler(appLoadHandler);
            xMLReader.setErrorHandler(appLoadHandler);
            try {
                File file = new File(string);
                xMLReader.parse(new InputSource(new FileInputStream(file)));
                return appLoadHandler.getAppId();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return null;
    }

    public String parseExp(String string, String string2) {
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader(this.parserClass);
            ExpLoadHandler expLoadHandler = this.newExpHandler(string2);
            xMLReader.setContentHandler(expLoadHandler);
            xMLReader.setErrorHandler(expLoadHandler);
            try {
                File file = new File(string);
                xMLReader.parse(new InputSource(new FileInputStream(file)));
                return expLoadHandler.getExpId();
            }
            catch (SAXException sAXException) {
                sAXException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
        return null;
    }

    public String lookupApp(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select distinct id from ");
        stringBuffer.append("application ");
        if (string2.trim().length() == 0) {
            stringBuffer.append("  where name='" + string.trim() + "'; ");
        } else {
            stringBuffer.append("  where name='" + string.trim() + "' and version='" + string2.trim() + "'; ");
        }
        try {
            ResultSet resultSet = this.getDB().executeQuery(stringBuffer.toString());
            if (!resultSet.next()) {
                System.out.println("no such application found");
                resultSet.close();
                return null;
            }
            String string3 = resultSet.getString(1);
            resultSet.close();
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String lookupExp(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select distinct id from ");
        stringBuffer.append(string);
        stringBuffer.append("  where application = '" + string2.trim() + "' and system_info='" + string3.trim() + "' and configuration_info='" + string4.trim() + "' and instrumentation_info='" + string6.trim() + "' and compiler_info='" + string5.trim() + "'; ");
        try {
            ResultSet resultSet = this.getDB().executeQuery(stringBuffer.toString());
            if (!resultSet.next()) {
                resultSet.close();
                return null;
            }
            String string7 = resultSet.getString(1);
            resultSet.close();
            return string7;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String lookupTrial(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select distinct id from ");
        stringBuffer.append(string);
        stringBuffer.append("  where id = " + string2.trim() + "; ");
        try {
            ResultSet resultSet = this.getDB().executeQuery(stringBuffer.toString());
            if (!resultSet.next()) {
                resultSet.close();
                return null;
            }
            String string3 = resultSet.getString(1);
            resultSet.close();
            return string3;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String insertExp(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("insert into ");
            stringBuffer.append("experiment ");
            stringBuffer.append(" (application, system_info, configuration_info, instrumentation_info, compiler_info)");
            stringBuffer.append(" values ");
            stringBuffer.append("(" + string2 + ", '" + string3 + "', '");
            stringBuffer.append(string4 + "', '" + string6 + "', '" + string5 + "'); ");
            this.getDB().executeUpdate(stringBuffer.toString());
            stringBuffer.delete(0, stringBuffer.toString().length());
            if (this.getDB().getDBType().compareTo("mysql") == 0) {
                stringBuffer.append("select LAST_INSERT_ID();");
            } else {
                stringBuffer.append("select currval('experiment_id_seq');");
            }
            String string8 = this.getDB().getDataItem(stringBuffer.toString());
            System.out.println("The ID for the experiment is: " + string8);
            return string8;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public String getProblemString(String string) {
        if (string == null) {
            return new String("");
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (Exception exception) {
            System.out.println("Problem file not found!  Exiting...");
            System.exit(0);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            String string2;
            try {
                string2 = bufferedReader.readLine();
            }
            catch (Exception exception) {
                string2 = null;
            }
            if (string2 == null) break;
            stringBuffer.append(string2.replaceAll("'", "'"));
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }
}

