/*
 * Decompiled with CFR 0.152.
 */
package edu.uoregon.tau.perfdmf;

import edu.uoregon.tau.perfdmf.Context;
import edu.uoregon.tau.perfdmf.Function;
import edu.uoregon.tau.perfdmf.FunctionProfile;
import edu.uoregon.tau.perfdmf.Group;
import edu.uoregon.tau.perfdmf.HPCToolkitDataSource;
import edu.uoregon.tau.perfdmf.Metric;
import edu.uoregon.tau.perfdmf.Node;
import edu.uoregon.tau.perfdmf.Thread;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HPCToolkitXMLHandler
extends DefaultHandler {
    private HPCToolkitDataSource dataSource;
    private Function currentFunction;
    private int numMetrics = 0;
    private String currentFile;
    private Map metricMap = new HashMap();
    private Thread theThread;
    private Stack nameStack = new Stack();
    private Group defaultGroup;
    private Group callpathGroup;

    public HPCToolkitXMLHandler(HPCToolkitDataSource hPCToolkitDataSource) {
        this.dataSource = hPCToolkitDataSource;
    }

    public void startDocument() throws SAXException {
        this.theThread = this.createThread(0, 0, 0);
        this.defaultGroup = this.dataSource.addGroup("HPC_DEFAULT");
        this.callpathGroup = this.dataSource.addGroup("HPC_CALLPATH");
    }

    public void endDocument() throws SAXException {
    }

    private Thread createThread(int n, int n2, int n3) {
        Thread thread = this.dataSource.getThread(0, 0, 0);
        if (thread == null) {
            Node node = this.dataSource.addNode(n);
            Context context = node.addContext(n2);
            thread = context.addThread(n3, 0);
        }
        return thread;
    }

    private FunctionProfile createFunctionProfile(Thread thread, Function function) {
        FunctionProfile functionProfile = thread.getFunctionProfile(function);
        if (functionProfile == null) {
            functionProfile = new FunctionProfile(function, this.numMetrics);
            thread.addFunctionProfile(functionProfile);
        }
        return functionProfile;
    }

    private void stackName(String string) {
        Function function;
        String string2 = string;
        Stack stack = (Stack)this.nameStack.clone();
        while (stack.size() != 0) {
            string = stack.pop() + " => " + string;
        }
        this.nameStack.push(string2);
        this.currentFunction = function = this.dataSource.addFunction(string);
        if (string.indexOf("=>") != -1) {
            function.addGroup(this.callpathGroup);
        } else {
            function.addGroup(this.defaultGroup);
        }
        FunctionProfile functionProfile = this.getFlatFunctionProfile(this.theThread, function);
    }

    private FunctionProfile getFlatFunctionProfile(Thread thread, Function function) {
        if (!function.isCallPathFunction()) {
            return null;
        }
        String string = function.getName().substring(function.getName().lastIndexOf("=>") + 2).trim();
        Function function2 = this.dataSource.addFunction(string);
        function2.addGroup(this.defaultGroup);
        FunctionProfile functionProfile = thread.getFunctionProfile(function2);
        if (functionProfile == null) {
            functionProfile = new FunctionProfile(function2, this.dataSource.getNumberOfMetrics());
            thread.addFunctionProfile(functionProfile);
        }
        return functionProfile;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string2.equalsIgnoreCase("METRIC")) {
            String string4 = attributes.getValue("displayName");
            String string5 = attributes.getValue("shortName");
            String string6 = attributes.getValue("nativeName");
            Metric metric = this.dataSource.addMetric(string4);
            this.metricMap.put(string5, metric);
            ++this.numMetrics;
            this.theThread.incrementStorage();
        } else if (string2.equalsIgnoreCase("PGM")) {
            this.stackName(attributes.getValue("n"));
        } else if (string2.equalsIgnoreCase("LM")) {
            this.stackName("Load module " + attributes.getValue("n"));
        } else if (string2.equalsIgnoreCase("L")) {
            this.stackName("loop at " + this.currentFile + ": " + attributes.getValue("b") + "-" + attributes.getValue("e"));
        } else if (string2.equalsIgnoreCase("LN")) {
            this.stackName(this.currentFile + ": " + attributes.getValue("b"));
        } else if (string2.equalsIgnoreCase("F")) {
            this.stackName(attributes.getValue("n"));
            this.currentFile = attributes.getValue("n");
        } else if (string2.equalsIgnoreCase("P")) {
            this.stackName(attributes.getValue("n"));
        } else if (string2.equalsIgnoreCase("M")) {
            String string7 = attributes.getValue("n");
            Metric metric = (Metric)this.metricMap.get(string7);
            double d = Double.parseDouble(attributes.getValue("v"));
            FunctionProfile functionProfile = this.createFunctionProfile(this.theThread, this.currentFunction);
            functionProfile.setInclusive(metric.getID(), d);
            functionProfile.setExclusive(metric.getID(), d);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equalsIgnoreCase("PGM")) {
            this.nameStack.pop();
        } else if (string2.equalsIgnoreCase("LM")) {
            this.nameStack.pop();
        } else if (string2.equalsIgnoreCase("P")) {
            this.nameStack.pop();
        } else if (string2.equalsIgnoreCase("F")) {
            this.nameStack.pop();
        } else if (string2.equalsIgnoreCase("L")) {
            this.nameStack.pop();
        } else if (string2.equalsIgnoreCase("LN")) {
            this.nameStack.pop();
        }
    }
}

