
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "globals.h"
#include "geo_photos.h"
#include "converter.h"
#include "util.h"

#include <glib.h>
#include <glib/gprintf.h>
#include <stdio.h>
#include <sqlite3.h>
#include <stdlib.h>

#define PHOTO_DB "geophoto.db"







static int
sql_cb__photo(void *unused, int colc, char **colv, char **col_names)
{
	photo_t *photo = g_new0(photo_t,1);

	printf("*** %s(): \n",__PRETTY_FUNCTION__);

	photo->filename = g_strdup(colv[0]);
	photo->name	= g_strdup(colv[1]);
	photo->lat	= atof(colv[2]);
	photo->lon	= atof(colv[3]);
	photo->desc	= g_strdup(colv[4]);
	
	photo_list = g_slist_prepend(photo_list, photo);

	return 0;
}







void
paint_photos()
{
	
	
	int pixel_x, pixel_y, x, y;
	float lat, lon;
	GSList *list;
	GdkColor color;
	GError	*error = NULL;
	static GdkPixbuf *photo_icon = NULL;
	static GdkGC *gc;
	
	printf("*** %s(): \n",__PRETTY_FUNCTION__);

	if (!gc)
		gc = gdk_gc_new(pixmap); 
	color.green = 0;
	color.blue = 60000;
	color.red = 0;
	gdk_gc_set_rgb_fg_color(gc, &color);
	

	if(!photo_icon)
	{
		photo_icon = gdk_pixbuf_new_from_file_at_size (
			PACKAGE_PIXMAPS_DIR "/tangogps-photo.png", 24,24,
			&error);
	}

	if(global_show_photos)
	{
		for(list = photo_list; list != NULL; list = list->next)
		{
			photo_t *p = list->data;
		
			lat = deg2rad(p->lat);
			lon = deg2rad(p->lon);
			
			
			
			pixel_x = lon2pixel(global_zoom, lon);
			pixel_y = lat2pixel(global_zoom, lat);
			
			x = pixel_x - global_x;
			y = pixel_y - global_y;
			
			p->screen_x = x;
			p->screen_y = y;
			
			
			
			if(!photo_icon)
			{
				gdk_draw_arc (
					pixmap,
					
					gc,
					TRUE,			
					x-4, y-4,		
					8,8,			
					0,23040);		
			}
			else
			{
				gdk_draw_pixbuf (
					pixmap,
					NULL,
					photo_icon,
					0,0,
					x-12,y-12,
					24,24,
					GDK_RGB_DITHER_NONE, 0, 0);
				
			}
			
			gtk_widget_queue_draw_area (
					map_drawable, 
					x-12, y-12,
					24,24);
			
			printf("PHOTO: %s lat %f - lon %f\n",p->name,p->lat, p->lon);
		}	
	}
}


void
get_photos()
{
	char *sql, *db;
	
	db = g_strconcat(tangogps_dir,"/", PHOTO_DB, NULL);
	
	
	photo_list = NULL;
	
	
	
	sql = g_strdup("SELECT * FROM photo LIMIT 1000;");

	
	sql_execute(db, sql, sql_cb__photo);	
	
	paint_photos();
	
}
