#ifndef TAG_SET_H
#define TAG_SET_H

/*
 * Set of tags and set of facets
 *
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "Tag.h"
#include <tagcoll/OpSet.h>

class FacetSet;
class TagMatcher;
class TagConsumer;
class FacetMatcher;
class FacetConsumer;

class TagSet : public Tagcoll::OpSet<Tag>
{
public:
	using Tagcoll::OpSet<Tag>::find;

	TagSet() throw ();
	TagSet(const Tagcoll::OpSet<Tag>&) throw ();
	~TagSet() throw ();

	FacetSet getFacets() const throw ();

	// Returns true if the set contains the tag named `tag'
	bool has(const std::string& tag) const throw ();

	// Get the Tag object given the package name
	Tag find(const std::string& name) const throw ();
};

class FacetSet : public Tagcoll::OpSet<Facet>
{
public:
	using Tagcoll::OpSet<Facet>::find;

	FacetSet() throw ();
	FacetSet(const Tagcoll::OpSet<Facet>&) throw ();
	~FacetSet() throw ();

	/// Get the Facet object given the name, or create a new Facet object if
	/// the name has not been found
	Facet obtainFacet(const std::string& name) throw ();

	/// Get the Tag object given the fullname, or create new Facet and Tag
	/// object if the name has not been found
	Tag obtainTag(const std::string& fullname) throw ();

	// Get all the tags contained in these facets
	TagSet getTags() const throw ();

	// Returns true if the set contains the facet named `facet'
	bool has(const std::string& facet) const throw ();

	// Returns true if one of the facets in the set contains the tag named
	// `tag'
	bool hasTag(const std::string& tag) const throw ();

	// Get the Facet object given the package name
	Facet find(const std::string& name) const throw ();

	// Get the tag with the given name, if contained in one of these facets
	Tag findTag(const std::string& tag) const throw ();
};

// vim:set ts=4 sw=4:
#endif
