#ifndef TAGCOLLEDIT_SERIALIZER_H
#define TAGCOLLEDIT_SERIALIZER_H

/*
 * Serializer for the Debtags tag collection
 *
 * Copyright (C) 2005  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <tagcoll/Serializer.h>
#include "Tag.h"

namespace Tagcoll
{

/**
 * Convert Tags into strings and strings into tags
 */
class TCEConverter : public Converter<Tag, std::string>, public Converter<std::string, Tag>
{
	FacetSet& _voc;
public:
	TCEConverter(FacetSet& voc) : _voc(voc) {}

	std::string operator()(const Tag& item) const;
	OpSet<std::string> operator()(const OpSet<Tag>& items) const;

	Tag operator()(const std::string& item) const;
	OpSet<Tag> operator()(const OpSet<std::string>& items) const;
};

}

// vim:set ts=4 sw=4:
#endif
