/*
 * Parser input using libc standard I/O functions
 * 
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tagcoll/input/stdio.h>

#include <stdio.h>

namespace tagcoll {
namespace input {

Stdio::Stdio(FILE* in, const std::string& fname, int line)
	: _file(fname), _line(line), _in(in), _close_on_exit(false) {}

Stdio::Stdio(const std::string& fname)
	: _file(fname), _line(1), _in(fopen(_file.c_str(), "rt")), _close_on_exit(true)
{
	if (!_in)
		throw wibble::exception::File(fname, "opening file for reading");
}

Stdio::~Stdio()
{
	if (_in && _close_on_exit)
		fclose(_in);
}

int Stdio::nextChar()
{
	int c = fgetc(_in);
	if (c == '\n')
		_line++;
	if (c == EOF)
		return Input::Eof;
	else
		return c;
}

void Stdio::pushChar(int c)
{
	ungetc(c, _in);
}

}
}

// vim:set ts=4 sw=4:
