/*
 * Parser input using libc standard I/O functions
 * 
 * Copyright (C) 2003  Enrico Zini <enrico@debian.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <tagcoll/StdioParserInput.h>

#include <stdio.h>
#include <errno.h>

namespace Tagcoll {

StdioParserInput::StdioParserInput(FILE* in, const std::string& fname, int line) throw ()
	: _file(fname), _line(line), _in(in), _close_on_exit(false) {}

StdioParserInput::StdioParserInput(const std::string& fname) throw (FileException)
	: _file(fname), _line(1), _in(fopen(_file.c_str(), "rt")), _close_on_exit(true)
{
	if (!_in)
		throw FileException(errno, "opening file " + fname + " for reading");
}

StdioParserInput::~StdioParserInput() throw ()
{
	if (_in && _close_on_exit)
		fclose(_in);
}

int StdioParserInput::nextChar() throw (ParserInputException)
{
	int c = fgetc(_in);
	if (c == '\n')
		_line++;
	if (c == EOF)
		return ParserInput::Eof;
	else
		return c;
}

void StdioParserInput::pushChar(int c) throw (ParserInputException)
{
	ungetc(c, _in);
}

}

// vim:set ts=4 sw=4:
