;;; tc-sysdep.el --- system-dependent routines & variables for T-Code
;;
;; Copyright (C) 1997--2001 Kaoru Maeda, Yasushi Saito and Akira Kitajima.

;; Author: Kaoru Maeda <maeda@src.ricoh.co.jp>
;;	Yasushi Saito <yasushi@is.s.u-tokyo.ac.jp>
;;	Akira Kitajima <kitajima@isc.osakac.ac.jp>
;; Maintainer: Akira Kitajima
;; Version: $Id: tc-sysdep.el,v 1.15 2002/03/25 00:16:05 kitajima Exp $

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2 of the License, or
;; (at your option) any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.

;;; Code:
(require 'tc-setup)

(defmacro tcode-xemacs-p ()
  (list 'eq 'tcode-emacs-version (list 'quote 'xemacs)))

(defmacro tcode-mule-4-p ()
  (list 'eq 'tcode-emacs-version (list 'quote 'mule-4)))

(defmacro tcode-mule-3-p ()
  (list 'eq 'tcode-emacs-version (list 'quote 'mule-3)))

(defmacro tcode-mule-2-p ()
  (list 'eq 'tcode-emacs-version (list 'quote 'mule-2)))

(defmacro tcode-mule-1-p ()
  (list 'eq 'tcode-emacs-version (list 'quote 'mule-1)))

(defmacro tcode-nemacs-p ()
  (list 'eq 'tcode-emacs-version (list 'quote 'nemacs)))

;;;
;;; Define some new functions that are not present in Emacs 18.
;;;

;;; `unless' and `when' are from subr.el of emacs-20.2.
(or (fboundp 'unless)
    (progn
      (defmacro unless (cond &rest body)
	"(unless COND BODY...): if COND yields nil, do BODY, else return nil."
	(cons 'if (cons cond (cons nil body))))
      (put 'unless 'lisp-indent-function 1)
      (put 'unless 'edebug-form-spec '(&rest form))))

(unless (fboundp 'when)
  (defmacro when (cond &rest body)
    "(when COND BODY...): if COND yields non-nil, do BODY, else return nil."
    (list 'if cond (cons 'progn body)))
  (put 'when 'lisp-indent-function 1)
  (put 'when 'edebug-form-spec '(&rest form)))

(unless (fboundp 'add-hook)
  (defun add-hook (hook fun)
    "Add to the value of HOOK the function FUNCTION.
FUNCTION is added at the beginning of the hook list.

HOOK should be a symbol, and FUNCTION may be any valid function.  If
HOOK is void, it is first set to nil.  If HOOK's value is a single
function, it is changed to a list of functions."
    (if (not (boundp hook)) (set hook nil))
    (let ((cur-value (eval hook)))
      (cond ((or (equal fun cur-value)
		 (and (consp cur-value)
		      (member fun cur-value)))
	     nil)		       ; already defined
	    ((null cur-value)
	     (set hook fun))
	    ((or (not (consp cur-value))
		 (eq (car cur-value) 'lambda))
	     (set hook (cons fun (list cur-value))))
	    (t
	     (set hook (nconc (list fun) cur-value)))))))

(unless (fboundp 'cancel-undo-boundary)
  (if (boundp 'buffer-undo-list)
      ;; for Emacs 20 or later
      (defun cancel-undo-boundary ()
	(and (listp buffer-undo-list)
	     (null (car buffer-undo-list))
	     (setq buffer-undo-list (cdr buffer-undo-list))))
    (defun cancel-undo-boundary ()
  ;; this function is just a dummy for emacs version 18,
      ;; and it actually does nothing
      nil)))

(unless (fboundp 'undo-boundary)
  (defun undo-boundary ()
  ;; this function is just a dummy for emacs version 18,
    ;; and it actually does nothing
    nil))

(unless (fboundp 'chars-in-string)
  (defun chars-in-string (s)
    (length s)))

(unless (fboundp 'japanese-hiragana)
  (defun japanese-hiragana (char)
    "ʸ CHAR ʤʤҤ餬ʤѴ롣
ʤǤʤϤΤޤޤ֤ͤ"
    (let ((str (char-to-string char)))
      (if (string-match (concat "^[-]$") str)
	  (if (tcode-nemacs-p)
	      (let ((ch (mod char 256)))
		(+ (* ?\244 256) ch))
	    (let ((ch (char-component char 2)))
	      (make-character lc-jp ?\244 ch)))
	char))))

(unless (fboundp 'japanese-katakana)
  (defun japanese-katakana (char)
    "ʸ CHAR Ҥ餬ʤʤ饫ʤѴ롣
Ҥ餬ʤǤʤϤΤޤޤ֤ͤ"
    (let ((str (char-to-string char)))
      (if (string-match (concat "^[-]$") str)
	  (if (tcode-nemacs-p)
	      (let ((ch (mod char 256)))
		(+ (* ?\245 256) ch))
	    (let ((ch (char-component char 2)))
	      (make-character lc-jp ?\245 ch)))
	char))))

(defconst tcode-jisx0208 (if (tcode-mule-2-p)
			     lc-jp
			   'japanese-jisx0208))

(unless (fboundp 'make-char)
  (if (fboundp 'make-character)
      (defun make-char (charset &optional code1 code2)
	(make-character (cond ((eq charset 'japanese-jisx0208)
			       lc-jp)
			      (t 
			       charset))
			code1
			code2))
    ;; nemacs
    (defun make-char (charset &optional code1 code2)
      (tcode-string-to-char (format "%c%c" code1 code2)))))

(unless (fboundp 'delete-text-in-column)
    ;;; from mule-util.el
  (defun delete-text-in-column (from to)
    "Delete the text between column FROM and TO (exclusive) of the current line.
Nil of FORM or TO means the current column.
If there's a charcter across the borders, the character is replaced with
the same width of spaces before deleting."
    (save-excursion
      (let (p1 p2)
	(if from
	    (progn
	      (setq p1 (move-to-column from))
	      (if (> p1 from)
		  (progn
		    (delete-char -1)
		    (insert-char ?  (- p1 (current-column)))
		    (forward-char (- from p1))))))
	(setq p1 (point))
	(if to
	    (progn
	      (setq p2 (move-to-column to))
	      (if (> p2 to)
		  (progn
		    (delete-char -1)
		    (insert-char ?  (- p2 (current-column)))
		    (forward-char (- to p2))))))
	(setq p2 (point))
	(delete-region p1 p2)))))

(unless (fboundp 'member)
  (defun member (elt list)
    "Return non-nil if ELT is an element of LIST.  \
Comparison done with `equal'.
The value is actually the tail of LIST whose car is ELT."
    (catch 'found
      (while list
	(and (equal elt (car list))
	     (throw 'found list))
	(setq list (cdr list))))))

(unless (fboundp 'frame-width)
  (defmacro frame-width () (list 'screen-width)))

(unless (fboundp 'abs)
  (defun abs (arg)
    "Return the absolute value of ARG."
    (if (>= arg 0) arg (- arg))))

(unless (fboundp 'lambda)
  ;; from subr.el in Emacs 21.1
  (defmacro lambda (&rest cdr)
    "Return a lambda expression.
A call of the form (lambda ARGS DOCSTRING INTERACTIVE BODY) is
self-quoting; the result of evaluating the lambda expression is the
expression itself.  The lambda expression may then be treated as a
function, i.e., stored as the function value of a symbol, passed to
funcall or mapcar, etc.

ARGS should take the same form as an argument list for a `defun'.
DOCSTRING is an optional documentation string.
 If present, it should describe how to call the function.
 But documentation strings are usually not useful in nameless functions.
INTERACTIVE should be a call to the function `interactive', which see.
It may also be omitted.
BODY should be a list of lisp expressions."
;; Note that this definition should not use backquotes; subr.el should not
    ;; depend on backquote.el.
    (list 'function (cons 'lambda cdr))))

(unless (fboundp 'window-minibuffer-p)
  (defun window-minibuffer-p (&optional window)
    (string-match " \\*Mini" (buffer-name (window-buffer window)))))

(unless (fboundp 'buffer-substring-no-properties)
  (defun buffer-substring-no-properties (start end)
    (buffer-substring start end)))

;;;
;;; Fix incompatibilities between 18 and 19.
;;;
(if (string-match "^\\(19\\|2[01]\\)" emacs-version)
    (progn
      (defun tcode-define-key-for-all-chars (keymap fun)
	"ޥå KEYMAP ΡʸΤФ륨ȥ
FUN롣KEYMAPϡ(make-keymap)Ǻ줿ޥåפǤʤ
ʤʤ"
	(let ((i 0))
	  (while (< i 126)
	    (define-key keymap (char-to-string i) fun)
	    (setq i (1+ i)))))
      (defun tcode-redo-last-command ()
	"ľϤ줿򸽺ߤΥޥåפǺƼ¹Ԥ"
	(setq unread-command-events
	      (cons last-command-event unread-command-events)))
      (defun tcode-redo-command (ch)
	" CH 򸽺ߤΥޥåפǺƼ¹Ԥ"
	(setq unread-command-events
	      (cons (character-to-event ch) unread-command-events)))
      (or (fboundp 'character-to-event)
	  (defun character-to-event (ch)
	    ch))
      ;; XEmacs
      (or (fboundp 'isearch-last-command-char)
	  (defun isearch-last-command-char ()
	    last-command-char))
      (or (boundp 'search-upper-case)
	  (setq search-upper-case 'not-yanks)))
  ;; NEmacs
  (defun tcode-define-key-for-all-chars (keymap fun)
    "ޥå KEYMAP ΡƤʸФ륨ȥFUN롣
KEYMAPϡ(make-keymap)Ǻ줿ޥåפǤʤФʤʤ"
    (let ((i 0))
      (while (< i 126)
	(aset keymap i fun)
	(setq i (1+ i)))))
  (defun tcode-redo-last-command ()
    "ľϤ줿򸽺ߤΥޥåפǺƼ¹Ԥ"
    (setq unread-command-char last-command-char))
  (defun tcode-redo-command (ch)
    " CH 򸽺ߤΥޥåפǺƼ¹Ԥ"
    (setq unread-command-char ch)))

(if (not (tcode-nemacs-p))
    (progn
      (defmacro tcode-char-width (p) (list 'char-width p))
      (defun tcode-string-to-char (p) (string-to-char p))
      (defmacro tcode-char-after (p) (list 'char-after p))
      (defmacro tcode-char-before (p) (list 'char-before p))
      (defmacro tcode-forward-char (p) (list 'forward-char p))
      (defmacro tcode-backward-char (p) (list 'backward-char p))
      (defmacro tcode-string-to-char-list (p) (list 'string-to-char-list p))
      (or (fboundp 'string-to-char-list)
	  (defun string-to-char-list (p)
	    (string-to-list p)))
      (defmacro tcode-delete-char (p) (list 'delete-char p)))
  ;;;
  ;;; NEmacs Ѥ
  ;;; ʲδؿǤϡ2ХʸͤѴȡ
  ;;; (1Х*256 + 2Х)ˤʤ롣
  ;;;
  (defun tcode-char-width (c)
    (if (> c 256) 2 1))
  (unless (fboundp 'orig:char-to-string)
    (fset 'orig:char-to-string (symbol-function 'char-to-string))
    (defun char-to-string (c)
      (if (> c 256)
	  (format "%c%c" (/ c 256) (mod c 256))
	(orig:char-to-string c))))
  (defun tcode-string-to-char (s)
    (let ((1st (aref s 0)))
      (if (>= 1st 128)
          (+ (* 1st 256) (aref s 1))
        1st)))
  (defun tcode-char-after (p)
    (let ((1st (char-after p)))
      (if (>= 1st 128)
          (+ (* 1st 256) (char-after (1+ p)))
        1st)))
  (defun tcode-char-before (p)
    (save-excursion
      (goto-char p)
      (forward-char -1)
      (tcode-char-after (point))))
  (defmacro tcode-string-to-char-list (s)
    (list 'kanji-word-list s))
  (defun tcode-forward-char (i)
    (if (< i 0)
	(while (< i 0)
	  (if (>= (preceding-char) 128) (backward-char 2)
	    (backward-char 1))
	  (setq i (1+ i)))
      (while (> i 0)
	(if (>= (char-after (point)) 128) (forward-char 2)
	  (forward-char 1))
	(setq i (1- i)))))
  (defmacro tcode-backward-char (i)
    (list 'tcode-forward-char (list '- 0 i)))

  (defun tcode-delete-char (i)
    (if (< i 0)
	(while (< i 0)
	  (if (>= (preceding-char) 128)
	      (delete-char -2)
	    (delete-char -1))
	  (setq i (1+ i)))
      (while (> i 0)
	(if (>= (char-after (point)) 128)
	    (delete-char 2)
	  (delete-char 1))
	(setq i (1- i)))))

  (defmacro string-width (p) (list 'length p)))

(defun tcode-do-auto-fill ()
  (cond ((boundp 'auto-fill-function)
	 ;; emacs-19
	 (and auto-fill-function
	      (> (current-column) fill-column)
	      (funcall auto-fill-function)))
	(t
	 ;; emacs-18
	 (and auto-fill-hook
	      (> (current-column) fill-column)
	      (do-auto-fill)))))

(unless (fboundp 'buffer-disable-undo)
  (defun buffer-disable-undo ()
    (setq disable-undo t)))

;;; support custom package

(or (fboundp 'defgroup)
    (defmacro defgroup (&rest args)))

(or (fboundp 'defcustom)
    (defmacro defcustom (symbol value doc &rest args)
      (list 'defvar symbol value doc)))

(defgroup input-methods nil
  "Input methods."
  :group 'mule)

(defgroup tcode nil
  "T-Code (Kanji direct input method)."
  :group 'input-methods)

;;; from mule-cmds.el of Emacs 20.0.91 for earlier version

(unless (boundp 'input-method-activate-hook)
  (defvar input-method-activate-hook nil
    "Normal hook run just after an input method is activated.")

  (defvar input-method-inactivate-hook nil
    "Normal hook run just after an input method is inactivated.")

  (defvar input-method-after-insert-chunk-hook nil
    "Normal hook run just after an input method insert some chunk of text."))


;;; from mule-cmds.el of Emacs 20.3 for earlier version

(unless (boundp 'input-method-verbose-flag)
  (defcustom input-method-verbose-flag 'default
    "*A flag to control extra guidance given by input methods.
The value should be nil, t, `complex-only', or `default'.

The extra guidance is done by showing list of available keys in echo
area.  When you use the input method in the minibuffer, the guidance
is shown at the bottom short window (split from the existing window).

If the value is t, extra guidance is always given, if the value is
nil, extra guidance is always suppressed.

If the value is `complex-only', only complex input methods such as
`chinese-py' and `japanese' give extra guidance.

If the value is `default', complex input methods always give extra
guidance, but simple input methods give it only when you are not in
the minibuffer.

See also the variable `input-method-highlight-flag'."
    :type '(choice (const t) (const nil) (const complex-only) (const default))
    :group 'mule)

  (defcustom input-method-highlight-flag t
    "*If this flag is non-nil, input methods highlight partially-entered text.
For instance, while you are in the middle of a Quail input method sequence,
the text inserted so far is temporarily underlined.
The underlining goes away when you finish or abort the input method sequence.
See also the variable `input-method-verbose-flag'."
    :type 'boolean
    :group 'mule))

;;; mode-line

(defun tcode-find-symbol-in-tree (item tree)
  "ITEM Ǥդι¤Υꥹ TREE equalõ
Ĥt, Ĥʤ nil"
  (if (consp tree)
      (or (tcode-find-symbol-in-tree item (car tree))
	  (tcode-find-symbol-in-tree item (cdr tree)))
    (equal item tree)))

;;; set mode-line-format
(or (and (boundp 'tcode-mode-indicator)
	 (tcode-find-symbol-in-tree 'tcode-mode-indicator
				    (default-value 'mode-line-format)))
    (cond ((or (tcode-nemacs-p)
	       (tcode-xemacs-p))
	   
	   (setq-default mode-line-format
			 (cons '(tcode-ready-in-this-buffer
				 ("[" tcode-mode-indicator "]"))
			       (default-value 'mode-line-format)))
	   (setq mode-line-format (default-value 'mode-line-format)))
	  ((or (tcode-mule-1-p)
	       (tcode-mule-2-p))
	   (setq-default mode-line-format
			 (cons '(mc-flag ("[" tcode-mode-indicator "]"))
			       (default-value 'mode-line-format))))
	  ((tcode-mule-3-p)
	   (setq-default mode-line-mule-info
			 '(enable-multibyte-characters
			   ((current-input-method-title
			     ("[" current-input-method-title "]"))
			    "%Z"))))
	  ((tcode-mule-4-p)
	   (setq-default mode-line-mule-info
			 '("" (current-input-method-title
			       ("[" current-input-method-title "]")) "%Z")))))

(defvar tcode-mode-indicator 'current-input-method-title)
(unless (boundp 'current-input-method-title)
  (defvar current-input-method-title "--")
  (make-variable-buffer-local 'current-input-method-title)
  (setq-default current-input-method-title "--"))

;;; for toggle-input-method

(when (or (memq tcode-emacs-version '(nemacs mule-1 mule-2))
	  (and (eq tcode-emacs-version 'xemacs)
	       (< emacs-major-version 21)
	       (< emacs-minor-version 3)))
  (defvar default-input-method nil)
  (make-variable-buffer-local 'default-input-method)
  (autoload 'tcode-on-p "tc")
  (defun toggle-input-method (&optional arg)
    (interactive "P")
    (if (null default-input-method)
	(let ((im (completing-read "Input method: " tcode-package-name-alist)))
	  (tcode-use-package im)
	  (setq-default default-input-method im)
	  (setq default-input-method im))
      (if arg
	  (let* ((im (completing-read
		     (format "Input method (default %s): " 
			     default-input-method)
		     tcode-package-name-alist))
		 (input-method (if (or (null im)
				       (string= im ""))
				   default-input-method
				 im)))
	    (tcode-use-package input-method)
	    (setq-default default-input-method im)
	    (setq default-input-methtod input-method))
	(if (null tcode-current-package)
	    (tcode-use-package default-input-method)
	  (if (tcode-on-p)
	      (tcode-inactivate)
	    (tcode-activate)))))))


(provide 'tc-sysdep)

;;; tc-sysdep.el ends here
