use ExtUtils::MakeMaker;
use Carp;



###
#  Version is set here globally so we can be more tricky with it
###

my $version = '1.20';

sub MY::postamble {
    my $string = <<EOF;

# What madness lurks in the hearts of men?  The following
# lets me redefine the way the man pages are autogenerated.

POD2MAN_EXE = /usr/bin/pod2man "--center=System Configurator" "--release=System Configurator v$version"
POD2MAN = \$(PERL) -we '\%m=\@ARGV;for (keys \%m){' \\
-e 'next if -e \$\$m{\$\$_} && -M \$\$m{\$\$_} < -M \$\$_ && -M \$\$m{\$\$_} < -M "Makefile";' \\
-e 'print "Manifying \$\$m{\$\$_}\\n";' \\
-e 'system(qq[\$\$^X ].q["-I\$(PERL_ARCHLIB)" "-I\$(PERL_LIB)" \$(POD2MAN_EXE) ].qq[\$\$_>\$\$m{\$\$_}])==0 or warn "Couldn\\047t install \$\$m{\$\$_}\\n";' \\
-e 'chmod(oct(\$(PERM_RW))), \$\$m{\$\$_} or warn "chmod \$(PERM_RW) \$\$m{\$\$_}: \$\$!\\n";}'

POD2MAN5_EXE = \$(POD2MAN_EXE) "--section=5"

deb_prep ::
\tperl -pi.bak -e 's/^VERSION.*/VERSION = $version/' debian/rules

deb :: deb_prep dist
\tmkdir -p /tmp/scdeb
\tmv systemconfigurator-$version.tar.gz /tmp/scdeb && cd /tmp/scdeb && tar -xvzf systemconfigurator-$version.tar.gz && cd systemconfigurator-$version && dpkg-buildpackage && rm -rf /tmp/scdeb/systemconfigurator-$version
\techo "Debian Packages have been built in /tmp/scdeb"

rpm_prep ::
\tperl -pi.bak -e 's/\(\%define version\\\s*\).*/\%define version         $version/' sc.spec

rpm :: rpm_prep dist
\trpm -tb \$(NAME)-\$(VERSION).tar.gz

manext_install ::
\tcd docs && \\
\tinstall -d \$(INSTALLMAN1DIR)/../man5 && \\
\t\$(POD2MAN5_EXE) systemconfig.conf.pod \$(INSTALLMAN1DIR)/../man5/systemconfig.conf.5 && \\
\tcd ..

set_ver::
\tperl -pi.bak -e 's/EXEVERSION =.*/EXEVERSION = $version;/' ./bin/systemconfigurator
\tperl -pi.bak -e 's/EXEVERSION =.*/EXEVERSION = $version;/' ./blib/script/systemconfigurator

all :: set_ver

install :: manext_install

EOF
}



WriteMakefile(
              'VERSION' => $version,
              'NAME' => 'systemconfigurator',
              'EXE_FILES' => [qw(bin/systemconfigurator)],
              'dist' => {
                         'CI' => 'cvs ci',
                         'RCS_LABEL' => 'cvs up',
                        },
              'MAN1PODS' => {
                             'bin/systemconfigurator' => '$(INST_MAN1DIR)/systemconfigurator.$(MAN1EXT)',
                            },
              'macro' => {
                          'MAN1EXT' => '1',
                          'MAN3EXT' => '3pm',
                         },
              'INSTALLSITELIB' => '/usr/lib/systemconfig',
              'PREREQ_PM' => {
                              AppConfig => 1.52,
                             },
             );

