C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MOBLG1,SSI=0
                        SUBROUTINE MOBLG1
C                       *****************
C
C      --------------------
     * (NDIM,NPOINS,COORDS)
C      --------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C             MAILLAGE MOBILE : RELECTURE DES COORDONNEES DES NOEUDS   *
C             DANS LE FICHIER GEOMETRIQUE                              *
C             Rq : C'est une suite de calcul et le fichier est         *
C                  obligatoirement au format SYRTHES puisque           *
C                  c'est un resultat issu d'un precedent calcul        *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   !  E ! D  ! NOMBRE DE NOEUDS DU MAILLAGE                 !
C !  COORDS   ! TR ! R  ! COORD DES NOEUDS DU MAILLAGE SOLIDE          !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C ! /MOBIL/   !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : --- 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
       IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofct.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NPOINS,NDIM
      DOUBLE PRECISION  COORDS(NPOINS,NDIM)
C
C.. Variables internes
      INTEGER N,I,J,IERR
      CHARACTER CH1*39
C
C***********************************************************************
C
C
C
C     1- Recherche de la rubrique contenant la table des noeuds
C     -----------------------------------------------------------
      IERR = 0
      CALL SECGRF(NFSGCT,'C$ RUBRIQUE = NOEUDS',20,IERR)
C
C     2- Coordonnees et references
C     ------------------------------
      DO 220 N=1,NPOINS
       READ(NFSGCT,2000) CH1,I,(COORDS(N,J),J=1,NDIM)
  220 CONTINUE
C
C
C--------
C FORMATS
C--------
 2000 FORMAT(A39,I3,1X,3E10.4)
C
C
      END
