C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=MATELC,SSI=0
C
                     SUBROUTINE MATELC
C                    ***************** 
C
C     ------------------------------------------------------
     *( OP,DMAT,XMAT,COEFMA,NODES,COORDS,VOLUME,
     *  NELEMS,NPOINS,NDMATS,NDIM,NDIELE,NCOEMA,
     *  WCT )
C     ------------------------------------------------------
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     CALCUL DES MATRICES ELEMENTAIRES POUR             *
C                    PROBLEMES COQUES                                  *
C                                                                      *
C                                                                      *
C                                                                      *
C      On s'appuit sur les travaux effectuees par  J.P. GREGOIRE       *
C      portant sur l'integration analytique des matrices elementaires  *  
C      matrices elementaires par les formules de Zienkiewicz           *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   OP      !  A   ! D  ! DEFINITION DU TYPE D'OPERATION           !
C   !   DMAT    !  TR  ! R  ! DIAGONALE DE LA MATRICE M                !
C   !   XMAT    !  TR  ! R  ! TERMES EXTRA DIAGONAUX DE LA MATRICE M   !
C   !   COEFMA  !  TR  ! D  ! COEFFICIENTS DES MATRICES                !
C   !           !      !    !  coefma(n) = rho Cp / dt pour masse      !
C   !           !      !    !  coefma(n) = k (conductivite) pour diffu !
C   !   COORDS  !  TR  ! D  ! COORDONNEES DU MAILLAGE                  !
C   !   NODES   !  TE  ! D  ! CORRESPONDANCE NOEUDS LOCAUX GLOBAUX     !
C   !   VOLUME  !  TR  ! D  ! SURFACE DU TRIANGLE EN 2D                !
C   !           !      !    ! VOLUME DU TETRAEDRE EN 3D                ! 
C   !   W1...W6 !  TR  ! M  ! TABLEAUX DE TRAVAIL (TAILLE: NELMXS )    !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ASSEMB,OV
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "optct.h"
C    
C***********************************************************************
C
C..Variables externes
      CHARACTER*8 OP
      INTEGER NELEMS,NDMATS,NPOINS,NDIM,NDIELE,NCOEMA
C
      INTEGER NODES(NELEMS,NDMATS)
      DOUBLE PRECISION COORDS(NPOINS,NDIM)   
      DOUBLE PRECISION DMAT(NPOINS),COEFMA(NPOINS)
      DOUBLE PRECISION XMAT(NELEMS,NCOEMA)      
      DOUBLE PRECISION WCT(NELEMS,NDMATS)
      DOUBLE PRECISION VOLUME(NELEMS)    
C
C.. Variables internes
      DOUBLE PRECISION ZERO
      INTEGER I
      INTEGER N1,N2,N3,N4,N5,N6 
      DOUBLE PRECISION S3,SV1,S240,SV240
      DOUBLE PRECISION X45,Y45,Z45,X46,Y46,Z46,X65,Y65,Z65
      DOUBLE PRECISION RC1,RC2,RC3,RC4,RC5,RC6
      DOUBLE PRECISION XK1,XK2,XK3,XK4,XK5,XK6
      DOUBLE PRECISION XKM1,XKM2,XKM3,XKM4
      DOUBLE PRECISION ALFA1,ALFA2,ALFA3
C    
C***********************************************************************
C
C     INITIALISATIONS
C     ================
C
      ZERO = 0.D0
      S240 = 1.D0 / 240.D0 
C     
C     1- CAS COQUE
C     ============
C     
C      1.1  CONSTRUCTION DE LA MATRICE DE MASSE ELEMENTAIRE
C      ===============================================
C
       IF ( OP(1:8).EQ.'MASSE   ' ) THEN
C         
C  
         DO 111 I=1,NELEMS
C
C
           N1 = NODES(I,1)
           N2 = NODES(I,2)
           N3 = NODES(I,3)
           N4 = NODES(I,4)
           N5 = NODES(I,5)
           N6 = NODES(I,6)
C
C   
           RC1 = COEFMA(N1)
           RC2 = COEFMA(N2)
           RC3 = COEFMA(N3) 
           RC4 = COEFMA(N4)
           RC5 = COEFMA(N5)
           RC6 = COEFMA(N6)     
C
C          Calcul des termes diagonaux (mass-lumpe)
C          ----------------------------------------
C          
           SV240 = S240 * VOLUME(I)           
C
C
           WCT(I,1) =  SV240 * ( 10*RC1 + 5*(RC4+RC6) )
           WCT(I,2) =  SV240 * ( 5*(RC4+RC5) + 10*RC2 )
           WCT(I,3) =  SV240 * ( 5*(RC5+RC6) + 10*RC3 )
           WCT(I,4) =  SV240 * ( 5*(RC1+RC2) + 30*RC4 + 10*(RC5+RC6) )
           WCT(I,5) =  SV240 * ( 5*(RC2+RC3) + 30*RC5 + 10*(RC4+RC6) )
           WCT(I,6) =  SV240 * ( 5*(RC1+RC3) + 30*RC6 + 10*(RC4+RC5) )        
C
  111    CONTINUE      
C
C
        CALL OV ( 'X=C     ',DMAT,DMAT,DMAT,ZERO,NPOINS )
        CALL ASSEMB ( DMAT,NODES,NELEMS,NDIELE,NPOINS,NDMATS,WCT)
C      
C
C      1.2 CONSTRUCTION DE LA MATRICE DE DIFFUSION ELEMENTAIRE
C          ===================================================
C  
       ELSE IF ( OP(1:8).EQ.'DIFFU   ' ) THEN      
C
         S3 = 1.D0 / 3.D0
C
         DO 121 I=1,NELEMS
C
C
           N1 = NODES(I,1)
           N2 = NODES(I,2)
           N3 = NODES(I,3)
           N4 = NODES(I,4)
           N5 = NODES(I,5)
           N6 = NODES(I,6)
C
C   
           XK1 = COEFMA(N1)
           XK2 = COEFMA(N2)
           XK3 = COEFMA(N3)
           XK4 = COEFMA(N4)
           XK5 = COEFMA(N5)
           XK6 = COEFMA(N6)
C
C          Calcul des termes diagonaux
C          ---------------------------
C               
           SV1 = 1.D0 / VOLUME(I) 
C                                                                       
C                                                                       
           X45 = COORDS(N5,1) - COORDS(N4,1)
           Y45 = COORDS(N5,2) - COORDS(N4,2)
           Z45 = COORDS(N5,3) - COORDS(N4,3)
           X46 = COORDS(N6,1) - COORDS(N4,1)
           Y46 = COORDS(N6,2) - COORDS(N4,2)
           Z46 = COORDS(N6,3) - COORDS(N4,3)
           X65 = COORDS(N5,1) - COORDS(N6,1)
           Y65 = COORDS(N5,2) - COORDS(N6,2)
           Z65 = COORDS(N5,3) - COORDS(N6,3)
C
           ALFA1 =  SV1 * (X45*X65 + Y45*Y65 + Z45*Z65 )
           ALFA2 = -SV1 * (X46*X65 + Y46*Y65 + Z46*Z65 )
           ALFA3 =  SV1 * (X46*X45 + Y46*Y45 + Z46*Z45 ) 
C                                                                       
C                                                                       
           XKM1 = S3 * (XK1+XK4+XK6)                             
           XKM2 = S3 * (XK4+XK2+XK5)                             
           XKM3 = S3 * (XK5+XK3+XK6)                            
           XKM4 = S3 * (XK4+XK5+XK6)                             
C
C
           WCT(I,1) =  (ALFA2+ALFA3)*XKM1
           WCT(I,2) =  (ALFA1+ALFA3)*XKM2
           WCT(I,3) =  (ALFA1+ALFA2)*XKM3
           WCT(I,4) =  ALFA1*(XKM1+XKM4) +
     &                 ALFA2*(XKM2+XKM4) +
     &                 ALFA3*(XKM1+XKM2)
           WCT(I,5) =  ALFA1*(XKM2+XKM3) +
     &                 ALFA2*(XKM4+XKM2) +
     &                 ALFA3*(XKM4+XKM3)
           WCT(I,6) =  ALFA1*(XKM1+XKM4) +
     &                 ALFA2*(XKM1+XKM3) +
     &                 ALFA3*(XKM4+XKM3) 
C
C          Calcul des termes extra-diagonaux
C          ----------------------------------
C
           XMAT(I,1) =  -ALFA3*XKM1
           XMAT(I,2) =  -ALFA2*XKM1
C
           XMAT(I,3) =  -ALFA3*XKM2
           XMAT(I,4) =  -ALFA1*XKM2
C
           XMAT(I,5) =  -ALFA1*XKM3
           XMAT(I,6) =  -ALFA2*XKM3
C
           XMAT(I,7) =  -ALFA2*(XKM2+XKM4)
           XMAT(I,8) =  -ALFA1*(XKM1+XKM4)
C
           XMAT(I,9) =  -ALFA3*(XKM3+XKM4)
C
  121    CONTINUE
C
C   
        CALL ASSEMB ( DMAT,NODES,NELEMS,NDIELE,NPOINS,NDMATS,WCT)
C      
C      
C      ---- FIN DU CALCUL DES MATRICES POUR PROBLEMES COQUES ---
C      
       ELSE
       PRINT*,'MATELE erreur dans expression de diffusion coque',OP
       ENDIF
C
C------ 
C FORMAT
C------
C
C
      RETURN
      END

