C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE CORAY2
C                       *****************
C
C      --------------------------------------------------------------
     *  (NDIM,NDMA1,NP1,COOR1,NEL1,NOD1,NGL1,NGLOB1,NC1,BARY1,
     *        NDMA2,NP2,COOR2,NEL2,NOD2,NREF2,NGL2,NGLOB2,NC2,BARY2,
     *        IREF,IIR,INDGLO)
C      --------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            ETABLISSEMENT DE LA TABLE DE CORRESPONDANCE ENTRE LES     *
C            MAILLAGES POUR LE RAYONNEMENT CONFINE                     *
C            ALGORITHME PENIGUEL/RUPP                                  *
C                                                                      *
C            1 : maillage fin                                          *
C            2 : maillage grossier                                     *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     !  E ! D  ! DIMENSION DU PROBLEME                        !
C !  INDGLO   !  E ! D  ! =0 => il faut rechercher les numeros globaux !
C !           !    !    ! =1 => on a directement les coordonnees       !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : DPTTRI, CBARY3
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
      INTEGER    N64
      PARAMETER (N64 = 128)
C***********************************************************************
C     DONNEES EN COMMON  (VOIR LA SIGNIFICATION COMPLETE DANS LECDON)
C **********************************************************************
C
#include "nlofes.h"
#include "optct.h"
#include "mobil.h"
#include "xrefer.h"
C
C***********************************************************************
C.. Variables externes
       INTEGER NDIM,NP1,NEL1,NDMA1,NGL1,NP2,NEL2,NDMA2,NGL2
       INTEGER NOD1(NEL1,NDMA1),NGLOB1(NGL1),NC1(NGL1)
       INTEGER NOD2(NEL2,NDMA2),NGLOB2(NGL2),NREF2(NEL2),NC2(NGL2,2)
       DOUBLE PRECISION COOR1(NP1,NDIM),COOR2(NP2,NDIM)
       DOUBLE PRECISION BARY1(NGL1,NDIM),BARY2(NGL2,NDIM)
       INTEGER IIR,IREF(IIR),INDGLO
C
C
C.. Variables internes
      INTEGER ICODE,NUMSEG
      INTEGER N,NPF,NA,NB,NF,NS
      INTEGER NELMIN,N1MIN,N2MIN,N3MIN,NPS
      INTEGER NBBOUC,NLONV,IDEB,I
C
      DOUBLE PRECISION XA,YA,XB,YB
      DOUBLE PRECISION XP1,YP1
      DOUBLE PRECISION XX,YY,DIST
      DOUBLE PRECISION XMIN,YMIN,DMIN
      DOUBLE PRECISION X1,Y1,X2,Y2,X3,Y3
C
C
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
      IF (NGL1.EQ.0 .OR. NGL2.EQ.0) RETURN
C
      DO 1 N=1,NGL2*NDIM
        BARY2(N,1) = 0.D0
    1 CONTINUE
C
C
      IF (NBLBLR.GE.3) WRITE(NFECRA,1000)
C
      DO 100 NPF=1,NGL1
C
        DMIN   = 1.D6
        XMIN   = 0.D0
        YMIN   = 0.D0
        NELMIN = 1               
        N1MIN  = 0
        N2MIN  = 0
        N3MIN  = 0
C    
        IF (INDGLO.EQ.1) THEN
          NF = NGLOB1(NPF)
        ELSE
          NF = NPF
        ENDIF
C
        XP1 = COOR1(NF,1)
        YP1 = COOR1(NF,2)
C
        NBBOUC = (NEL2/N64)
        NLONV  = N64
C
        DO 110 N=1,NBBOUC+1
         IDEB = (N-1)*N64
         IF (N.EQ.NBBOUC+1) NLONV = MOD(NEL2,N64)
            
          DO 111 I=1,NLONV
C
            ICODE = 0
C
            IF (IREF(NREF2(IDEB+I)).EQ.0) THEN
              GOTO 111
            ENDIF
C
            NA = NOD2(IDEB+I,1)
            NB = NOD2(IDEB+I,2)
C
            XA = COOR2(NA,1)
            YA = COOR2(NA,2)
            XB = COOR2(NB,1)
            YB = COOR2(NB,2)
C
            CALL DPTSEG (XP1,YP1,XA,YA,XB,YB,DIST,XX,YY,ICODE)
C
            IF (ICODE.NE.0) THEN
               WRITE(NFECRA,1200) NF,XP1,YP1,IDEB+I,NA,NB
               STOP
            ENDIF
C
            IF (DIST.LT.DMIN) THEN
              DMIN   = DIST
              XMIN   = XX
              YMIN   = YY
              NELMIN = IDEB+I   
            ENDIF
C
  111    CONTINUE
C
  110   CONTINUE
C
         NC1(NPF) = NELMIN
         N1MIN = NOD2(NELMIN,1)
         N2MIN = NOD2(NELMIN,2)
C
         X1 = COOR2(N1MIN,1)
         Y1 = COOR2(N1MIN,2)
         X2 = COOR2(N2MIN,1)
         Y2 = COOR2(N2MIN,2)
         CALL CBARY2 (XMIN,YMIN,
     &                X1,Y1,X2,Y2,
     &                BARY1(NPF,1),BARY1(NPF,2))
C
         IF (NBLBLR.GE.11) THEN
         WRITE(NFECRA,1700) NF,XP1,YP1,
     &                      NELMIN,N1MIN,N2MIN,
     &                      XMIN,YMIN,DMIN,
     &                      BARY1(NPF,1),BARY1(NPF,2)
         ENDIF
C
C
  100 CONTINUE     
C
      IF (NBLBLR.GE.3) WRITE(NFECRA,2000)
C
C
      DO 200 NPS=1,NGL2
C
        NS = NGLOB2(NPS)
C
        XP1 = COOR2(NS,1)
        YP1 = COOR2(NS,2)
C
        DMIN   = 1.D6
        XMIN   = 0.D0
        YMIN   = 0.D0
        NELMIN = 1               
C
        NBBOUC = (NEL1/N64)
        NLONV  = N64
C
        DO 210 N=1,NBBOUC+1
         IDEB = (N-1)*N64
         IF (N.EQ.NBBOUC+1) NLONV = MOD(NEL1,N64)
C
         DO 211 I=1,NLONV
C
            ICODE = 0
C
            IF (INDGLO.EQ.1) THEN
              NA = NGLOB1(NOD1(IDEB+I,1))
              NB = NGLOB1(NOD1(IDEB+I,2))
            ELSE
              NA = NOD1(IDEB+I,1)
              NB = NOD1(IDEB+I,2)
            ENDIF
C
            XA = COOR1(NA,1)
            YA = COOR1(NA,2)
            XB = COOR1(NB,1)
            YB = COOR1(NB,2)
C
            CALL DPTSEG (XP1,YP1,XA,YA,XB,YB,DIST,XX,YY,ICODE)
C
            IF (ICODE.NE.0) THEN
              IF (INDGLO.EQ.1) THEN
                WRITE(NFECRA,2200) NPS,XP1,YP1,IDEB+I,
     *                     NGLOB1(NA),NGLOB1(NB)
              ELSE
                WRITE(NFECRA,2200) NPS,XP1,YP1,IDEB+I,NA,NB
              ENDIF
              STOP
            ENDIF
C
            IF (DIST.LT.DMIN) THEN
               DMIN   = DIST
               XMIN   = XX
               YMIN   = YY
               NELMIN = IDEB+I               
            ENDIF
C
  211      CONTINUE
  210    CONTINUE
C
C
         IF (INDGLO.EQ.1) THEN
           N1MIN  = NGLOB1(NOD1(NELMIN,1))
           N2MIN  = NGLOB1(NOD1(NELMIN,2))
         ELSE
           N1MIN  = NOD1(NELMIN,1)
           N2MIN  = NOD1(NELMIN,2)
         ENDIF
C
         X1 = COOR1(N1MIN,1)
         Y1 = COOR1(N1MIN,2)
         X2 = COOR1(N2MIN,1)
         Y2 = COOR1(N2MIN,2)
C
         IF (NDMA1.EQ.3) THEN
           IF (INDGLO.EQ.1) THEN
             N3MIN  = NGLOB1(NOD1(NELMIN,3))
           ELSE
             N3MIN  = NOD1(NELMIN,3)
           ENDIF

           X3 = COOR1(N3MIN,1)
           Y3 = COOR1(N3MIN,2)
C
           CALL SOUSEG (XMIN,YMIN,X1,Y1,X2,Y2,NUMSEG)
C
           IF (NUMSEG.EQ.1) THEN
            CALL CBARY2 (XMIN,YMIN,
     &                   X1,Y1,X3,Y3,
     &                   BARY2(NPS,1),BARY2(NPS,2))
           ELSE
            CALL CBARY2 (XMIN,YMIN,
     &                   X2,Y2,X3,Y3,
     &                   BARY2(NPS,1),BARY2(NPS,2))
           ENDIF
C
         ELSE
            NUMSEG = 0
            CALL CBARY2 (XMIN,YMIN,
     &                   X1,Y1,X2,Y2,
     &                   BARY2(NPS,1),BARY2(NPS,2))
         ENDIF
C
         NC2(NPS,1) = NELMIN
         NC2(NPS,2) = NUMSEG
C   
         IF (NBLBLR.GE.11) THEN
         WRITE(NFECRA,2700) NS,XP1,YP1,
     &                      NELMIN,N1MIN,N2MIN,
     &                      XMIN,YMIN,DMIN,
     &                      BARY2(NPS,1),BARY2(NPS,2)
         ENDIF
C
C
  200 CONTINUE     
C
C--------
C FORMATS
C--------
C
 1000 FORMAT(/,' *** CORAY2 :',/,
     &      5X,'Recherche des correspondances pour le rayonnement ',
     &         'confine : phase 1'/)
 1200 FORMAT(/,' %% ERREUR CORAY2 : LA RECHERCHE DU CORRESPONDANT A ',
     &        'ECHOUEE : ',/,
     &        '                     POINT FIN :',I6,/,
     &        '                                ',2G10.3,/,
     &        '      DANS LE SEGMENT GROSSIER :',I6,/,
     &        '                                ',2I6)
 1700 FORMAT(/,'    NOEUD FIN :',I6,', coordonnees :',2G10.3,/,
     &       'CORRESPONDANT GROSSIER :',/,
     &       '          numero du segment grossier :',I6,/,
     &       '                              noeuds :',I6,' ',I6,/,
     &       '        coord du point correspondant :',2G10.3,/,
     &       '                   distance minimale :',G10.3,/,
     &       '                coord barycentriques :',2G10.3)
C
 2000 FORMAT(/,' *** CORAY2 :',/,
     &     5X,'Recherche des correspondances pour le rayonnement ',
     &         'confine : phase 2'/)
 2200 FORMAT(/,' %% ERREUR CORAY2 : LA RECHERCHE DU CORRESPONDANT A ',
     &        'ECHOUEE : ',/,
     &        '                POINT GROSSIER :',I6,/,
     &        '                                ',2G10.3,/,
     &        '           DANS LE SEGMENT FIN :',I6,/,
     &        '                                ',2I6)
 2700 FORMAT(/,'NOEUD GROSSIER :',I6,', coordonnees :',2G10.3,/,
     &       '      CORRESPONDANT FIN :',/,
     &       '               numero du segment fin :',I6,/,
     &       '                              noeuds :',I6,' ',I6,/,
     &       '        coord du point correspondant :',2G10.3,/,
     &       '                   distance minimale :',G10.3,/,
     &       '                coord barycentriques :',2G10.3)
C
C
C----
C FIN
C----
      END
          
