/*
 * synaptiks -- a touchpad control tool
 *
 *
 * Copyright (C) 2010 Sebastian Wiesner <basti.wiesner@gmx.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SYNAPTIKSKCM_H
#define SYNAPTIKSKCM_H

#include <KCModule>

namespace synaptiks {
    class SynaptiksConfiguration;

    /**
     * @brief Provide a configuration module for @b synaptiks.
     */
    class SynaptiksKCM: public KCModule {
        Q_OBJECT

    public:
        /**
         * @brief Create a new configuration module.
         *
         * @param parent the parent object
         * @param args ignored, required by kde plugin architecture.
         */
        SynaptiksKCM(QWidget *parent, const QList<QVariant> &args);

    public Q_SLOTS:
        /**
         * @brief Called to save the configuration.
         *
         * After saving the configuration, this function connects to the @b
         * synaptiks daemon on the DBus session bus and tells it to re-read
         * its configuration.
         */
        virtual void save();

    private:
        /**
         * @brief Setup the user interface of this module
         */
        void setupUi();

        /**
         * @brief Show the given @p error message.
         *
         * This deletes @e any currently displayed widget within this module
         * and shows the error message on top level.  The user interface is
         * basically disabled.  Use this for fatal errors (e.g. missing
         * D-Bus connectivity).
         *
         * @param message a human-readable error message
         */
        void showError(const QString &message);

        SynaptiksConfiguration *config;
    };
}

#endif /* SYNAPTIKSKCM_H */
