
from dolfin import *

class Source(Function): 
    def eval(self, values, x): 
        values[0] = x[0]
        values[1] = x[1]
        values[2] = 2
        values[3] = 100 

mesh = UnitSquare(12,12)

element0 = FunctionSpace(mesh, "DG", 0)
element1 = TensorFunctionSpace(mesh, "CG",  1)
element2 = TensorFunctionSpace(mesh, "CG", 2)

u = TrialFunction(element1)
v = TestFunction(element1)
c = Function(element0)
f = Function(element2)

c.vector()[:] = 1 
f.vector()[:] = 1 

a = c*inner(u,v)*dx
L = inner(f,v)*dx

A = assemble(a)
b = assemble(L)

u = Function(element1)

file 

solve(A, u.vector(),b)





